/*
 * Decompiled with CFR 0.152.
 */
package com.jparams.object.builder.provider;

import com.jparams.object.builder.Context;
import com.jparams.object.builder.provider.Provider;
import com.jparams.object.builder.type.Type;
import com.jparams.object.builder.type.TypeResolver;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class InterfaceProvider
implements Provider {
    @Override
    public boolean supports(Type<?> type) {
        return type.getJavaType().isInterface();
    }

    @Override
    public Object provide(Context context) {
        ResponseBuildingInvocationHandler invocationHandler = new ResponseBuildingInvocationHandler(context);
        Class<?> type = context.getPath().getType().getJavaType();
        return Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, (InvocationHandler)invocationHandler);
    }

    private static class ResponseBuildingInvocationHandler
    implements InvocationHandler {
        private final Context context;
        private final Map<Method, Object> cache = new HashMap<Method, Object>();

        ResponseBuildingInvocationHandler(Context context) {
            this.context = context;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            if (this.cache.containsKey(method)) {
                return this.cache.get(method);
            }
            String methodName = String.format("%s(%s)", method.getName(), args == null || args.length == 0 ? "" : Arrays.toString(args));
            Type<?> type = TypeResolver.resolveReturnType(this.context.getPath(), method);
            if (type == null) {
                this.cache.put(method, null);
                return null;
            }
            Object returnValue = this.context.createChild(methodName, type);
            this.cache.put(method, returnValue);
            return returnValue;
        }
    }
}

