/*
 * Decompiled with CFR 0.152.
 */
package com.jparams.object.builder.provider;

import com.jparams.object.builder.Context;
import com.jparams.object.builder.provider.Provider;
import com.jparams.object.builder.type.Type;
import java.util.Collections;
import java.util.List;

public class ListProvider
implements Provider {
    @Override
    public boolean supports(Type<?> type) {
        return type.getJavaType().isAssignableFrom(List.class);
    }

    @Override
    public List<?> provide(Context context) {
        if (context.getPath().getType().getGenerics().isEmpty()) {
            context.logWarning("No generics found. Could not populate List");
            return Collections.emptyList();
        }
        Type<?> type = context.getPath().getType().getGenerics().get(0).getType();
        Object child = context.createChild("[0]", type);
        return Collections.singletonList(child);
    }
}

