/*
 * Decompiled with CFR 0.152.
 */
package com.jparams.object.builder.provider;

import com.jparams.object.builder.Context;
import com.jparams.object.builder.provider.Provider;
import com.jparams.object.builder.type.Type;
import java.util.Collections;
import java.util.Map;

public class MapProvider
implements Provider {
    @Override
    public boolean supports(Type<?> type) {
        return type.getJavaType().isAssignableFrom(Map.class);
    }

    @Override
    public Map<?, ?> provide(Context context) {
        if (context.getPath().getType().getGenerics().size() < 2) {
            context.logWarning("No generics found. Could not populate Map");
            return Collections.emptyMap();
        }
        Type<?> keyType = context.getPath().getType().getGenerics().get(0).getType();
        Type<?> valueType = context.getPath().getType().getGenerics().get(1).getType();
        Object key = context.createChild("[0.key]", keyType);
        Object value = context.createChild("[0.value]", valueType);
        return Collections.singletonMap(key, value);
    }
}

