/*
 * Decompiled with CFR 0.152.
 */
package com.jparams.object.builder.provider;

import com.jparams.object.builder.BuildStrategy;
import com.jparams.object.builder.Context;
import com.jparams.object.builder.path.Path;
import com.jparams.object.builder.provider.Provider;
import com.jparams.object.builder.type.Type;
import com.jparams.object.builder.type.TypeMap;
import com.jparams.object.builder.type.TypeResolver;
import com.jparams.object.builder.utils.ObjectUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Optional;

public class ObjectProvider
implements Provider {
    private final BuildStrategy defaultStrategy;
    private final TypeMap<BuildStrategy> strategyMap;

    public ObjectProvider(BuildStrategy defaultStrategy, TypeMap<BuildStrategy> strategyMap) {
        this.defaultStrategy = defaultStrategy;
        this.strategyMap = strategyMap;
    }

    @Override
    public boolean supports(Type<?> type) {
        return !type.getJavaType().isPrimitive() && !type.getJavaType().isEnum() && !type.getJavaType().isInterface() && !Modifier.isAbstract(type.getJavaType().getModifiers());
    }

    @Override
    public Object provide(Context context) {
        BuildStrategy strategy = this.strategyMap.findMatch(context.getPath().getType()).orElse(this.defaultStrategy);
        switch (strategy) {
            case CONSTRUCTOR: {
                return this.createInstanceWithConstructor(context, true);
            }
            case FIELD_INJECTION: {
                return this.createInstanceWithFieldInjection(context);
            }
            case AUTO: {
                return this.createInstanceWithFallback(context);
            }
        }
        context.logError("Unknown injection strategy " + (Object)((Object)strategy));
        return null;
    }

    private Object createInstanceWithFallback(Context context) {
        Object created = this.createInstanceWithConstructor(context, false);
        return created == null ? this.createInstanceWithFieldInjection(context) : created;
    }

    private Object createInstanceWithConstructor(Context context, boolean logOnFailure) {
        Optional<Constructor> constructor = Arrays.stream(context.getPath().getType().getJavaType().getDeclaredConstructors()).sorted(Comparator.comparingInt(Constructor::getParameterCount)).peek(c -> c.setAccessible(true)).findFirst();
        if (constructor.isPresent()) {
            return this.createInstanceWithConstructor(context, constructor.get(), logOnFailure);
        }
        if (logOnFailure) {
            context.logError("No constructor found");
        }
        return null;
    }

    private Object createInstanceWithConstructor(Context context, Constructor<?> constructor, boolean logOnFailure) {
        String name = String.format("%s(%s)", context.getPath().getType().getJavaType().getSimpleName(), this.getParametersString(constructor));
        Object[] arguments = new Object[constructor.getParameters().length];
        for (int i = 0; i < constructor.getParameters().length; ++i) {
            Parameter parameter = constructor.getParameters()[i];
            Type<?> type = TypeResolver.resolveParameterType(context.getPath(), parameter);
            arguments[i] = context.createChild(name + "[" + i + "]", type);
        }
        try {
            return constructor.newInstance(arguments);
        }
        catch (Exception e) {
            if (logOnFailure) {
                context.logError("Failed to build an instance using the constructor build strategy", e);
            }
            return null;
        }
    }

    private String getParametersString(Constructor<?> constructor) {
        return Arrays.stream(constructor.getParameters()).map(param -> param.getType().getSimpleName() + " " + param.getName()).reduce((item1, item2) -> item1 + ", " + item2).orElse("");
    }

    private Object createInstanceWithFieldInjection(Context context) {
        Class<?> type = context.getPath().getType().getJavaType();
        try {
            Object instance = ObjectUtils.createInstance(type);
            this.injectFields(instance, context);
            return instance;
        }
        catch (Exception e) {
            context.logError("Failed to build an instance using the field injection build strategy", e);
            return null;
        }
    }

    private void injectFields(Object object, Context context) {
        Path path = context.getPath();
        while (true) {
            Class<?> clazz = path.getType().getJavaType();
            for (Field field : clazz.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                try {
                    Type<?> type = TypeResolver.resolveFieldType(path, field);
                    Object instance = context.createChild(field.getName(), type);
                    field.setAccessible(true);
                    field.set(object, instance);
                }
                catch (Exception e) {
                    context.logError("Failed to inject field [" + field.getName() + "]", e);
                }
            }
            Type<?> superClass = TypeResolver.resolveType(path, clazz.getGenericSuperclass());
            if (superClass == null) {
                return;
            }
            path = new Path("$super", superClass, path);
        }
    }
}

