/*
 * Decompiled with CFR 0.152.
 */
package com.jparams.object.builder.type;

import com.jparams.object.builder.type.Generic;
import com.jparams.object.builder.utils.CollectionUtils;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class Type<T> {
    private final Class<T> javaType;
    private final List<Generic> generics;

    Type(Class<T> javaType, List<Generic> generics) {
        this.javaType = javaType;
        this.generics = CollectionUtils.unmodifiableCopy(generics);
    }

    public Class<T> getJavaType() {
        return this.javaType;
    }

    public List<Generic> getGenerics() {
        return this.generics;
    }

    public Type<T> withGenerics(List<Type<?>> genericTypes) throws IllegalArgumentException {
        List aliases = Arrays.stream(this.javaType.getTypeParameters()).map(TypeVariable::getName).collect(Collectors.toList());
        if (aliases.size() != genericTypes.size()) {
            throw new IllegalArgumentException("Expected " + aliases.size() + " generics, got " + genericTypes.size());
        }
        List<Generic> generics = IntStream.range(0, aliases.size()).mapToObj(i -> new Generic((String)aliases.get(i), (Type)genericTypes.get(i))).collect(Collectors.toList());
        return new Type<T>(this.javaType, generics);
    }

    public Type<T> withGenerics(Type<?> ... generics) throws IllegalArgumentException {
        return this.withGenerics(Arrays.asList(generics));
    }

    public Type<T> withGenerics(Class<?> ... generics) throws IllegalArgumentException {
        return this.withGenerics(Arrays.stream(generics).map(Type::forClass).collect(Collectors.toList()));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Type that = (Type)other;
        return Objects.equals(this.javaType, that.javaType) && Objects.equals(this.generics, that.generics);
    }

    public int hashCode() {
        return Objects.hash(this.javaType, this.generics);
    }

    public static <T> Type<T> forClass(Class<T> clazz) {
        return new Type<T>(clazz, Collections.emptyList());
    }

    public String toString() {
        String simpleName = this.javaType.getSimpleName();
        if (this.generics.isEmpty()) {
            return simpleName;
        }
        return simpleName + "<" + this.generics.stream().map(Generic::toString).reduce((o1, o2) -> o1 + ", " + o2).orElse("") + ">";
    }
}

