/*
 * Decompiled with CFR 0.152.
 */
package com.jparams.object.builder.type;

import com.jparams.object.builder.path.Path;
import com.jparams.object.builder.type.Generic;
import com.jparams.object.builder.type.Type;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class TypeResolver {
    private TypeResolver() {
    }

    public static Type<?> resolveReturnType(Path path, Method method) {
        if (method.getReturnType().equals(Void.TYPE)) {
            return null;
        }
        return TypeResolver.resolveType(path, method.getGenericReturnType());
    }

    public static Type<?> resolveFieldType(Path path, Field field) {
        return TypeResolver.resolveType(path, field.getGenericType());
    }

    public static Type<?> resolveParameterType(Path path, Parameter parameter) {
        return TypeResolver.resolveType(path, parameter.getParameterizedType());
    }

    public static Type<?> resolveType(java.lang.reflect.Type type) {
        return TypeResolver.resolveType(null, type);
    }

    public static Type<?> resolveType(Path path, java.lang.reflect.Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return TypeResolver.resolve(path, parameterizedType);
        }
        if (type instanceof Class) {
            return new Type((Class)type, Collections.emptyList());
        }
        if (type instanceof TypeVariable && path != null) {
            String name = ((TypeVariable)type).getName();
            return path.getType().getGenerics().stream().filter(generic -> generic.getAlias().equals(name)).findFirst().map(Generic::getType).orElse(null);
        }
        return null;
    }

    private static Type<?> resolve(Path path, ParameterizedType parameterizedType) {
        Class rawType = (Class)parameterizedType.getRawType();
        if (rawType.getTypeParameters().length != parameterizedType.getActualTypeArguments().length) {
            return new Type(rawType, null);
        }
        ArrayList<Generic> generics = new ArrayList<Generic>();
        List aliases = Arrays.stream(rawType.getTypeParameters()).map(TypeVariable::getName).collect(Collectors.toList());
        for (int i = 0; i < aliases.size(); ++i) {
            String alias = (String)aliases.get(i);
            Type<?> type = TypeResolver.resolveType(path, parameterizedType.getActualTypeArguments()[i]);
            generics.add(new Generic(alias, type));
        }
        return new Type(rawType, generics);
    }
}

