/*
 * Decompiled with CFR 0.152.
 */
package com.jparams.object.builder;

import com.jparams.object.builder.Build;
import com.jparams.object.builder.Context;
import com.jparams.object.builder.issue.IssueLogger;
import com.jparams.object.builder.path.Path;
import com.jparams.object.builder.path.PathFilter;
import com.jparams.object.builder.provider.Provider;
import com.jparams.object.builder.util.CollectionUtils;
import java.util.List;

class ObjectFactory {
    private final List<Provider> providers;
    private final PathFilter pathFilter;
    private final Provider nullProvider;
    private final int maxDepth;
    private final boolean failOnError;
    private final boolean failOnWarning;

    ObjectFactory(List<Provider> providers, Provider nullProvider, PathFilter pathFilter, int maxDepth, boolean failOnError, boolean failOnWarning) {
        this.providers = CollectionUtils.unmodifiableCopy(providers);
        this.nullProvider = nullProvider;
        this.pathFilter = pathFilter;
        this.maxDepth = maxDepth;
        this.failOnError = failOnError;
        this.failOnWarning = failOnWarning;
    }

    <T> Build<T> create(Path path) {
        return this.create(path, new IssueLogger(this.failOnError, this.failOnWarning));
    }

    <T> Build<T> create(Path path, IssueLogger issueLogger) {
        Context context = new Context(path, this, issueLogger);
        if (path.getDepth() > this.maxDepth) {
            context.logWarning("Max depth exhausted");
            return new Build<Object>(this.nullProvider.provide(context), issueLogger.getIssues());
        }
        if (!this.pathFilter.accept(path)) {
            return new Build<Object>(this.nullProvider.provide(context), issueLogger.getIssues());
        }
        try {
            Object obj = this.providers.stream().filter(provider -> provider.supports(path.getType())).map(provider -> provider.provide(context)).findFirst().orElse(this.nullProvider.provide(context));
            return new Build<Object>(obj, issueLogger.getIssues());
        }
        catch (Exception e) {
            return new Build<Object>(this.nullProvider.provide(context), issueLogger.getIssues());
        }
    }
}

