/*
 * Decompiled with CFR 0.152.
 */
package com.jparams.verifier.tostring;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Collectors;

final class PackageScanner {
    PackageScanner() {
    }

    public static List<Class<?>> findClasses(String packageName, boolean recursively) {
        Enumeration<URL> resources;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String path = packageName.replace('.', '/');
        try {
            resources = classLoader.getResources(path);
        }
        catch (IOException e) {
            throw new PackageScanException(e);
        }
        ArrayList<File> rootDirectories = new ArrayList<File>();
        while (resources.hasMoreElements()) {
            File directory = new File(resources.nextElement().getFile());
            rootDirectories.add(directory);
        }
        return rootDirectories.stream().map(rootDirectory -> PackageScanner.findClasses(rootDirectory, packageName, recursively)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static List<Class<?>> findClasses(File rootDirectory, String packageName, boolean recursively) {
        File[] files;
        if (!rootDirectory.exists() || (files = rootDirectory.listFiles()) == null) {
            return Collections.emptyList();
        }
        ArrayList classes = new ArrayList();
        for (File file : files) {
            if (file.isDirectory() && recursively) {
                String subPackageName = packageName + "." + file.getName();
                classes.addAll(PackageScanner.findClasses(file, subPackageName, true));
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            String className = packageName + '.' + file.getName().substring(0, file.getName().length() - 6);
            try {
                Class<?> clazz = Class.forName(className);
                classes.add(clazz);
            }
            catch (ClassNotFoundException e) {
                throw new PackageScanException(e);
            }
        }
        return classes;
    }

    private static class PackageScanException
    extends RuntimeException {
        PackageScanException(Throwable cause) {
            super(cause);
        }
    }
}

