/*
 * Decompiled with CFR 0.152.
 */
package com.jparams.verifier.tostring;

import com.jparams.object.builder.Build;
import com.jparams.object.builder.BuildStrategy;
import com.jparams.object.builder.Configuration;
import com.jparams.object.builder.ObjectBuilder;
import com.jparams.object.builder.type.Type;
import com.jparams.verifier.tostring.FieldFilter;
import com.jparams.verifier.tostring.FieldsProvider;
import com.jparams.verifier.tostring.Formatter;
import com.jparams.verifier.tostring.HashCodeProvider;
import com.jparams.verifier.tostring.InternalErrorException;
import com.jparams.verifier.tostring.NameStyle;
import com.jparams.verifier.tostring.PackageScanner;
import com.jparams.verifier.tostring.SystemIdentityHashCodeProvider;
import com.jparams.verifier.tostring.error.ClassNameVerificationError;
import com.jparams.verifier.tostring.error.ErrorMessageGenerator;
import com.jparams.verifier.tostring.error.FieldValue;
import com.jparams.verifier.tostring.error.FieldValueVerificationError;
import com.jparams.verifier.tostring.error.HashCodeVerificationError;
import com.jparams.verifier.tostring.error.VerificationError;
import com.jparams.verifier.tostring.preset.Preset;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ToStringVerifier {
    private static final int TEST_REPEAT_COUNT = 3;
    private static final Formatter<Object> DEFAULT_FORMATTER = String::valueOf;
    private final Configuration configuration;
    private final List<Class<?>> classes;
    private final Map<Class<?>, Formatter<Object>> formatterMap = new HashMap();
    private NameStyle nameStyle = null;
    private FieldFilter fieldFilter = null;
    private boolean inheritedFields = true;
    private boolean hashCode = false;
    private String nullValue = "null";
    private boolean failOnExcludedFields = false;
    private HashCodeProvider hashCodeProvider = new SystemIdentityHashCodeProvider();

    private ToStringVerifier(Collection<Class<?>> classes) {
        this.configuration = Configuration.defaultConfiguration().withDefaultBuildStrategy(BuildStrategy.AUTO).withFailOnError(false).withFailOnWarning(false);
        this.classes = classes.stream().filter(ToStringVerifier::isTestableClass).collect(Collectors.toList());
        this.classes.forEach(clazz -> this.configuration.withBuildStrategy(Type.forClass((Class)clazz), BuildStrategy.FIELD_INJECTION));
        if (this.classes.isEmpty()) {
            throw new IllegalArgumentException("No classes found to test. A class under test cannot be null, abstract, an interface or an enum.");
        }
    }

    public static ToStringVerifier forClass(Class<?> clazz) {
        ToStringVerifier.assertNotNull(clazz);
        return new ToStringVerifier(Collections.singletonList(clazz));
    }

    public static ToStringVerifier forClasses(Class<?> ... classes) {
        return ToStringVerifier.forClasses(Arrays.asList(classes));
    }

    public static ToStringVerifier forClasses(Collection<Class<?>> classes) {
        return new ToStringVerifier(classes);
    }

    public static ToStringVerifier forPackage(String packageName, boolean scanRecursively) {
        return ToStringVerifier.forPackage(packageName, scanRecursively, clazz -> true);
    }

    public static ToStringVerifier forPackage(String packageName, boolean scanRecursively, Predicate<Class<?>> predicate) {
        List<Class<?>> classes = PackageScanner.findClasses(packageName, scanRecursively).stream().filter(ToStringVerifier::isTestableClass).filter(predicate).collect(Collectors.toList());
        return new ToStringVerifier(classes);
    }

    public ToStringVerifier withPreset(Preset preset) {
        preset.apply(this);
        return this;
    }

    public ToStringVerifier withClassName(NameStyle nameStyle) {
        this.nameStyle = nameStyle;
        return this;
    }

    public ToStringVerifier withHashCode(boolean hashCode) {
        this.hashCode = hashCode;
        return this;
    }

    public ToStringVerifier withInheritedFields(boolean inheritedFields) {
        this.inheritedFields = inheritedFields;
        return this;
    }

    public ToStringVerifier withOnlyTheseFields(String ... fields) {
        HashSet<String> fieldNamesSet = new HashSet<String>(Arrays.asList(fields));
        return this.withOnlyTheseFields(fieldNamesSet);
    }

    public ToStringVerifier withOnlyTheseFields(Collection<String> fields) {
        ToStringVerifier.assertNotNull(fields);
        this.checkFieldPredicate();
        this.fieldFilter = (subject, field) -> fields.contains(field.getName());
        return this;
    }

    public ToStringVerifier withIgnoredFields(String ... fields) {
        return this.withIgnoredFields(new HashSet<String>(Arrays.asList(fields)));
    }

    public ToStringVerifier withIgnoredFields(Collection<String> fields) {
        ToStringVerifier.assertNotNull(fields);
        this.checkFieldPredicate();
        this.fieldFilter = (subject, field) -> !fields.contains(field.getName());
        return this;
    }

    public ToStringVerifier withMatchingFields(String regex) {
        this.checkFieldPredicate();
        this.fieldFilter = (subject, field) -> field.getName().matches(regex);
        return this;
    }

    public ToStringVerifier withMatchingFields(FieldFilter fields) {
        ToStringVerifier.assertNotNull(fields);
        this.fieldFilter = fields;
        return this;
    }

    public ToStringVerifier withFailOnExcludedFields(boolean failOnExcludedFields) {
        this.failOnExcludedFields = failOnExcludedFields;
        return this;
    }

    public <S> ToStringVerifier withPrefabValue(Class<S> type, S prefabValue) {
        this.configuration.withPrefabValue(Type.forClass(type), prefabValue);
        return this;
    }

    public <S> ToStringVerifier withFormatter(Class<S> clazz, Formatter<S> formatter) {
        ToStringVerifier.assertNotNull(clazz);
        ToStringVerifier.assertNotNull(formatter);
        Formatter<S> objectFormatter = formatter;
        this.formatterMap.put(clazz, objectFormatter);
        return this;
    }

    public ToStringVerifier withNullValue(String nullValue) {
        ToStringVerifier.assertNotNull(nullValue);
        this.nullValue = nullValue;
        return this;
    }

    public ToStringVerifier withHashCodeProvider(HashCodeProvider hashCodeProvider) {
        ToStringVerifier.assertNotNull(hashCodeProvider);
        this.hashCodeProvider = hashCodeProvider;
        return this;
    }

    public void verify() {
        for (int i = 0; i < 3; ++i) {
            String message = this.classes.stream().filter(Objects::nonNull).map(this::verify).filter(Optional::isPresent).map(Optional::get).reduce((message1, message2) -> message1 + "\n\n---\n\n" + message2).orElse(null);
            if (message != null) {
                throw new AssertionError((Object)("\n\n" + message));
            }
        }
    }

    private Optional<String> verify(Class<?> clazz) {
        List<FieldValue> fieldValues;
        Build build = ObjectBuilder.withConfiguration((Configuration)this.configuration).buildInstanceOf(clazz);
        Object subject = build.get();
        if (subject == null) {
            throw new AssertionError((Object)("Failed to create instance of " + clazz + ". Failed with error:\n" + build.getErrors()));
        }
        String stringValue = subject.toString();
        if (stringValue == null) {
            throw new AssertionError((Object)"toString method returned a null string");
        }
        ArrayList<VerificationError> verificationErrors = new ArrayList<VerificationError>();
        if (this.nameStyle != null) {
            this.verifyClassName(stringValue, this.nameStyle.getName(clazz)).ifPresent(verificationErrors::add);
        }
        if (this.hashCode) {
            this.verifyHashCode(stringValue, this.hashCodeProvider.provide(subject)).ifPresent(verificationErrors::add);
        }
        if (!(fieldValues = FieldsProvider.provide(clazz, this.inheritedFields).stream().map(field -> this.verifyField(subject, stringValue, (Field)field, this.fieldFilter == null || this.fieldFilter.matches(clazz, (Field)field))).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList())).isEmpty()) {
            verificationErrors.add(new FieldValueVerificationError(fieldValues));
        }
        if (verificationErrors.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(ErrorMessageGenerator.generateErrorMessage(clazz, stringValue, verificationErrors));
    }

    private Optional<VerificationError> verifyClassName(String stringValue, String className) {
        if (stringValue.startsWith(className)) {
            return Optional.empty();
        }
        return Optional.of(new ClassNameVerificationError(className));
    }

    private Optional<VerificationError> verifyHashCode(String stringValue, int hashCode) {
        if (stringValue.contains(String.valueOf(hashCode)) || stringValue.contains(Integer.toHexString(hashCode))) {
            return Optional.empty();
        }
        return Optional.of(new HashCodeVerificationError(hashCode));
    }

    private Optional<FieldValue> verifyField(Object subject, String stringValue, Field field, boolean expected) {
        List<String> values = this.getFieldValues(subject, field);
        String valuePattern = values.stream().map(Pattern::quote).reduce((val1, val2) -> val1 + "(.{0,4}?)" + val2).orElse("");
        String regex = String.format("(.*)%s(.{0,4}?)%s(.*)", Pattern.quote(field.getName()), valuePattern);
        Pattern pattern = Pattern.compile(regex, 32);
        boolean found = pattern.matcher(stringValue).matches();
        if (expected && !found || !expected && found && this.failOnExcludedFields) {
            FieldValue.ErrorType errorType = found ? FieldValue.ErrorType.UNEXPECTED : FieldValue.ErrorType.EXPECTED;
            String value = values.stream().reduce((val1, val2) -> val1 + ", " + val2).orElse("");
            FieldValue fieldValue = new FieldValue(field.getName(), value, errorType);
            return Optional.of(fieldValue);
        }
        return Optional.empty();
    }

    private List<String> getFieldValues(Object subject, Field field) {
        Object value;
        try {
            value = field.get(subject);
        }
        catch (IllegalAccessException e) {
            throw new InternalErrorException("Failed to access internals of test subject", e);
        }
        if (value == null) {
            return Collections.singletonList(this.nullValue);
        }
        if (Proxy.isProxyClass(value.getClass())) {
            return Collections.singletonList(value.toString());
        }
        if (value.getClass().isArray()) {
            return Stream.of((Object[])value).map(this::formatValue).collect(Collectors.toList());
        }
        if (value instanceof Collection) {
            return ((Collection)value).stream().map(this::formatValue).collect(Collectors.toList());
        }
        if (value instanceof Map) {
            return ((Map)value).entrySet().stream().map(entry -> String.format("%s=%s", this.formatValue(entry.getKey()), this.formatValue(entry.getValue()))).collect(Collectors.toList());
        }
        return Stream.of(value).map(this::formatValue).collect(Collectors.toList());
    }

    private String formatValue(Object value) {
        return value == null ? this.nullValue : this.formatterMap.getOrDefault(value.getClass(), DEFAULT_FORMATTER).format(value);
    }

    private void checkFieldPredicate() {
        if (this.fieldFilter != null) {
            throw new IllegalArgumentException("You can call either withOnlyTheseFields, withIgnoredFields or withMatchingFields, but not a combination of the three.");
        }
    }

    private static boolean isTestableClass(Class<?> clazz) {
        return clazz != null && !clazz.isEnum() && !clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers());
    }

    private static void assertNotNull(Object value) {
        if (value == null) {
            throw new IllegalArgumentException("Unexpected null value");
        }
    }
}

