/*
 * Decompiled with CFR 0.152.
 */
package com.astuetz;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.util.Pair;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.astuetz.pagerslidingtabstrip.R;
import java.util.Locale;

public class PagerSlidingTabStrip
extends HorizontalScrollView {
    private static final int[] ATTRS = new int[]{16842806, 16842901, 16842904, 16842965, 16842966, 16842968};
    private final PagerAdapterObserver adapterObserver = new PagerAdapterObserver();
    private static final int TEXT_COLOR_PRIMARY = 0;
    private static final int TEXT_SIZE_INDEX = 1;
    private static final int TEXT_COLOR_INDEX = 2;
    private static final int PADDING_INDEX = 3;
    private static final int PADDING_LEFT_INDEX = 4;
    private static final int PADDING_RIGHT_INDEX = 5;
    private LinearLayout.LayoutParams defaultTabLayoutParams;
    private LinearLayout.LayoutParams expandedTabLayoutParams;
    private final PageListener pageListener = new PageListener();
    private OnTabReselectedListener tabReselectedListener = null;
    public ViewPager.OnPageChangeListener delegatePageListener;
    private LinearLayout tabsContainer;
    private ViewPager pager;
    private int tabCount;
    private int currentPosition = 0;
    private float currentPositionOffset = 0.0f;
    private Paint rectPaint;
    private Paint dividerPaint;
    private int indicatorColor;
    private int indicatorHeight = 2;
    private int underlineHeight = 0;
    private int underlineColor;
    private int dividerWidth = 0;
    private int dividerPadding = 0;
    private int dividerColor;
    private int tabPadding = 12;
    private int tabTextSize = 14;
    private ColorStateList tabTextColor = null;
    private ColorStateList tabTextColorSelected = null;
    private int textAlpha = 150;
    private int paddingLeft = 0;
    private int paddingRight = 0;
    private boolean shouldExpand = false;
    private boolean textAllCaps = true;
    private boolean isPaddingMiddle = false;
    private Typeface tabTypeface = null;
    private int tabTypefaceStyle = 1;
    private int tabTypefaceSelectedStyle = 1;
    private int scrollOffset;
    private int lastScrollX = 0;
    private int tabBackgroundResId = R.drawable.psts_background_tab;
    private Locale locale;
    private ViewTreeObserver.OnGlobalLayoutListener firstTabGlobalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

        public void onGlobalLayout() {
            View view = PagerSlidingTabStrip.this.tabsContainer.getChildAt(0);
            if (Build.VERSION.SDK_INT < 16) {
                PagerSlidingTabStrip.this.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            } else {
                PagerSlidingTabStrip.this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
            if (PagerSlidingTabStrip.this.isPaddingMiddle) {
                int mHalfWidthFirstTab = view.getWidth() / 2;
                PagerSlidingTabStrip.this.paddingLeft = (PagerSlidingTabStrip.this.paddingRight = PagerSlidingTabStrip.this.getWidth() / 2 - mHalfWidthFirstTab);
            }
            PagerSlidingTabStrip.this.setPadding(PagerSlidingTabStrip.this.paddingLeft, PagerSlidingTabStrip.this.getPaddingTop(), PagerSlidingTabStrip.this.paddingRight, PagerSlidingTabStrip.this.getPaddingBottom());
            if (PagerSlidingTabStrip.this.scrollOffset == 0) {
                PagerSlidingTabStrip.this.scrollOffset = PagerSlidingTabStrip.this.getWidth() / 2 - PagerSlidingTabStrip.this.paddingLeft;
            }
            PagerSlidingTabStrip.this.currentPosition = PagerSlidingTabStrip.this.pager.getCurrentItem();
            PagerSlidingTabStrip.this.currentPositionOffset = 0.0f;
            PagerSlidingTabStrip.this.scrollToChild(PagerSlidingTabStrip.this.currentPosition, 0);
            PagerSlidingTabStrip.this.updateSelection(PagerSlidingTabStrip.this.currentPosition);
        }
    };

    public PagerSlidingTabStrip(Context context) {
        this(context, null);
    }

    public PagerSlidingTabStrip(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PagerSlidingTabStrip(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        int textPrimaryColor;
        this.setFillViewport(true);
        this.setWillNotDraw(false);
        this.tabsContainer = new LinearLayout(context);
        this.tabsContainer.setOrientation(0);
        this.tabsContainer.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.addView((View)this.tabsContainer);
        DisplayMetrics dm = this.getResources().getDisplayMetrics();
        this.scrollOffset = (int)TypedValue.applyDimension((int)1, (float)this.scrollOffset, (DisplayMetrics)dm);
        this.indicatorHeight = (int)TypedValue.applyDimension((int)1, (float)this.indicatorHeight, (DisplayMetrics)dm);
        this.underlineHeight = (int)TypedValue.applyDimension((int)1, (float)this.underlineHeight, (DisplayMetrics)dm);
        this.dividerPadding = (int)TypedValue.applyDimension((int)1, (float)this.dividerPadding, (DisplayMetrics)dm);
        this.tabPadding = (int)TypedValue.applyDimension((int)1, (float)this.tabPadding, (DisplayMetrics)dm);
        this.dividerWidth = (int)TypedValue.applyDimension((int)1, (float)this.dividerWidth, (DisplayMetrics)dm);
        this.tabTextSize = (int)TypedValue.applyDimension((int)2, (float)this.tabTextSize, (DisplayMetrics)dm);
        TypedArray a = context.obtainStyledAttributes(attrs, ATTRS);
        this.tabTextSize = a.getDimensionPixelSize(1, this.tabTextSize);
        ColorStateList colorStateList = a.getColorStateList(2);
        this.underlineColor = textPrimaryColor = a.getColor(0, 17170443);
        this.dividerColor = textPrimaryColor;
        this.indicatorColor = textPrimaryColor;
        int padding = a.getDimensionPixelSize(3, 0);
        this.paddingLeft = padding > 0 ? padding : a.getDimensionPixelSize(4, 0);
        this.paddingRight = padding > 0 ? padding : a.getDimensionPixelSize(5, 0);
        a.recycle();
        a = context.obtainStyledAttributes(attrs, R.styleable.PagerSlidingTabStrip);
        this.indicatorColor = a.getColor(R.styleable.PagerSlidingTabStrip_pstsIndicatorColor, this.indicatorColor);
        this.underlineColor = a.getColor(R.styleable.PagerSlidingTabStrip_pstsUnderlineColor, this.underlineColor);
        this.dividerColor = a.getColor(R.styleable.PagerSlidingTabStrip_pstsDividerColor, this.dividerColor);
        this.dividerWidth = a.getDimensionPixelSize(R.styleable.PagerSlidingTabStrip_pstsDividerWidth, this.dividerWidth);
        this.indicatorHeight = a.getDimensionPixelSize(R.styleable.PagerSlidingTabStrip_pstsIndicatorHeight, this.indicatorHeight);
        this.underlineHeight = a.getDimensionPixelSize(R.styleable.PagerSlidingTabStrip_pstsUnderlineHeight, this.underlineHeight);
        this.dividerPadding = a.getDimensionPixelSize(R.styleable.PagerSlidingTabStrip_pstsDividerPadding, this.dividerPadding);
        this.tabPadding = a.getDimensionPixelSize(R.styleable.PagerSlidingTabStrip_pstsTabPaddingLeftRight, this.tabPadding);
        this.tabBackgroundResId = a.getResourceId(R.styleable.PagerSlidingTabStrip_pstsTabBackground, this.tabBackgroundResId);
        this.shouldExpand = a.getBoolean(R.styleable.PagerSlidingTabStrip_pstsShouldExpand, this.shouldExpand);
        this.scrollOffset = a.getDimensionPixelSize(R.styleable.PagerSlidingTabStrip_pstsScrollOffset, this.scrollOffset);
        this.textAllCaps = a.getBoolean(R.styleable.PagerSlidingTabStrip_pstsTextAllCaps, this.textAllCaps);
        this.isPaddingMiddle = a.getBoolean(R.styleable.PagerSlidingTabStrip_pstsPaddingMiddle, this.isPaddingMiddle);
        this.tabTypefaceStyle = a.getInt(R.styleable.PagerSlidingTabStrip_pstsTextStyle, 1);
        this.tabTypefaceSelectedStyle = a.getInt(R.styleable.PagerSlidingTabStrip_pstsTextSelectedStyle, 1);
        this.tabTextColorSelected = a.getColorStateList(R.styleable.PagerSlidingTabStrip_pstsTextColorSelected);
        this.textAlpha = a.getInt(R.styleable.PagerSlidingTabStrip_pstsTextAlpha, this.textAlpha);
        a.recycle();
        this.tabTextColor = colorStateList == null ? this.getColorStateList(Color.argb((int)this.textAlpha, (int)Color.red((int)textPrimaryColor), (int)Color.green((int)textPrimaryColor), (int)Color.blue((int)textPrimaryColor))) : colorStateList;
        this.tabTextColorSelected = this.tabTextColorSelected == null ? this.getColorStateList(textPrimaryColor) : this.tabTextColorSelected;
        this.setMarginBottomTabContainer();
        this.rectPaint = new Paint();
        this.rectPaint.setAntiAlias(true);
        this.rectPaint.setStyle(Paint.Style.FILL);
        this.dividerPaint = new Paint();
        this.dividerPaint.setAntiAlias(true);
        this.dividerPaint.setStrokeWidth((float)this.dividerWidth);
        this.defaultTabLayoutParams = new LinearLayout.LayoutParams(-2, -1);
        this.expandedTabLayoutParams = new LinearLayout.LayoutParams(0, -1, 1.0f);
        if (this.locale == null) {
            this.locale = this.getResources().getConfiguration().locale;
        }
    }

    private void setMarginBottomTabContainer() {
        ViewGroup.MarginLayoutParams mlp = (ViewGroup.MarginLayoutParams)this.tabsContainer.getLayoutParams();
        int bottomMargin = this.indicatorHeight >= this.underlineHeight ? this.indicatorHeight : this.underlineHeight;
        mlp.setMargins(mlp.leftMargin, mlp.topMargin, mlp.rightMargin, bottomMargin);
        this.tabsContainer.setLayoutParams((ViewGroup.LayoutParams)mlp);
    }

    public void setViewPager(ViewPager pager) {
        this.pager = pager;
        if (pager.getAdapter() == null) {
            throw new IllegalStateException("ViewPager does not have adapter instance.");
        }
        pager.setOnPageChangeListener((ViewPager.OnPageChangeListener)this.pageListener);
        pager.getAdapter().registerDataSetObserver((DataSetObserver)this.adapterObserver);
        this.adapterObserver.setAttached(true);
        this.notifyDataSetChanged();
    }

    public void notifyDataSetChanged() {
        this.tabsContainer.removeAllViews();
        this.tabCount = this.pager.getAdapter().getCount();
        for (int i = 0; i < this.tabCount; ++i) {
            View tabView = this.pager.getAdapter() instanceof CustomTabProvider ? ((CustomTabProvider)this.pager.getAdapter()).getCustomTabView((ViewGroup)this, i) : LayoutInflater.from((Context)this.getContext()).inflate(R.layout.psts_tab, (ViewGroup)this, false);
            CharSequence title = this.pager.getAdapter().getPageTitle(i);
            this.addTab(i, title, tabView);
        }
        this.updateTabStyles();
        this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            @SuppressLint(value={"NewApi"})
            public void onGlobalLayout() {
                if (Build.VERSION.SDK_INT < 16) {
                    PagerSlidingTabStrip.this.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                } else {
                    PagerSlidingTabStrip.this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
            }
        });
    }

    private void addTab(final int position, CharSequence title, View tabView) {
        TextView textView = (TextView)tabView.findViewById(R.id.psts_tab_title);
        if (textView != null && title != null) {
            textView.setText(title);
        }
        tabView.setFocusable(true);
        tabView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (PagerSlidingTabStrip.this.pager.getCurrentItem() != position) {
                    View tab = PagerSlidingTabStrip.this.tabsContainer.getChildAt(PagerSlidingTabStrip.this.pager.getCurrentItem());
                    PagerSlidingTabStrip.this.notSelected(tab);
                    PagerSlidingTabStrip.this.pager.setCurrentItem(position);
                } else if (PagerSlidingTabStrip.this.tabReselectedListener != null) {
                    PagerSlidingTabStrip.this.tabReselectedListener.onTabReselected(position);
                }
            }
        });
        this.tabsContainer.addView(tabView, position, (ViewGroup.LayoutParams)(this.shouldExpand ? this.expandedTabLayoutParams : this.defaultTabLayoutParams));
    }

    private void updateTabStyles() {
        for (int i = 0; i < this.tabCount; ++i) {
            View v = this.tabsContainer.getChildAt(i);
            v.setBackgroundResource(this.tabBackgroundResId);
            v.setPadding(this.tabPadding, v.getPaddingTop(), this.tabPadding, v.getPaddingBottom());
            TextView tab_title = (TextView)v.findViewById(R.id.psts_tab_title);
            if (tab_title == null) continue;
            tab_title.setTextSize(0, (float)this.tabTextSize);
            if (!this.textAllCaps) continue;
            if (Build.VERSION.SDK_INT >= 14) {
                tab_title.setAllCaps(true);
                continue;
            }
            tab_title.setText((CharSequence)tab_title.getText().toString().toUpperCase(this.locale));
        }
    }

    private void scrollToChild(int position, int offset) {
        if (this.tabCount == 0) {
            return;
        }
        int newScrollX = this.tabsContainer.getChildAt(position).getLeft() + offset;
        if (position > 0 || offset > 0) {
            newScrollX -= this.scrollOffset;
            Pair<Float, Float> lines = this.getIndicatorCoordinates();
            newScrollX = (int)((float)newScrollX + (((Float)lines.second).floatValue() - ((Float)lines.first).floatValue()) / 2.0f);
        }
        if (newScrollX != this.lastScrollX) {
            this.lastScrollX = newScrollX;
            this.scrollTo(newScrollX, 0);
        }
    }

    private Pair<Float, Float> getIndicatorCoordinates() {
        View currentTab = this.tabsContainer.getChildAt(this.currentPosition);
        float lineLeft = currentTab.getLeft();
        float lineRight = currentTab.getRight();
        if (this.currentPositionOffset > 0.0f && this.currentPosition < this.tabCount - 1) {
            View nextTab = this.tabsContainer.getChildAt(this.currentPosition + 1);
            float nextTabLeft = nextTab.getLeft();
            float nextTabRight = nextTab.getRight();
            lineLeft = this.currentPositionOffset * nextTabLeft + (1.0f - this.currentPositionOffset) * lineLeft;
            lineRight = this.currentPositionOffset * nextTabRight + (1.0f - this.currentPositionOffset) * lineRight;
        }
        return new Pair((Object)Float.valueOf(lineLeft), (Object)Float.valueOf(lineRight));
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        if (this.isPaddingMiddle || this.paddingLeft > 0 || this.paddingRight > 0) {
            this.tabsContainer.setMinimumWidth(this.getWidth());
            this.setClipToPadding(false);
        }
        if (this.tabsContainer.getChildCount() > 0) {
            this.tabsContainer.getChildAt(0).getViewTreeObserver().addOnGlobalLayoutListener(this.firstTabGlobalLayoutListener);
        }
        super.onLayout(changed, l, t, r, b);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.isInEditMode() || this.tabCount == 0) {
            return;
        }
        int height = this.getHeight();
        this.rectPaint.setColor(this.indicatorColor);
        Pair<Float, Float> lines = this.getIndicatorCoordinates();
        canvas.drawRect(((Float)lines.first).floatValue() + (float)this.paddingLeft, (float)(height - this.indicatorHeight), ((Float)lines.second).floatValue() + (float)this.paddingLeft, (float)height, this.rectPaint);
        this.rectPaint.setColor(this.underlineColor);
        canvas.drawRect((float)this.paddingLeft, (float)(height - this.underlineHeight), (float)(this.tabsContainer.getWidth() + this.paddingRight), (float)height, this.rectPaint);
        if (this.dividerWidth != 0) {
            this.dividerPaint.setStrokeWidth((float)this.dividerWidth);
            this.dividerPaint.setColor(this.dividerColor);
            for (int i = 0; i < this.tabCount - 1; ++i) {
                View tab = this.tabsContainer.getChildAt(i);
                canvas.drawLine((float)tab.getRight(), (float)this.dividerPadding, (float)tab.getRight(), (float)(height - this.dividerPadding), this.dividerPaint);
            }
        }
    }

    public void setOnTabReselectedListener(OnTabReselectedListener tabReselectedListener) {
        this.tabReselectedListener = tabReselectedListener;
    }

    public void setOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        this.delegatePageListener = listener;
    }

    private void updateSelection(int position) {
        for (int i = 0; i < this.tabCount; ++i) {
            View tv = this.tabsContainer.getChildAt(i);
            boolean selected = i == position;
            tv.setSelected(selected);
            if (selected) {
                this.selected(tv);
                continue;
            }
            this.notSelected(tv);
        }
    }

    private void notSelected(View tab) {
        TextView title;
        if (tab != null && (title = (TextView)tab.findViewById(R.id.psts_tab_title)) != null) {
            title.setTypeface(this.tabTypeface, this.tabTypefaceStyle);
            title.setTextColor(this.tabTextColor);
        }
    }

    private void selected(View tab) {
        TextView title;
        if (tab != null && (title = (TextView)tab.findViewById(R.id.psts_tab_title)) != null) {
            title.setTypeface(this.tabTypeface, this.tabTypefaceSelectedStyle);
            title.setTextColor(this.tabTextColorSelected);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.pager != null && !this.adapterObserver.isAttached()) {
            this.pager.getAdapter().registerDataSetObserver((DataSetObserver)this.adapterObserver);
            this.adapterObserver.setAttached(true);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.pager != null && this.adapterObserver.isAttached()) {
            this.pager.getAdapter().unregisterDataSetObserver((DataSetObserver)this.adapterObserver);
            this.adapterObserver.setAttached(false);
        }
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.currentPosition = savedState.currentPosition;
        if (this.currentPosition != 0 && this.tabsContainer.getChildCount() > 0) {
            this.notSelected(this.tabsContainer.getChildAt(0));
            this.selected(this.tabsContainer.getChildAt(this.currentPosition));
        }
        this.requestLayout();
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState savedState = new SavedState(superState);
        savedState.currentPosition = this.currentPosition;
        return savedState;
    }

    public int getIndicatorColor() {
        return this.indicatorColor;
    }

    public int getIndicatorHeight() {
        return this.indicatorHeight;
    }

    public int getUnderlineColor() {
        return this.underlineColor;
    }

    public int getDividerColor() {
        return this.dividerColor;
    }

    public int getDividerWidth() {
        return this.dividerWidth;
    }

    public int getUnderlineHeight() {
        return this.underlineHeight;
    }

    public int getDividerPadding() {
        return this.dividerPadding;
    }

    public int getScrollOffset() {
        return this.scrollOffset;
    }

    public boolean getShouldExpand() {
        return this.shouldExpand;
    }

    public int getTextSize() {
        return this.tabTextSize;
    }

    public boolean isTextAllCaps() {
        return this.textAllCaps;
    }

    public ColorStateList getTextColor() {
        return this.tabTextColor;
    }

    public int getTabBackground() {
        return this.tabBackgroundResId;
    }

    public int getTabPaddingLeftRight() {
        return this.tabPadding;
    }

    public void setIndicatorColor(int indicatorColor) {
        this.indicatorColor = indicatorColor;
        this.invalidate();
    }

    public void setIndicatorColorResource(int resId) {
        this.indicatorColor = this.getResources().getColor(resId);
        this.invalidate();
    }

    public void setIndicatorHeight(int indicatorLineHeightPx) {
        this.indicatorHeight = indicatorLineHeightPx;
        this.invalidate();
    }

    public void setUnderlineColor(int underlineColor) {
        this.underlineColor = underlineColor;
        this.invalidate();
    }

    public void setUnderlineColorResource(int resId) {
        this.underlineColor = this.getResources().getColor(resId);
        this.invalidate();
    }

    public void setDividerColor(int dividerColor) {
        this.dividerColor = dividerColor;
        this.invalidate();
    }

    public void setDividerColorResource(int resId) {
        this.dividerColor = this.getResources().getColor(resId);
        this.invalidate();
    }

    public void setDividerWidth(int dividerWidthPx) {
        this.dividerWidth = dividerWidthPx;
        this.invalidate();
    }

    public void setUnderlineHeight(int underlineHeightPx) {
        this.underlineHeight = underlineHeightPx;
        this.invalidate();
    }

    public void setDividerPadding(int dividerPaddingPx) {
        this.dividerPadding = dividerPaddingPx;
        this.invalidate();
    }

    public void setScrollOffset(int scrollOffsetPx) {
        this.scrollOffset = scrollOffsetPx;
        this.invalidate();
    }

    public void setShouldExpand(boolean shouldExpand) {
        this.shouldExpand = shouldExpand;
        if (this.pager != null) {
            this.requestLayout();
        }
    }

    public void setAllCaps(boolean textAllCaps) {
        this.textAllCaps = textAllCaps;
    }

    public void setTextSize(int textSizePx) {
        this.tabTextSize = textSizePx;
        this.updateTabStyles();
    }

    public void setTextColor(int textColor) {
        this.setTextColor(this.getColorStateList(textColor));
    }

    private ColorStateList getColorStateList(int textColor) {
        return new ColorStateList((int[][])new int[][]{new int[0]}, new int[]{textColor});
    }

    public void setTextColor(ColorStateList colorStateList) {
        this.tabTextColor = colorStateList;
        this.updateTabStyles();
    }

    public void setTextColorResource(int resId) {
        this.setTextColor(this.getResources().getColor(resId));
    }

    public void setTextColorStateListResource(int resId) {
        this.setTextColor(this.getResources().getColorStateList(resId));
    }

    public void setTypeface(Typeface typeface, int style) {
        this.tabTypeface = typeface;
        this.tabTypefaceSelectedStyle = style;
        this.updateTabStyles();
    }

    public void setTabBackground(int resId) {
        this.tabBackgroundResId = resId;
    }

    public void setTabPaddingLeftRight(int paddingPx) {
        this.tabPadding = paddingPx;
        this.updateTabStyles();
    }

    static class SavedState
    extends View.BaseSavedState {
        int currentPosition;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.currentPosition = in.readInt();
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.currentPosition);
        }
    }

    private class PagerAdapterObserver
    extends DataSetObserver {
        private boolean attached = false;

        private PagerAdapterObserver() {
        }

        public void onChanged() {
            PagerSlidingTabStrip.this.notifyDataSetChanged();
        }

        public void setAttached(boolean attached) {
            this.attached = attached;
        }

        public boolean isAttached() {
            return this.attached;
        }
    }

    private class PageListener
    implements ViewPager.OnPageChangeListener {
        private PageListener() {
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            PagerSlidingTabStrip.this.currentPosition = position;
            PagerSlidingTabStrip.this.currentPositionOffset = positionOffset;
            int offset = PagerSlidingTabStrip.this.tabCount > 0 ? (int)(positionOffset * (float)PagerSlidingTabStrip.this.tabsContainer.getChildAt(position).getWidth()) : 0;
            PagerSlidingTabStrip.this.scrollToChild(position, offset);
            PagerSlidingTabStrip.this.invalidate();
            if (PagerSlidingTabStrip.this.delegatePageListener != null) {
                PagerSlidingTabStrip.this.delegatePageListener.onPageScrolled(position, positionOffset, positionOffsetPixels);
            }
        }

        public void onPageScrollStateChanged(int state) {
            if (state == 0) {
                PagerSlidingTabStrip.this.scrollToChild(PagerSlidingTabStrip.this.pager.getCurrentItem(), 0);
            }
            View currentTab = PagerSlidingTabStrip.this.tabsContainer.getChildAt(PagerSlidingTabStrip.this.pager.getCurrentItem());
            PagerSlidingTabStrip.this.selected(currentTab);
            if (PagerSlidingTabStrip.this.pager.getCurrentItem() - 1 >= 0) {
                View prevTab = PagerSlidingTabStrip.this.tabsContainer.getChildAt(PagerSlidingTabStrip.this.pager.getCurrentItem() - 1);
                PagerSlidingTabStrip.this.notSelected(prevTab);
            }
            if (PagerSlidingTabStrip.this.pager.getCurrentItem() + 1 <= PagerSlidingTabStrip.this.pager.getAdapter().getCount() - 1) {
                View nextTab = PagerSlidingTabStrip.this.tabsContainer.getChildAt(PagerSlidingTabStrip.this.pager.getCurrentItem() + 1);
                PagerSlidingTabStrip.this.notSelected(nextTab);
            }
            if (PagerSlidingTabStrip.this.delegatePageListener != null) {
                PagerSlidingTabStrip.this.delegatePageListener.onPageScrollStateChanged(state);
            }
        }

        public void onPageSelected(int position) {
            PagerSlidingTabStrip.this.updateSelection(position);
            if (PagerSlidingTabStrip.this.delegatePageListener != null) {
                PagerSlidingTabStrip.this.delegatePageListener.onPageSelected(position);
            }
        }
    }

    public static interface OnTabReselectedListener {
        public void onTabReselected(int var1);
    }

    public static interface CustomTabProvider {
        public View getCustomTabView(ViewGroup var1, int var2);
    }
}

