/*
 * Decompiled with CFR 0.152.
 */
package com.astuetz;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.util.Pair;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.HorizontalScrollView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.astuetz.pagerslidingtabstrip.R;

public class PagerSlidingTabStrip
extends HorizontalScrollView {
    public static final int DEF_VALUE_TAB_TEXT_ALPHA = 150;
    private static final int[] ANDROID_ATTRS = new int[]{16842806, 16842965, 16842966, 16842968};
    private static final int TEXT_COLOR_PRIMARY = 0;
    private static final int PADDING_INDEX = 1;
    private static final int PADDING_LEFT_INDEX = 2;
    private static final int PADDING_RIGHT_INDEX = 3;
    private LinearLayout mTabsContainer;
    private LinearLayout.LayoutParams mTabLayoutParams;
    private final PagerAdapterObserver mAdapterObserver = new PagerAdapterObserver();
    private final PageListener mPageListener = new PageListener();
    private OnTabReselectedListener mTabReselectedListener = null;
    public ViewPager.OnPageChangeListener mDelegatePageListener;
    private ViewPager mPager;
    private int mTabCount;
    private int mCurrentPosition = 0;
    private float mCurrentPositionOffset = 0.0f;
    private Paint mRectPaint;
    private Paint mDividerPaint;
    private int mIndicatorColor;
    private int mIndicatorHeight = 2;
    private int mUnderlineHeight = 0;
    private int mUnderlineColor;
    private int mDividerWidth = 0;
    private int mDividerPadding = 0;
    private int mDividerColor;
    private int mTabPadding = 12;
    private int mTabTextSize = 14;
    private ColorStateList mTabTextColor = null;
    private int mPaddingLeft = 0;
    private int mPaddingRight = 0;
    private boolean isExpandTabs = false;
    private boolean isCustomTabs;
    private boolean isPaddingMiddle = false;
    private boolean isTabTextAllCaps = true;
    private Typeface mTabTextTypeface = null;
    private int mTabTextTypefaceStyle = 1;
    private int mScrollOffset;
    private int mLastScrollX = 0;
    private int mTabBackgroundResId = R.drawable.psts_background_tab;
    private ViewTreeObserver.OnGlobalLayoutListener firstTabGlobalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

        public void onGlobalLayout() {
            View view = PagerSlidingTabStrip.this.mTabsContainer.getChildAt(0);
            if (Build.VERSION.SDK_INT < 16) {
                this.removeGlobalLayoutListenerPreJB();
            } else {
                this.removeGlobalLayoutListenerJB();
            }
            if (PagerSlidingTabStrip.this.isPaddingMiddle) {
                int mHalfWidthFirstTab = view.getWidth() / 2;
                PagerSlidingTabStrip.this.mPaddingLeft = (PagerSlidingTabStrip.this.mPaddingRight = PagerSlidingTabStrip.this.getWidth() / 2 - mHalfWidthFirstTab);
            }
            PagerSlidingTabStrip.this.setPadding(PagerSlidingTabStrip.this.mPaddingLeft, PagerSlidingTabStrip.this.getPaddingTop(), PagerSlidingTabStrip.this.mPaddingRight, PagerSlidingTabStrip.this.getPaddingBottom());
            if (PagerSlidingTabStrip.this.mScrollOffset == 0) {
                PagerSlidingTabStrip.this.mScrollOffset = PagerSlidingTabStrip.this.getWidth() / 2 - PagerSlidingTabStrip.this.mPaddingLeft;
            }
            PagerSlidingTabStrip.this.mCurrentPosition = PagerSlidingTabStrip.this.mPager.getCurrentItem();
            PagerSlidingTabStrip.this.mCurrentPositionOffset = 0.0f;
            PagerSlidingTabStrip.this.scrollToChild(PagerSlidingTabStrip.this.mCurrentPosition, 0);
            PagerSlidingTabStrip.this.updateSelection(PagerSlidingTabStrip.this.mCurrentPosition);
        }

        private void removeGlobalLayoutListenerPreJB() {
            PagerSlidingTabStrip.this.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }

        @TargetApi(value=16)
        private void removeGlobalLayoutListenerJB() {
            PagerSlidingTabStrip.this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
    };

    public PagerSlidingTabStrip(Context context) {
        this(context, null);
    }

    public PagerSlidingTabStrip(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PagerSlidingTabStrip(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        int textPrimaryColor;
        this.setFillViewport(true);
        this.setWillNotDraw(false);
        this.mTabsContainer = new LinearLayout(context);
        this.mTabsContainer.setOrientation(0);
        this.addView((View)this.mTabsContainer);
        this.mRectPaint = new Paint();
        this.mRectPaint.setAntiAlias(true);
        this.mRectPaint.setStyle(Paint.Style.FILL);
        DisplayMetrics dm = this.getResources().getDisplayMetrics();
        this.mScrollOffset = (int)TypedValue.applyDimension((int)1, (float)this.mScrollOffset, (DisplayMetrics)dm);
        this.mIndicatorHeight = (int)TypedValue.applyDimension((int)1, (float)this.mIndicatorHeight, (DisplayMetrics)dm);
        this.mUnderlineHeight = (int)TypedValue.applyDimension((int)1, (float)this.mUnderlineHeight, (DisplayMetrics)dm);
        this.mDividerPadding = (int)TypedValue.applyDimension((int)1, (float)this.mDividerPadding, (DisplayMetrics)dm);
        this.mTabPadding = (int)TypedValue.applyDimension((int)1, (float)this.mTabPadding, (DisplayMetrics)dm);
        this.mDividerWidth = (int)TypedValue.applyDimension((int)1, (float)this.mDividerWidth, (DisplayMetrics)dm);
        this.mTabTextSize = (int)TypedValue.applyDimension((int)2, (float)this.mTabTextSize, (DisplayMetrics)dm);
        this.mDividerPaint = new Paint();
        this.mDividerPaint.setAntiAlias(true);
        this.mDividerPaint.setStrokeWidth((float)this.mDividerWidth);
        TypedArray a = context.obtainStyledAttributes(attrs, ANDROID_ATTRS);
        this.mUnderlineColor = textPrimaryColor = a.getColor(0, this.getResources().getColor(17170444));
        this.mDividerColor = textPrimaryColor;
        this.mIndicatorColor = textPrimaryColor;
        int padding = a.getDimensionPixelSize(1, 0);
        this.mPaddingLeft = padding > 0 ? padding : a.getDimensionPixelSize(2, 0);
        this.mPaddingRight = padding > 0 ? padding : a.getDimensionPixelSize(3, 0);
        a.recycle();
        String tabTextTypefaceName = "sans-serif";
        if (Build.VERSION.SDK_INT >= 21) {
            tabTextTypefaceName = "sans-serif-medium";
            this.mTabTextTypefaceStyle = 0;
        }
        a = context.obtainStyledAttributes(attrs, R.styleable.PagerSlidingTabStrip);
        this.mIndicatorColor = a.getColor(R.styleable.PagerSlidingTabStrip_pstsIndicatorColor, this.mIndicatorColor);
        this.mIndicatorHeight = a.getDimensionPixelSize(R.styleable.PagerSlidingTabStrip_pstsIndicatorHeight, this.mIndicatorHeight);
        this.mUnderlineColor = a.getColor(R.styleable.PagerSlidingTabStrip_pstsUnderlineColor, this.mUnderlineColor);
        this.mUnderlineHeight = a.getDimensionPixelSize(R.styleable.PagerSlidingTabStrip_pstsUnderlineHeight, this.mUnderlineHeight);
        this.mDividerColor = a.getColor(R.styleable.PagerSlidingTabStrip_pstsDividerColor, this.mDividerColor);
        this.mDividerWidth = a.getDimensionPixelSize(R.styleable.PagerSlidingTabStrip_pstsDividerWidth, this.mDividerWidth);
        this.mDividerPadding = a.getDimensionPixelSize(R.styleable.PagerSlidingTabStrip_pstsDividerPadding, this.mDividerPadding);
        this.isExpandTabs = a.getBoolean(R.styleable.PagerSlidingTabStrip_pstsShouldExpand, this.isExpandTabs);
        this.mScrollOffset = a.getDimensionPixelSize(R.styleable.PagerSlidingTabStrip_pstsScrollOffset, this.mScrollOffset);
        this.isPaddingMiddle = a.getBoolean(R.styleable.PagerSlidingTabStrip_pstsPaddingMiddle, this.isPaddingMiddle);
        this.mTabPadding = a.getDimensionPixelSize(R.styleable.PagerSlidingTabStrip_pstsTabPaddingLeftRight, this.mTabPadding);
        this.mTabBackgroundResId = a.getResourceId(R.styleable.PagerSlidingTabStrip_pstsTabBackground, this.mTabBackgroundResId);
        this.mTabTextSize = a.getDimensionPixelSize(R.styleable.PagerSlidingTabStrip_pstsTabTextSize, this.mTabTextSize);
        this.mTabTextColor = a.hasValue(R.styleable.PagerSlidingTabStrip_pstsTabTextColor) ? a.getColorStateList(R.styleable.PagerSlidingTabStrip_pstsTabTextColor) : null;
        this.mTabTextTypefaceStyle = a.getInt(R.styleable.PagerSlidingTabStrip_pstsTabTextStyle, this.mTabTextTypefaceStyle);
        this.isTabTextAllCaps = a.getBoolean(R.styleable.PagerSlidingTabStrip_pstsTabTextAllCaps, this.isTabTextAllCaps);
        int tabTextAlpha = a.getInt(R.styleable.PagerSlidingTabStrip_pstsTabTextAlpha, 150);
        String fontFamily = a.getString(R.styleable.PagerSlidingTabStrip_pstsTabTextFontFamily);
        a.recycle();
        if (this.mTabTextColor == null) {
            this.mTabTextColor = this.createColorStateList(textPrimaryColor, textPrimaryColor, Color.argb((int)tabTextAlpha, (int)Color.red((int)textPrimaryColor), (int)Color.green((int)textPrimaryColor), (int)Color.blue((int)textPrimaryColor)));
        }
        if (fontFamily != null) {
            tabTextTypefaceName = fontFamily;
        }
        this.mTabTextTypeface = Typeface.create((String)tabTextTypefaceName, (int)this.mTabTextTypefaceStyle);
        this.setTabsContainerParentViewPaddings();
        this.mTabLayoutParams = this.isExpandTabs ? new LinearLayout.LayoutParams(0, -1, 1.0f) : new LinearLayout.LayoutParams(-2, -1);
    }

    private void setTabsContainerParentViewPaddings() {
        int bottomMargin = this.mIndicatorHeight >= this.mUnderlineHeight ? this.mIndicatorHeight : this.mUnderlineHeight;
        this.setPadding(this.getPaddingLeft(), this.getPaddingTop(), this.getPaddingRight(), bottomMargin);
    }

    public void setViewPager(ViewPager pager) {
        this.mPager = pager;
        if (pager.getAdapter() == null) {
            throw new IllegalStateException("ViewPager does not have adapter instance.");
        }
        this.isCustomTabs = pager.getAdapter() instanceof CustomTabProvider;
        pager.setOnPageChangeListener((ViewPager.OnPageChangeListener)this.mPageListener);
        pager.getAdapter().registerDataSetObserver((DataSetObserver)this.mAdapterObserver);
        this.mAdapterObserver.setAttached(true);
        this.notifyDataSetChanged();
    }

    public void notifyDataSetChanged() {
        this.mTabsContainer.removeAllViews();
        this.mTabCount = this.mPager.getAdapter().getCount();
        for (int i = 0; i < this.mTabCount; ++i) {
            View tabView = this.isCustomTabs ? ((CustomTabProvider)this.mPager.getAdapter()).getCustomTabView((ViewGroup)this, i) : LayoutInflater.from((Context)this.getContext()).inflate(R.layout.psts_tab, (ViewGroup)this, false);
            CharSequence title = this.mPager.getAdapter().getPageTitle(i);
            this.addTab(i, title, tabView);
        }
        this.updateTabStyles();
    }

    private void addTab(final int position, CharSequence title, View tabView) {
        TextView textView = (TextView)tabView.findViewById(R.id.psts_tab_title);
        if (textView != null && title != null) {
            textView.setText(title);
        }
        tabView.setFocusable(true);
        tabView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (PagerSlidingTabStrip.this.mPager.getCurrentItem() != position) {
                    View tab = PagerSlidingTabStrip.this.mTabsContainer.getChildAt(PagerSlidingTabStrip.this.mPager.getCurrentItem());
                    PagerSlidingTabStrip.this.unSelect(tab);
                    PagerSlidingTabStrip.this.mPager.setCurrentItem(position);
                } else if (PagerSlidingTabStrip.this.mTabReselectedListener != null) {
                    PagerSlidingTabStrip.this.mTabReselectedListener.onTabReselected(position);
                }
            }
        });
        this.mTabsContainer.addView(tabView, position, (ViewGroup.LayoutParams)this.mTabLayoutParams);
    }

    private void updateTabStyles() {
        for (int i = 0; i < this.mTabCount; ++i) {
            View v = this.mTabsContainer.getChildAt(i);
            v.setBackgroundResource(this.mTabBackgroundResId);
            v.setPadding(this.mTabPadding, v.getPaddingTop(), this.mTabPadding, v.getPaddingBottom());
            TextView tab_title = (TextView)v.findViewById(R.id.psts_tab_title);
            if (tab_title == null) continue;
            tab_title.setTextColor(this.mTabTextColor);
            tab_title.setTypeface(this.mTabTextTypeface, this.mTabTextTypefaceStyle);
            tab_title.setTextSize(0, (float)this.mTabTextSize);
            if (!this.isTabTextAllCaps) continue;
            if (Build.VERSION.SDK_INT >= 14) {
                tab_title.setAllCaps(true);
                continue;
            }
            tab_title.setText((CharSequence)tab_title.getText().toString().toUpperCase(this.getResources().getConfiguration().locale));
        }
    }

    private void scrollToChild(int position, int offset) {
        if (this.mTabCount == 0) {
            return;
        }
        int newScrollX = this.mTabsContainer.getChildAt(position).getLeft() + offset;
        if (position > 0 || offset > 0) {
            newScrollX -= this.mScrollOffset;
            Pair<Float, Float> lines = this.getIndicatorCoordinates();
            newScrollX = (int)((float)newScrollX + (((Float)lines.second).floatValue() - ((Float)lines.first).floatValue()) / 2.0f);
        }
        if (newScrollX != this.mLastScrollX) {
            this.mLastScrollX = newScrollX;
            this.scrollTo(newScrollX, 0);
        }
    }

    private Pair<Float, Float> getIndicatorCoordinates() {
        View currentTab = this.mTabsContainer.getChildAt(this.mCurrentPosition);
        float lineLeft = currentTab.getLeft();
        float lineRight = currentTab.getRight();
        if (this.mCurrentPositionOffset > 0.0f && this.mCurrentPosition < this.mTabCount - 1) {
            View nextTab = this.mTabsContainer.getChildAt(this.mCurrentPosition + 1);
            float nextTabLeft = nextTab.getLeft();
            float nextTabRight = nextTab.getRight();
            lineLeft = this.mCurrentPositionOffset * nextTabLeft + (1.0f - this.mCurrentPositionOffset) * lineLeft;
            lineRight = this.mCurrentPositionOffset * nextTabRight + (1.0f - this.mCurrentPositionOffset) * lineRight;
        }
        return new Pair((Object)Float.valueOf(lineLeft), (Object)Float.valueOf(lineRight));
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        if (this.isPaddingMiddle || this.mPaddingLeft > 0 || this.mPaddingRight > 0) {
            int width = this.isPaddingMiddle ? this.getWidth() : this.getWidth() - this.mPaddingLeft - this.mPaddingRight;
            this.mTabsContainer.setMinimumWidth(width);
            this.setClipToPadding(false);
        }
        if (this.mTabsContainer.getChildCount() > 0) {
            this.mTabsContainer.getChildAt(0).getViewTreeObserver().addOnGlobalLayoutListener(this.firstTabGlobalLayoutListener);
        }
        super.onLayout(changed, l, t, r, b);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.isInEditMode() || this.mTabCount == 0) {
            return;
        }
        int height = this.getHeight();
        if (this.mDividerWidth > 0) {
            this.mDividerPaint.setStrokeWidth((float)this.mDividerWidth);
            this.mDividerPaint.setColor(this.mDividerColor);
            for (int i = 0; i < this.mTabCount - 1; ++i) {
                View tab = this.mTabsContainer.getChildAt(i);
                canvas.drawLine((float)tab.getRight(), (float)this.mDividerPadding, (float)tab.getRight(), (float)(height - this.mDividerPadding), this.mDividerPaint);
            }
        }
        if (this.mUnderlineHeight > 0) {
            this.mRectPaint.setColor(this.mUnderlineColor);
            canvas.drawRect((float)this.mPaddingLeft, (float)(height - this.mUnderlineHeight), (float)(this.mTabsContainer.getWidth() + this.mPaddingRight), (float)height, this.mRectPaint);
        }
        if (this.mIndicatorHeight > 0) {
            this.mRectPaint.setColor(this.mIndicatorColor);
            Pair<Float, Float> lines = this.getIndicatorCoordinates();
            canvas.drawRect(((Float)lines.first).floatValue() + (float)this.mPaddingLeft, (float)(height - this.mIndicatorHeight), ((Float)lines.second).floatValue() + (float)this.mPaddingLeft, (float)height, this.mRectPaint);
        }
    }

    public void setOnTabReselectedListener(OnTabReselectedListener tabReselectedListener) {
        this.mTabReselectedListener = tabReselectedListener;
    }

    public void setOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        this.mDelegatePageListener = listener;
    }

    private void updateSelection(int position) {
        for (int i = 0; i < this.mTabCount; ++i) {
            boolean selected;
            View tv = this.mTabsContainer.getChildAt(i);
            boolean bl = selected = i == position;
            if (selected) {
                this.select(tv);
                continue;
            }
            this.unSelect(tv);
        }
    }

    private void unSelect(View tab) {
        if (tab != null) {
            TextView tab_title = (TextView)tab.findViewById(R.id.psts_tab_title);
            if (tab_title != null) {
                tab_title.setSelected(false);
            }
            if (this.isCustomTabs) {
                ((CustomTabProvider)this.mPager.getAdapter()).tabUnselected(tab);
            }
        }
    }

    private void select(View tab) {
        if (tab != null) {
            TextView tab_title = (TextView)tab.findViewById(R.id.psts_tab_title);
            if (tab_title != null) {
                tab_title.setSelected(true);
            }
            if (this.isCustomTabs) {
                ((CustomTabProvider)this.mPager.getAdapter()).tabSelected(tab);
            }
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mPager != null && !this.mAdapterObserver.isAttached()) {
            this.mPager.getAdapter().registerDataSetObserver((DataSetObserver)this.mAdapterObserver);
            this.mAdapterObserver.setAttached(true);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mPager != null && this.mAdapterObserver.isAttached()) {
            this.mPager.getAdapter().unregisterDataSetObserver((DataSetObserver)this.mAdapterObserver);
            this.mAdapterObserver.setAttached(false);
        }
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.mCurrentPosition = savedState.currentPosition;
        if (this.mCurrentPosition != 0 && this.mTabsContainer.getChildCount() > 0) {
            this.unSelect(this.mTabsContainer.getChildAt(0));
            this.select(this.mTabsContainer.getChildAt(this.mCurrentPosition));
        }
        this.requestLayout();
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState savedState = new SavedState(superState);
        savedState.currentPosition = this.mCurrentPosition;
        return savedState;
    }

    public int getIndicatorColor() {
        return this.mIndicatorColor;
    }

    public int getIndicatorHeight() {
        return this.mIndicatorHeight;
    }

    public int getUnderlineColor() {
        return this.mUnderlineColor;
    }

    public int getDividerColor() {
        return this.mDividerColor;
    }

    public int getDividerWidth() {
        return this.mDividerWidth;
    }

    public int getUnderlineHeight() {
        return this.mUnderlineHeight;
    }

    public int getDividerPadding() {
        return this.mDividerPadding;
    }

    public int getScrollOffset() {
        return this.mScrollOffset;
    }

    public boolean getShouldExpand() {
        return this.isExpandTabs;
    }

    public int getTextSize() {
        return this.mTabTextSize;
    }

    public boolean isTextAllCaps() {
        return this.isTabTextAllCaps;
    }

    public ColorStateList getTextColor() {
        return this.mTabTextColor;
    }

    public int getTabBackground() {
        return this.mTabBackgroundResId;
    }

    public int getTabPaddingLeftRight() {
        return this.mTabPadding;
    }

    public void setIndicatorColor(int indicatorColor) {
        this.mIndicatorColor = indicatorColor;
        this.invalidate();
    }

    public void setIndicatorColorResource(int resId) {
        this.mIndicatorColor = this.getResources().getColor(resId);
        this.invalidate();
    }

    public void setIndicatorHeight(int indicatorLineHeightPx) {
        this.mIndicatorHeight = indicatorLineHeightPx;
        this.invalidate();
    }

    public void setUnderlineColor(int underlineColor) {
        this.mUnderlineColor = underlineColor;
        this.invalidate();
    }

    public void setUnderlineColorResource(int resId) {
        this.mUnderlineColor = this.getResources().getColor(resId);
        this.invalidate();
    }

    public void setDividerColor(int dividerColor) {
        this.mDividerColor = dividerColor;
        this.invalidate();
    }

    public void setDividerColorResource(int resId) {
        this.mDividerColor = this.getResources().getColor(resId);
        this.invalidate();
    }

    public void setDividerWidth(int dividerWidthPx) {
        this.mDividerWidth = dividerWidthPx;
        this.invalidate();
    }

    public void setUnderlineHeight(int underlineHeightPx) {
        this.mUnderlineHeight = underlineHeightPx;
        this.invalidate();
    }

    public void setDividerPadding(int dividerPaddingPx) {
        this.mDividerPadding = dividerPaddingPx;
        this.invalidate();
    }

    public void setScrollOffset(int scrollOffsetPx) {
        this.mScrollOffset = scrollOffsetPx;
        this.invalidate();
    }

    public void setShouldExpand(boolean shouldExpand) {
        this.isExpandTabs = shouldExpand;
        if (this.mPager != null) {
            this.requestLayout();
        }
    }

    public void setAllCaps(boolean textAllCaps) {
        this.isTabTextAllCaps = textAllCaps;
    }

    public void setTextSize(int textSizePx) {
        this.mTabTextSize = textSizePx;
        this.updateTabStyles();
    }

    public void setTextColorResource(int resId) {
        this.setTextColor(this.getResources().getColor(resId));
    }

    public void setTextColor(int textColor) {
        this.setTextColor(this.createColorStateList(textColor));
    }

    public void setTextColorStateListResource(int resId) {
        this.setTextColor(this.getResources().getColorStateList(resId));
    }

    public void setTextColor(ColorStateList colorStateList) {
        this.mTabTextColor = colorStateList;
        this.updateTabStyles();
    }

    private ColorStateList createColorStateList(int color_state_default) {
        return new ColorStateList((int[][])new int[][]{new int[0]}, new int[]{color_state_default});
    }

    private ColorStateList createColorStateList(int color_state_pressed, int color_state_selected, int color_state_default) {
        return new ColorStateList((int[][])new int[][]{{16842919}, {0x10100A1}, new int[0]}, new int[]{color_state_pressed, color_state_selected, color_state_default});
    }

    public void setTypeface(Typeface typeface, int style) {
        this.mTabTextTypeface = typeface;
        this.mTabTextTypefaceStyle = style;
        this.updateTabStyles();
    }

    public void setTabBackground(int resId) {
        this.mTabBackgroundResId = resId;
    }

    public void setTabPaddingLeftRight(int paddingPx) {
        this.mTabPadding = paddingPx;
        this.updateTabStyles();
    }

    public static interface OnTabReselectedListener {
        public void onTabReselected(int var1);
    }

    public static interface CustomTabProvider {
        public View getCustomTabView(ViewGroup var1, int var2);

        public void tabSelected(View var1);

        public void tabUnselected(View var1);
    }

    static class SavedState
    extends View.BaseSavedState {
        int currentPosition;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.currentPosition = in.readInt();
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.currentPosition);
        }
    }

    private class PagerAdapterObserver
    extends DataSetObserver {
        private boolean attached = false;

        private PagerAdapterObserver() {
        }

        public void onChanged() {
            PagerSlidingTabStrip.this.notifyDataSetChanged();
        }

        public void setAttached(boolean attached) {
            this.attached = attached;
        }

        public boolean isAttached() {
            return this.attached;
        }
    }

    private class PageListener
    implements ViewPager.OnPageChangeListener {
        private PageListener() {
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            PagerSlidingTabStrip.this.mCurrentPosition = position;
            PagerSlidingTabStrip.this.mCurrentPositionOffset = positionOffset;
            int offset = PagerSlidingTabStrip.this.mTabCount > 0 ? (int)(positionOffset * (float)PagerSlidingTabStrip.this.mTabsContainer.getChildAt(position).getWidth()) : 0;
            PagerSlidingTabStrip.this.scrollToChild(position, offset);
            PagerSlidingTabStrip.this.invalidate();
            if (PagerSlidingTabStrip.this.mDelegatePageListener != null) {
                PagerSlidingTabStrip.this.mDelegatePageListener.onPageScrolled(position, positionOffset, positionOffsetPixels);
            }
        }

        public void onPageScrollStateChanged(int state) {
            if (state == 0) {
                PagerSlidingTabStrip.this.scrollToChild(PagerSlidingTabStrip.this.mPager.getCurrentItem(), 0);
            }
            View currentTab = PagerSlidingTabStrip.this.mTabsContainer.getChildAt(PagerSlidingTabStrip.this.mPager.getCurrentItem());
            PagerSlidingTabStrip.this.select(currentTab);
            if (PagerSlidingTabStrip.this.mPager.getCurrentItem() - 1 >= 0) {
                View prevTab = PagerSlidingTabStrip.this.mTabsContainer.getChildAt(PagerSlidingTabStrip.this.mPager.getCurrentItem() - 1);
                PagerSlidingTabStrip.this.unSelect(prevTab);
            }
            if (PagerSlidingTabStrip.this.mPager.getCurrentItem() + 1 <= PagerSlidingTabStrip.this.mPager.getAdapter().getCount() - 1) {
                View nextTab = PagerSlidingTabStrip.this.mTabsContainer.getChildAt(PagerSlidingTabStrip.this.mPager.getCurrentItem() + 1);
                PagerSlidingTabStrip.this.unSelect(nextTab);
            }
            if (PagerSlidingTabStrip.this.mDelegatePageListener != null) {
                PagerSlidingTabStrip.this.mDelegatePageListener.onPageScrollStateChanged(state);
            }
        }

        public void onPageSelected(int position) {
            PagerSlidingTabStrip.this.updateSelection(position);
            if (PagerSlidingTabStrip.this.mDelegatePageListener != null) {
                PagerSlidingTabStrip.this.mDelegatePageListener.onPageSelected(position);
            }
        }
    }
}

