/*
 * Decompiled with CFR 0.152.
 */
package com.jpardus.spider.ifacade;

import com.jpardus.spider.facade.FacadeServer;
import com.jpardus.spider.facade.IFacade;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

class ApplicationContext {
    private static final Logger LOG = LogManager.getLogger(ApplicationContext.class);
    private AbstractApplicationContext context;

    ApplicationContext() {
    }

    public AbstractApplicationContext getContext() {
        return this.context;
    }

    public boolean loadContext(int port) {
        boolean isActive = false;
        this.context = new FileSystemXmlApplicationContext("classpath*:spring/*.xml");
        isActive = this.context.isActive();
        if (isActive) {
            this.context.registerShutdownHook();
            FacadeServer server = new FacadeServer(port);
            Map facades = this.context.getBeansOfType(IFacade.class);
            for (IFacade facade : facades.values()) {
                server.add(facade);
            }
            server.start();
        } else {
            LOG.info("loading spring error.");
        }
        return isActive;
    }
}

