/*
 * Decompiled with CFR 0.152.
 */
package com.jpardus.spider.ifacade;

import com.jpardus.spider.facade.FacadeClient;
import com.jpardus.spider.facade.IFacade;
import com.jpardus.spider.ifacade.AutoFacaded;
import java.lang.reflect.Field;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class FacadeBeanPostProcessor
implements BeanPostProcessor {
    private static final Logger LOG = LogManager.getLogger(FacadeBeanPostProcessor.class);

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        Field[] fields;
        Class<?> clazz = bean.getClass();
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(AutoFacaded.class)) continue;
            field.setAccessible(true);
            try {
                field.set(bean, FacadeClient.getRemoteObject(field.getType().asSubclass(IFacade.class)));
            }
            catch (IllegalArgumentException e) {
                LOG.error("autofacaded error on " + field.getType(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOG.error("autofacaded error on " + field.getType(), (Throwable)e);
            }
            catch (Exception e) {
                LOG.error("autofacaded error on " + field.getType(), (Throwable)e);
            }
            field.setAccessible(false);
        }
        return bean;
    }
}

