/*
 * Decompiled with CFR 0.152.
 */
package com.jrummyapps.android.shell;

import android.support.annotation.NonNull;
import com.jrummyapps.android.shell.ShellExitCode;
import java.util.List;

public class CommandResult
implements ShellExitCode {
    @NonNull
    public final List<String> stdout;
    @NonNull
    public final List<String> stderr;
    public final int exitCode;

    public CommandResult(@NonNull List<String> stdout, @NonNull List<String> stderr, int exitCode) {
        this.stdout = stdout;
        this.stderr = stderr;
        this.exitCode = exitCode;
    }

    public boolean isSuccessful() {
        return this.exitCode == 0;
    }

    public String getStdout() {
        return this.linesToString(this.stdout);
    }

    public String getStderr() {
        return this.linesToString(this.stderr);
    }

    private String linesToString(List<String> lines) {
        StringBuilder sb = new StringBuilder();
        if (lines != null) {
            String emptyOrNewLine = "";
            for (String line : lines) {
                sb.append(emptyOrNewLine).append(line);
                emptyOrNewLine = "\n";
            }
        }
        return sb.toString();
    }

    public String toString() {
        return this.getStdout();
    }
}

