/*
 * Decompiled with CFR 0.152.
 */
package com.jrummyapps.android.shell;

import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.jrummyapps.android.shell.CommandResult;
import com.jrummyapps.android.shell.ShellExitCode;
import com.jrummyapps.android.shell.ShellNotFoundException;
import com.jrummyapps.android.shell.StreamGobbler;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class Shell {
    static final String[] AVAILABLE_TEST_COMMANDS = new String[]{"echo -BOC-", "id"};

    @WorkerThread
    public static CommandResult run(@NonNull String shell, String ... commands) {
        return Shell.run(shell, commands, null);
    }

    @WorkerThread
    public static CommandResult run(@NonNull String shell, @NonNull String[] commands, @Nullable String[] env) {
        int exitCode;
        List<String> stdout = Collections.synchronizedList(new ArrayList());
        List<String> stderr = Collections.synchronizedList(new ArrayList());
        try {
            StreamGobbler stderrGobbler;
            StreamGobbler stdoutGobbler;
            DataOutputStream stdin;
            Process process;
            block8: {
                process = Shell.runWithEnv(shell, env);
                stdin = new DataOutputStream(process.getOutputStream());
                stdoutGobbler = new StreamGobbler(process.getInputStream(), stdout);
                stderrGobbler = new StreamGobbler(process.getErrorStream(), stderr);
                stdoutGobbler.start();
                stderrGobbler.start();
                try {
                    for (String write : commands) {
                        stdin.write((write + "\n").getBytes("UTF-8"));
                        stdin.flush();
                    }
                    stdin.write("exit\n".getBytes("UTF-8"));
                    stdin.flush();
                }
                catch (IOException e) {
                    if (e.getMessage().contains("EPIPE")) break block8;
                    throw e;
                }
            }
            exitCode = process.waitFor();
            try {
                stdin.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            stdoutGobbler.join();
            stderrGobbler.join();
            process.destroy();
        }
        catch (InterruptedException e) {
            exitCode = -1;
        }
        catch (IOException e) {
            exitCode = -4;
        }
        return new CommandResult(stdout, stderr, exitCode);
    }

    @WorkerThread
    public static Process runWithEnv(@NonNull String command, @Nullable String[] environment) throws IOException {
        if (environment != null) {
            HashMap<String, String> newEnvironment = new HashMap<String, String>();
            newEnvironment.putAll(System.getenv());
            for (String entry : environment) {
                int split = entry.indexOf("=");
                if (split < 0) continue;
                newEnvironment.put(entry.substring(0, split), entry.substring(split + 1));
            }
            int i = 0;
            environment = new String[newEnvironment.size()];
            for (Map.Entry entry : newEnvironment.entrySet()) {
                environment[i] = (String)entry.getKey() + "=" + (String)entry.getValue();
                ++i;
            }
        }
        return Runtime.getRuntime().exec(command, environment);
    }

    @WorkerThread
    public static Process runWithEnv(@NonNull String command, Map<String, String> environment) throws IOException {
        String[] env;
        if (environment != null && environment.size() != 0) {
            HashMap<String, String> newEnvironment = new HashMap<String, String>();
            newEnvironment.putAll(System.getenv());
            newEnvironment.putAll(environment);
            int i = 0;
            env = new String[newEnvironment.size()];
            for (Map.Entry entry : newEnvironment.entrySet()) {
                env[i] = (String)entry.getKey() + "=" + (String)entry.getValue();
                ++i;
            }
        } else {
            env = null;
        }
        return Runtime.getRuntime().exec(command, env);
    }

    static boolean parseAvailableResult(List<String> stdout, boolean checkForRoot) {
        if (stdout == null) {
            return false;
        }
        boolean echoSeen = false;
        for (String line : stdout) {
            if (line.contains("uid=")) {
                return !checkForRoot || line.contains("uid=0");
            }
            if (!line.contains("-BOC-")) continue;
            echoSeen = true;
        }
        return echoSeen;
    }

    public static class Console
    implements Closeable {
        private final OnCloseListener onCloseListener;
        private final Interactive shell;
        final HandlerThread callbackThread;
        private final boolean wantStderr;
        List<String> stdout;
        List<String> stderr;
        int exitCode;
        boolean isCommandRunning;
        private boolean closed;
        private final OnCommandResultListener commandResultListener = new OnCommandResultListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCommandResult(int commandCode, int exitCode, List<String> stdout) {
                Console.this.exitCode = exitCode;
                Console.this.stdout = stdout;
                HandlerThread handlerThread = Console.this.callbackThread;
                synchronized (handlerThread) {
                    Console.this.isCommandRunning = false;
                    Console.this.callbackThread.notifyAll();
                }
            }
        };

        Console(Builder builder) throws ShellNotFoundException {
            try {
                this.onCloseListener = builder.onCloseListener;
                this.wantStderr = builder.wantStderr;
                this.callbackThread = new HandlerThread("Shell Callback");
                this.callbackThread.start();
                this.isCommandRunning = true;
                com.jrummyapps.android.shell.Shell$Builder shellBuilder = new com.jrummyapps.android.shell.Shell$Builder();
                shellBuilder.setShell(builder.shell);
                shellBuilder.setHandler(new Handler(this.callbackThread.getLooper()));
                shellBuilder.setWatchdogTimeout(builder.watchdogTimeout);
                shellBuilder.addEnvironment(builder.environment);
                shellBuilder.setWantStderr(false);
                if (builder.wantStderr) {
                    shellBuilder.setOnStderrLineListener(new StreamGobbler.OnLineListener(){

                        @Override
                        public void onLine(String line) {
                            if (Console.this.stderr != null) {
                                Console.this.stderr.add(line);
                            }
                        }
                    });
                }
                this.shell = shellBuilder.open(this.commandResultListener);
                this.waitForCommandFinished();
                if (this.exitCode != 0) {
                    this.close();
                    throw new ShellNotFoundException("Access was denied or this is not a shell");
                }
            }
            catch (Exception e) {
                throw new ShellNotFoundException("Error opening shell '" + builder.shell + "'", e);
            }
        }

        @WorkerThread
        public synchronized CommandResult run(String ... commands) {
            this.isCommandRunning = true;
            this.stderr = this.wantStderr ? Collections.synchronizedList(new ArrayList()) : Collections.emptyList();
            this.shell.addCommand(commands, 0, this.commandResultListener);
            this.waitForCommandFinished();
            CommandResult result = new CommandResult(this.stdout, this.stderr, this.exitCode);
            this.stderr = null;
            this.stdout = null;
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void close() {
            try {
                this.shell.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            HandlerThread handlerThread = this.callbackThread;
            synchronized (handlerThread) {
                this.callbackThread.notifyAll();
            }
            this.callbackThread.interrupt();
            this.callbackThread.quit();
            this.closed = true;
            if (this.onCloseListener != null) {
                this.onCloseListener.onClosed(this);
            }
        }

        public boolean isClosed() {
            return this.closed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitForCommandFinished() {
            HandlerThread handlerThread = this.callbackThread;
            synchronized (handlerThread) {
                while (this.isCommandRunning) {
                    try {
                        this.callbackThread.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (this.exitCode == -1 || this.exitCode == -2) {
                this.close();
            }
        }

        public static class Builder {
            OnCloseListener onCloseListener;
            Map<String, String> environment = new HashMap<String, String>();
            String shell = "sh";
            boolean wantStderr = true;
            int watchdogTimeout;

            public Builder setShell(String shell) {
                this.shell = shell;
                return this;
            }

            public Builder useSH() {
                return this.setShell("sh");
            }

            public Builder useSU() {
                return this.setShell("su");
            }

            public Builder setWantStderr(boolean wantStderr) {
                this.wantStderr = wantStderr;
                return this;
            }

            public Builder setWatchdogTimeout(int watchdogTimeout) {
                this.watchdogTimeout = watchdogTimeout;
                return this;
            }

            public Builder addEnvironment(String key, String value) {
                this.environment.put(key, value);
                return this;
            }

            public Builder addEnvironment(Map<String, String> addEnvironment) {
                this.environment.putAll(addEnvironment);
                return this;
            }

            public Builder setOnCloseListener(OnCloseListener onCloseListener) {
                this.onCloseListener = onCloseListener;
                return this;
            }

            public Console build() throws ShellNotFoundException {
                return new Console(this);
            }
        }

        public static interface OnCloseListener {
            public void onClosed(Console var1);
        }
    }

    public static class Interactive {
        private final Handler handler;
        private final boolean autoHandler;
        final String shell;
        final boolean wantSTDERR;
        private final List<Command> commands;
        private final Map<String, String> environment;
        final StreamGobbler.OnLineListener onStdoutLineListener;
        final StreamGobbler.OnLineListener onStderrLineListener;
        private final Object idleSync = new Object();
        private final Object callbackSync = new Object();
        volatile String lastMarkerStdout;
        volatile String lastMarkerStderr;
        volatile Command command;
        private volatile List<String> buffer;
        private volatile boolean running;
        private volatile boolean idle = true;
        private volatile boolean closed = true;
        private volatile int callbacks;
        private volatile int watchdogCount;
        volatile int lastExitCode;
        private Process process;
        private DataOutputStream stdin;
        private StreamGobbler stdout;
        private StreamGobbler stderr;
        private ScheduledThreadPoolExecutor watchdog;
        int watchdogTimeout;

        Interactive(final Builder builder, final OnCommandResultListener onCommandResultListener) {
            this.autoHandler = builder.autoHandler;
            this.shell = builder.shell;
            this.wantSTDERR = builder.wantStderr;
            this.commands = builder.commands;
            this.environment = builder.environment;
            this.onStdoutLineListener = builder.onStdoutLineListener;
            this.onStderrLineListener = builder.onStderrLineListener;
            this.watchdogTimeout = builder.watchdogTimeout;
            this.handler = Looper.myLooper() != null && builder.handler == null && this.autoHandler ? new Handler() : builder.handler;
            if (onCommandResultListener != null) {
                this.watchdogTimeout = 60;
                this.commands.add(0, new Command(AVAILABLE_TEST_COMMANDS, 0, new OnCommandResultListener(){

                    @Override
                    public void onCommandResult(int commandCode, int exitCode, List<String> output) {
                        if (exitCode == 0 && !Shell.parseAvailableResult(output, SU.isSU(Interactive.this.shell))) {
                            exitCode = -3;
                        }
                        Interactive.this.watchdogTimeout = builder.watchdogTimeout;
                        onCommandResultListener.onCommandResult(0, exitCode, output);
                    }
                }, null));
            }
            if (!this.open() && onCommandResultListener != null) {
                onCommandResultListener.onCommandResult(0, -4, null);
            }
        }

        public void addCommand(String ... commands) {
            this.addCommand(commands, 0, (OnCommandResultListener)null);
        }

        public void addCommand(@NonNull String command, int code, @Nullable OnCommandResultListener resultListener) {
            this.addCommand(new String[]{command}, code, resultListener);
        }

        public void addCommand(@NonNull String command, int code, @Nullable OnCommandLineListener onCommandLineListener) {
            this.addCommand(new String[]{command}, code, onCommandLineListener);
        }

        public void addCommand(@NonNull List<String> commands) {
            this.addCommand(commands, 0, (OnCommandResultListener)null);
        }

        public void addCommand(@NonNull List<String> commands, int code, @Nullable OnCommandResultListener onCommandResultListener) {
            this.addCommand(commands.toArray(new String[commands.size()]), code, onCommandResultListener);
        }

        public void addCommand(@NonNull List<String> commands, int code, @Nullable OnCommandLineListener lineListener) {
            this.addCommand(commands.toArray(new String[commands.size()]), code, lineListener);
        }

        public synchronized void addCommand(@NonNull String[] commands, int code, @Nullable OnCommandResultListener resultListener) {
            this.commands.add(new Command(commands, code, resultListener, null));
            this.runNextCommand();
        }

        public synchronized void addCommand(@NonNull String[] commands, int code, @Nullable OnCommandLineListener onCommandLineListener) {
            this.commands.add(new Command(commands, code, null, onCommandLineListener));
            this.runNextCommand();
        }

        private void runNextCommand() {
            this.runNextCommand(true);
        }

        synchronized void handleWatchdog() {
            int exitCode;
            if (this.watchdog == null) {
                return;
            }
            if (this.watchdogTimeout == 0) {
                return;
            }
            if (!this.isRunning()) {
                exitCode = -2;
            } else {
                if (this.watchdogCount++ < this.watchdogTimeout) {
                    return;
                }
                exitCode = -1;
            }
            if (this.handler != null) {
                this.postCallback(this.command, exitCode, this.buffer);
            }
            this.command = null;
            this.buffer = null;
            this.idle = true;
            this.watchdog.shutdown();
            this.watchdog = null;
            this.kill();
        }

        private void startWatchdog() {
            if (this.watchdogTimeout == 0) {
                return;
            }
            this.watchdogCount = 0;
            this.watchdog = new ScheduledThreadPoolExecutor(1);
            this.watchdog.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    Interactive.this.handleWatchdog();
                }
            }, 1L, 1L, TimeUnit.SECONDS);
        }

        private void stopWatchdog() {
            if (this.watchdog != null) {
                this.watchdog.shutdownNow();
                this.watchdog = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runNextCommand(boolean notifyIdle) {
            boolean running = this.isRunning();
            if (!running) {
                this.idle = true;
            }
            if (running && this.idle && this.commands.size() > 0) {
                Command command = this.commands.get(0);
                this.commands.remove(0);
                this.buffer = null;
                this.lastExitCode = 0;
                this.lastMarkerStdout = null;
                this.lastMarkerStderr = null;
                if (command.commands.length > 0) {
                    try {
                        if (command.onCommandResultListener != null) {
                            this.buffer = Collections.synchronizedList(new ArrayList());
                        }
                        this.idle = false;
                        this.command = command;
                        this.startWatchdog();
                        for (String write : command.commands) {
                            this.stdin.write((write + "\n").getBytes("UTF-8"));
                        }
                        this.stdin.write(("echo " + command.marker + " $?\n").getBytes("UTF-8"));
                        this.stdin.write(("echo " + command.marker + " >&2\n").getBytes("UTF-8"));
                        this.stdin.flush();
                    }
                    catch (IOException iOException) {}
                } else {
                    this.runNextCommand(false);
                }
            } else if (!running) {
                while (this.commands.size() > 0) {
                    this.postCallback(this.commands.remove(0), -2, null);
                }
            }
            if (this.idle && notifyIdle) {
                Object object = this.idleSync;
                synchronized (object) {
                    this.idleSync.notifyAll();
                }
            }
        }

        synchronized void processMarker() {
            if (this.command.marker.equals(this.lastMarkerStdout) && this.command.marker.equals(this.lastMarkerStderr)) {
                this.postCallback(this.command, this.lastExitCode, this.buffer);
                this.stopWatchdog();
                this.command = null;
                this.buffer = null;
                this.idle = true;
                this.runNextCommand();
            }
        }

        synchronized void processLine(String line, StreamGobbler.OnLineListener listener) {
            if (listener != null) {
                if (this.handler != null) {
                    final String fLine = line;
                    final StreamGobbler.OnLineListener fListener = listener;
                    this.startCallback();
                    this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                fListener.onLine(fLine);
                            }
                            finally {
                                Interactive.this.endCallback();
                            }
                        }
                    });
                } else {
                    listener.onLine(line);
                }
            }
        }

        synchronized void addBuffer(String line) {
            if (this.buffer != null) {
                this.buffer.add(line);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startCallback() {
            Object object = this.callbackSync;
            synchronized (object) {
                ++this.callbacks;
            }
        }

        private void postCallback(final Command fCommand, final int fExitCode, final List<String> fOutput) {
            if (fCommand.onCommandResultListener == null && fCommand.onCommandLineListener == null) {
                return;
            }
            if (this.handler == null) {
                if (fCommand.onCommandResultListener != null && fOutput != null) {
                    fCommand.onCommandResultListener.onCommandResult(fCommand.code, fExitCode, fOutput);
                }
                if (fCommand.onCommandLineListener != null) {
                    fCommand.onCommandLineListener.onCommandResult(fCommand.code, fExitCode);
                }
                return;
            }
            this.startCallback();
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (fCommand.onCommandResultListener != null && fOutput != null) {
                            fCommand.onCommandResultListener.onCommandResult(fCommand.code, fExitCode, fOutput);
                        }
                        if (fCommand.onCommandLineListener != null) {
                            fCommand.onCommandLineListener.onCommandResult(fCommand.code, fExitCode);
                        }
                    }
                    finally {
                        Interactive.this.endCallback();
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void endCallback() {
            Object object = this.callbackSync;
            synchronized (object) {
                --this.callbacks;
                if (this.callbacks == 0) {
                    this.callbackSync.notifyAll();
                }
            }
        }

        private synchronized boolean open() {
            try {
                this.process = Shell.runWithEnv(this.shell, this.environment);
                this.stdin = new DataOutputStream(this.process.getOutputStream());
                this.stdout = new StreamGobbler(this.process.getInputStream(), new StreamGobbler.OnLineListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onLine(String line) {
                        Interactive interactive = Interactive.this;
                        synchronized (interactive) {
                            if (Interactive.this.command == null) {
                                return;
                            }
                            String contentPart = line;
                            String markerPart = null;
                            int markerIndex = line.indexOf(Interactive.this.command.marker);
                            if (markerIndex == 0) {
                                contentPart = null;
                                markerPart = line;
                            } else if (markerIndex > 0) {
                                contentPart = line.substring(0, markerIndex);
                                markerPart = line.substring(markerIndex);
                            }
                            if (contentPart != null) {
                                Interactive.this.addBuffer(contentPart);
                                Interactive.this.processLine(contentPart, Interactive.this.onStdoutLineListener);
                                Interactive.this.processLine(contentPart, Interactive.this.command.onCommandLineListener);
                            }
                            if (markerPart != null) {
                                try {
                                    Interactive.this.lastExitCode = Integer.valueOf(markerPart.substring(Interactive.this.command.marker.length() + 1), 10);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                Interactive.this.lastMarkerStdout = Interactive.this.command.marker;
                                Interactive.this.processMarker();
                            }
                        }
                    }
                });
                this.stderr = new StreamGobbler(this.process.getErrorStream(), new StreamGobbler.OnLineListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onLine(String line) {
                        Interactive interactive = Interactive.this;
                        synchronized (interactive) {
                            if (Interactive.this.command == null) {
                                return;
                            }
                            String contentPart = line;
                            int markerIndex = line.indexOf(Interactive.this.command.marker);
                            if (markerIndex == 0) {
                                contentPart = null;
                            } else if (markerIndex > 0) {
                                contentPart = line.substring(0, markerIndex);
                            }
                            if (contentPart != null) {
                                if (Interactive.this.wantSTDERR) {
                                    Interactive.this.addBuffer(contentPart);
                                }
                                Interactive.this.processLine(contentPart, Interactive.this.onStderrLineListener);
                            }
                            if (markerIndex >= 0) {
                                Interactive.this.lastMarkerStderr = Interactive.this.command.marker;
                                Interactive.this.processMarker();
                            }
                        }
                    }
                });
                this.stdout.start();
                this.stderr.start();
                this.running = true;
                this.closed = false;
                this.runNextCommand();
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            boolean idle = this.isIdle();
            Interactive interactive = this;
            synchronized (interactive) {
                if (!this.running) {
                    return;
                }
                this.running = false;
                this.closed = true;
            }
            if (!idle) {
                this.waitForIdle();
            }
            try {
                block11: {
                    try {
                        this.stdin.write("exit\n".getBytes("UTF-8"));
                        this.stdin.flush();
                    }
                    catch (IOException e) {
                        if (e.getMessage().contains("EPIPE")) break block11;
                        throw e;
                    }
                }
                this.process.waitFor();
                try {
                    this.stdin.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.stdout.join();
                this.stderr.join();
                this.stopWatchdog();
                this.process.destroy();
            }
            catch (IOException | InterruptedException exception) {
                // empty catch block
            }
        }

        public synchronized void kill() {
            this.running = false;
            this.closed = true;
            try {
                this.stdin.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.process.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public boolean isRunning() {
            if (this.process == null) {
                return false;
            }
            try {
                this.process.exitValue();
                return false;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized boolean isIdle() {
            if (!this.isRunning()) {
                this.idle = true;
                Object object = this.idleSync;
                synchronized (object) {
                    this.idleSync.notifyAll();
                }
            }
            return this.idle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean waitForIdle() {
            if (this.isRunning()) {
                Object object = this.idleSync;
                synchronized (object) {
                    while (!this.idle) {
                        try {
                            this.idleSync.wait();
                        }
                        catch (InterruptedException e) {
                            return false;
                        }
                    }
                }
                if (this.handler != null && this.handler.getLooper() != null && this.handler.getLooper() != Looper.myLooper()) {
                    object = this.callbackSync;
                    synchronized (object) {
                        while (this.callbacks > 0) {
                            try {
                                this.callbackSync.wait();
                            }
                            catch (InterruptedException e) {
                                return false;
                            }
                        }
                    }
                }
            }
            return true;
        }

        public boolean hasHandler() {
            return this.handler != null;
        }
    }

    public static class Builder {
        private Map<String, String> environment = new HashMap<String, String>();
        private List<Command> commands = new LinkedList<Command>();
        private StreamGobbler.OnLineListener onStdoutLineListener;
        private StreamGobbler.OnLineListener onStderrLineListener;
        private Handler handler;
        private boolean autoHandler = true;
        private boolean wantStderr;
        private String shell = "sh";
        private int watchdogTimeout;

        public Builder setHandler(Handler handler) {
            this.handler = handler;
            return this;
        }

        public Builder setAutoHandler(boolean autoHandler) {
            this.autoHandler = autoHandler;
            return this;
        }

        public Builder setShell(String shell) {
            this.shell = shell;
            return this;
        }

        public Builder useSH() {
            return this.setShell("sh");
        }

        public Builder useSU() {
            return this.setShell("su");
        }

        public Builder setWantStderr(boolean wantStderr) {
            this.wantStderr = wantStderr;
            return this;
        }

        public Builder addEnvironment(String key, String value) {
            this.environment.put(key, value);
            return this;
        }

        public Builder addEnvironment(Map<String, String> addEnvironment) {
            this.environment.putAll(addEnvironment);
            return this;
        }

        public Builder addCommand(String command) {
            return this.addCommand(command, 0, null);
        }

        public Builder addCommand(String command, int code, OnCommandResultListener onCommandResultListener) {
            return this.addCommand(new String[]{command}, code, onCommandResultListener);
        }

        public Builder addCommand(List<String> commands) {
            return this.addCommand(commands, 0, null);
        }

        public Builder addCommand(List<String> commands, int code, OnCommandResultListener onCommandResultListener) {
            return this.addCommand(commands.toArray(new String[commands.size()]), code, onCommandResultListener);
        }

        public Builder addCommand(String[] commands) {
            return this.addCommand(commands, 0, null);
        }

        public Builder addCommand(String[] commands, int code, OnCommandResultListener onCommandResultListener) {
            this.commands.add(new Command(commands, code, onCommandResultListener, null));
            return this;
        }

        public Builder setOnStdoutLineListener(StreamGobbler.OnLineListener onLineListener) {
            this.onStdoutLineListener = onLineListener;
            return this;
        }

        public Builder setOnStderrLineListener(StreamGobbler.OnLineListener onLineListener) {
            this.onStderrLineListener = onLineListener;
            return this;
        }

        public Builder setWatchdogTimeout(int watchdogTimeout) {
            this.watchdogTimeout = watchdogTimeout;
            return this;
        }

        @WorkerThread
        public Interactive open() {
            return new Interactive(this, null);
        }

        @WorkerThread
        public Interactive open(OnCommandResultListener onCommandResultListener) {
            return new Interactive(this, onCommandResultListener);
        }
    }

    private static class Command {
        private static int commandCounter = 0;
        private final String[] commands;
        private final int code;
        private final OnCommandResultListener onCommandResultListener;
        private final OnCommandLineListener onCommandLineListener;
        private final String marker;

        public Command(String[] commands, int code, OnCommandResultListener onCommandResultListener, OnCommandLineListener onCommandLineListener) {
            this.commands = commands;
            this.code = code;
            this.onCommandResultListener = onCommandResultListener;
            this.onCommandLineListener = onCommandLineListener;
            this.marker = UUID.randomUUID().toString() + String.format("-%08x", ++commandCounter);
        }
    }

    public static interface OnCommandLineListener
    extends ShellExitCode,
    StreamGobbler.OnLineListener {
        public void onCommandResult(int var1, int var2);
    }

    public static interface OnCommandResultListener
    extends ShellExitCode {
        public void onCommandResult(int var1, int var2, List<String> var3);
    }

    public static class SU {
        private static Boolean isSELinuxEnforcing = null;
        private static String[] suVersion = new String[]{null, null};
        private static volatile Console console;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @WorkerThread
        public static Console getConsole() throws ShellNotFoundException {
            if (console != null && !console.isClosed()) return console;
            Class<SH> clazz = SH.class;
            synchronized (SH.class) {
                if (console != null && !console.isClosed()) return console;
                console = new Console.Builder().useSU().setWatchdogTimeout(30).build();
                // ** MonitorExit[var0] (shouldn't be in output)
                return console;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static void closeConsole() {
            if (console == null) return;
            Class<SU> clazz = SU.class;
            synchronized (SU.class) {
                if (console == null) return;
                console.close();
                console = null;
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        }

        @WorkerThread
        public static CommandResult run(String ... commands) {
            try {
                Console console = SU.getConsole();
                return console.run(commands);
            }
            catch (ShellNotFoundException e) {
                return new CommandResult(Collections.emptyList(), Collections.emptyList(), -5);
            }
        }

        @WorkerThread
        public static boolean available() {
            CommandResult result = SU.run(AVAILABLE_TEST_COMMANDS);
            return Shell.parseAvailableResult(result.stdout, true);
        }

        @WorkerThread
        public static synchronized String version(boolean internal) {
            int idx;
            int n = idx = internal ? 0 : 1;
            if (suVersion[idx] == null) {
                String version = null;
                CommandResult result = Shell.run(internal ? "su -V" : "su -v", "exit");
                for (String line : result.stdout) {
                    if (!internal) {
                        if (line.trim().equals("")) continue;
                        version = line;
                        break;
                    }
                    try {
                        if (Integer.parseInt(line) <= 0) continue;
                        version = line;
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                }
                SU.suVersion[idx] = version;
            }
            return suVersion[idx];
        }

        public static boolean isSU(@NonNull String shell) {
            int pos = shell.indexOf(32);
            if (pos >= 0) {
                shell = shell.substring(0, pos);
            }
            if ((pos = shell.lastIndexOf(47)) >= 0) {
                shell = shell.substring(pos + 1);
            }
            return shell.equals("su");
        }

        public static String shell(int uid, @Nullable String context) {
            String shell = "su";
            if (context != null && SU.isSELinuxEnforcing()) {
                String display = SU.version(false);
                String internal = SU.version(true);
                if (display != null && internal != null && display.endsWith("SUPERSU") && Integer.valueOf(internal) >= 190) {
                    shell = String.format(Locale.ENGLISH, "%s --context %s", shell, context);
                }
            }
            if (uid > 0) {
                shell = String.format(Locale.ENGLISH, "%s %d", shell, uid);
            }
            return shell;
        }

        public static String shellMountMaster() {
            if (Build.VERSION.SDK_INT >= 17) {
                return "su --mount-master";
            }
            return "su";
        }

        @WorkerThread
        public static synchronized boolean isSELinuxEnforcing() {
            if (isSELinuxEnforcing == null) {
                Boolean enforcing = null;
                if (Build.VERSION.SDK_INT >= 17) {
                    File f = new File("/sys/fs/selinux/enforce");
                    if (f.exists()) {
                        try (FileInputStream is2 = new FileInputStream("/sys/fs/selinux/enforce");){
                            enforcing = ((InputStream)is2).read() == 49;
                        }
                        catch (Exception is2) {
                            // empty catch block
                        }
                    }
                    if (enforcing == null) {
                        try {
                            Class<?> SELinux = Class.forName("android.os.SELinux");
                            Method isSELinuxEnforced = SELinux.getMethod("isSELinuxEnforced", new Class[0]);
                            if (!isSELinuxEnforced.isAccessible()) {
                                isSELinuxEnforced.setAccessible(true);
                            }
                            enforcing = (Boolean)isSELinuxEnforced.invoke(SELinux.newInstance(), new Object[0]);
                        }
                        catch (Exception e) {
                            enforcing = Build.VERSION.SDK_INT >= 19;
                        }
                    }
                }
                if (enforcing == null) {
                    enforcing = false;
                }
                isSELinuxEnforcing = enforcing;
            }
            return isSELinuxEnforcing;
        }

        public static synchronized void clearCachedResults() {
            isSELinuxEnforcing = null;
            SU.suVersion[0] = null;
            SU.suVersion[1] = null;
        }
    }

    public static class SH {
        private static volatile Console console;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @WorkerThread
        public static Console getConsole() throws ShellNotFoundException {
            if (console != null && !console.isClosed()) return console;
            Class<SH> clazz = SH.class;
            synchronized (SH.class) {
                if (console != null && !console.isClosed()) return console;
                console = new Console.Builder().useSH().setWatchdogTimeout(30).build();
                // ** MonitorExit[var0] (shouldn't be in output)
                return console;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static void closeConsole() {
            if (console == null) return;
            Class<SH> clazz = SH.class;
            synchronized (SH.class) {
                if (console == null) return;
                console.close();
                console = null;
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        }

        @WorkerThread
        public static CommandResult run(String ... commands) {
            return Shell.run("sh", commands);
        }
    }
}

