/*
 * Decompiled with CFR 0.152.
 */
package js.converter;

import js.converter.Converter;
import js.lang.NoSuchBeingException;
import js.log.Log;
import js.log.LogFactory;
import js.util.Classes;

final class ClassConverter
implements Converter {
    private static final Log log = LogFactory.getLog(ClassConverter.class);

    ClassConverter() {
    }

    @Override
    public <T> T asObject(String string, Class<T> valueType) {
        if (string.isEmpty()) {
            return null;
        }
        try {
            return (T)Classes.forName(string);
        }
        catch (NoSuchBeingException e) {
            log.warn("Class |%s| not found. Class converter force return value to null.", string);
            return null;
        }
    }

    @Override
    public String asString(Object object) {
        assert (object != null);
        assert (object instanceof Class);
        return ((Class)object).getCanonicalName();
    }
}

