/*
 * Decompiled with CFR 0.152.
 */
package js.converter;

import java.io.File;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.IdentityHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.TimeZone;
import js.converter.BooleansConverter;
import js.converter.CharactersConverter;
import js.converter.CharsetConverter;
import js.converter.ClassConverter;
import js.converter.Converter;
import js.converter.ConverterException;
import js.converter.ConverterProvider;
import js.converter.DatesConverter;
import js.converter.EnumsConverter;
import js.converter.FileConverter;
import js.converter.LocaleConverter;
import js.converter.NumbersConverter;
import js.converter.TimeZoneConverter;
import js.converter.UrlConverter;
import js.log.Log;
import js.log.LogFactory;
import js.util.Classes;
import js.util.Params;
import js.util.Types;

public final class ConverterRegistry
implements Converter {
    private static final Log log = LogFactory.getLog(ConverterRegistry.class);
    private static final ConverterRegistry instance = new ConverterRegistry();
    private Map<Class<?>, Converter> converters = new IdentityHashMap();
    private Map<Class<?>, Converter> abstractConverters = new IdentityHashMap();
    private Converter enumsConverter = new EnumsConverter();

    public static ConverterRegistry getInstance() {
        return instance;
    }

    public static boolean hasType(Type valueType) {
        return valueType instanceof Class ? instance.hasClassConverter((Class)valueType) : false;
    }

    public static Converter getConverter() {
        return instance.getConverterInstance();
    }

    private ConverterRegistry() {
        BooleansConverter booleansConverter = new BooleansConverter();
        this.converters.put(Boolean.class, booleansConverter);
        this.converters.put(Boolean.TYPE, booleansConverter);
        CharactersConverter charactersConverter = new CharactersConverter();
        this.converters.put(Character.class, charactersConverter);
        this.converters.put(Character.TYPE, charactersConverter);
        NumbersConverter numbersConverter = new NumbersConverter();
        this.converters.put(Byte.class, numbersConverter);
        this.converters.put(Short.class, numbersConverter);
        this.converters.put(Integer.class, numbersConverter);
        this.converters.put(Long.class, numbersConverter);
        this.converters.put(Float.class, numbersConverter);
        this.converters.put(Double.class, numbersConverter);
        this.converters.put(Byte.TYPE, numbersConverter);
        this.converters.put(Short.TYPE, numbersConverter);
        this.converters.put(Integer.TYPE, numbersConverter);
        this.converters.put(Long.TYPE, numbersConverter);
        this.converters.put(Float.TYPE, numbersConverter);
        this.converters.put(Double.TYPE, numbersConverter);
        DatesConverter datesConverter = new DatesConverter();
        this.converters.put(java.util.Date.class, datesConverter);
        this.converters.put(Date.class, datesConverter);
        this.converters.put(Time.class, datesConverter);
        this.converters.put(Timestamp.class, datesConverter);
        this.converters.put(Class.class, new ClassConverter());
        this.converters.put(File.class, new FileConverter());
        this.converters.put(URL.class, new UrlConverter());
        this.converters.put(Locale.class, new LocaleConverter());
        this.converters.put(Charset.class, new CharsetConverter());
        this.abstractConverters.put(TimeZone.class, new TimeZoneConverter());
        for (ConverterProvider converterProvider : ServiceLoader.load(ConverterProvider.class)) {
            for (Map.Entry<Class<?>, Class<Converter>> entry : converterProvider.getConverters().entrySet()) {
                this.registerConverter(entry.getKey(), entry.getValue());
            }
        }
    }

    public void registerConverter(Class<?> valueType, Class<? extends Converter> converterClass) {
        Converter converter = Classes.newInstance(converterClass, new Object[0]);
        if (Types.isConcrete(valueType)) {
            this.registerConverterInstance(valueType, converter);
        } else if (this.abstractConverters.put(valueType, converter) == null) {
            log.debug("Register abstract converter |%s| for value type |%s|.", converterClass, valueType);
        } else {
            log.warn("Override abstract converter |%s| for value type |%s|.", converterClass, valueType);
        }
    }

    public Converter getConverterInstance() {
        return this;
    }

    public boolean hasClassConverter(Class<?> classConverter) {
        return this.getConverter(classConverter) != null || String.class.equals(classConverter);
    }

    @Override
    public <T> T asObject(String string, Class<T> valueType) {
        Params.notNull(valueType, "Value type", new Object[0]);
        if (string == null) {
            return null;
        }
        if (valueType == Object.class) {
            return (T)string;
        }
        if (valueType == String.class) {
            return (T)string;
        }
        Converter converter = this.getConverter(valueType);
        if (converter == null) {
            throw new ConverterException("No registered converter for |%s|.", valueType);
        }
        try {
            return converter.asObject(string, valueType);
        }
        catch (ConverterException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ConverterException(t);
        }
    }

    @Override
    public String asString(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        Converter converter = this.getConverter(object.getClass());
        if (converter == null) {
            throw new ConverterException("No registered converter for |%s|.", object.getClass());
        }
        try {
            return converter.asString(object);
        }
        catch (ConverterException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ConverterException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Converter getConverter(Class<?> valueType) {
        Converter c = this.converters.get(valueType);
        if (c == null) {
            Map<Class<?>, Converter> map = this.converters;
            synchronized (map) {
                if (c == null) {
                    if (Types.isKindOf(valueType, new Type[]{Converter.class})) {
                        this.registerConverter(valueType, valueType);
                    } else {
                        for (Map.Entry<Class<?>, Converter> entries : this.abstractConverters.entrySet()) {
                            if (!Types.isKindOf(valueType, new Type[]{entries.getKey()})) continue;
                            this.registerConverterInstance(valueType, entries.getValue());
                        }
                    }
                    c = this.converters.get(valueType);
                }
            }
        }
        if (c == null && valueType.isEnum()) {
            return this.enumsConverter;
        }
        return c;
    }

    private void registerConverterInstance(Class<?> valueType, Converter converter) {
        if (this.converters.put(valueType, converter) == null) {
            log.debug("Register converter |%s| for value type |%s|.", converter.getClass(), valueType);
        } else {
            log.warn("Override converter |%s| for value type |%s|.", converter.getClass(), valueType);
        }
    }
}

