/*
 * Decompiled with CFR 0.152.
 */
package js.converter;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import js.converter.Converter;
import js.converter.ConverterException;
import js.lang.BugError;

final class DatesConverter
implements Converter {
    private static ThreadLocal<DateFormat> dateParser = new ThreadLocal();

    DatesConverter() {
    }

    @Override
    public <T> T asObject(String string, Class<T> valueType) {
        ParsePosition parsePosition;
        Date date;
        if (string.isEmpty()) {
            return null;
        }
        DateFormat df = dateParser.get();
        if (df == null) {
            df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            df.setTimeZone(TimeZone.getTimeZone("UTC"));
            dateParser.set(df);
        }
        if ((date = df.parse(string, parsePosition = new ParsePosition(0))) == null) {
            throw new ConverterException("Cannot parse ISO8601 date from |%s| at position |%d|.", string, parsePosition.getErrorIndex());
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(14, 0);
        long time = calendar.getTimeInMillis();
        if (valueType == Date.class) {
            return (T)new Date(time);
        }
        if (valueType == java.sql.Date.class) {
            return (T)new java.sql.Date(time);
        }
        if (valueType == Time.class) {
            return (T)new Time(time);
        }
        if (valueType == Timestamp.class) {
            return (T)new Timestamp(time);
        }
        throw new BugError("Unsupported date type |%s|.", valueType);
    }

    @Override
    public String asString(Object object) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.setTime((Date)object);
        StringBuilder builder = new StringBuilder();
        int year = calendar.get(1);
        if (calendar.get(0) == 0) {
            if (year > 1) {
                builder.append('-');
            }
            --year;
        }
        builder.append(String.format("%04d", year));
        builder.append('-');
        builder.append(String.format("%02d", calendar.get(2) + 1));
        builder.append('-');
        builder.append(String.format("%02d", calendar.get(5)));
        builder.append('T');
        builder.append(String.format("%02d", calendar.get(11)));
        builder.append(':');
        builder.append(String.format("%02d", calendar.get(12)));
        builder.append(':');
        builder.append(String.format("%02d", calendar.get(13)));
        builder.append('Z');
        return builder.toString();
    }
}

