/*
 * Decompiled with CFR 0.152.
 */
package js.converter;

import java.lang.reflect.Type;
import js.converter.Converter;
import js.lang.OrdinalEnum;
import js.util.Types;

final class EnumsConverter
implements Converter {
    EnumsConverter() {
    }

    @Override
    public <T> T asObject(String string, Class<T> valueType) throws IllegalArgumentException {
        if (string.isEmpty()) {
            return null;
        }
        if (Types.isKindOf(valueType, new Type[]{OrdinalEnum.class})) {
            return valueType.getEnumConstants()[Integer.parseInt(string)];
        }
        return Enum.valueOf(valueType, string);
    }

    @Override
    public String asString(Object object) {
        Enum e = (Enum)object;
        if (object instanceof OrdinalEnum) {
            return Integer.toString(e.ordinal());
        }
        return e.name();
    }
}

