/*
 * Decompiled with CFR 0.152.
 */
package js.converter;

import java.util.Locale;
import js.converter.Converter;

final class LocaleConverter
implements Converter {
    LocaleConverter() {
    }

    @Override
    public <T> T asObject(String string, Class<T> valueType) throws IllegalArgumentException {
        int dashIndex = string.indexOf(45);
        if (dashIndex == -1) {
            throw new IllegalArgumentException(String.format("Cannot convert |%s| to locale instance.", string));
        }
        return (T)new Locale(string.substring(0, dashIndex), string.substring(dashIndex + 1));
    }

    @Override
    public String asString(Object object) {
        Locale locale = (Locale)object;
        StringBuilder builder = new StringBuilder(5);
        builder.append(locale.getLanguage());
        builder.append('-');
        builder.append(locale.getCountry());
        return builder.toString();
    }
}

