/*
 * Decompiled with CFR 0.152.
 */
package js.converter;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import js.converter.Converter;
import js.lang.BugError;
import js.util.Types;

final class NumbersConverter
implements Converter {
    NumbersConverter() {
    }

    @Override
    public <T> T asObject(String string, Class<T> valueType) throws BugError {
        Number number;
        if ("null".equals(string)) {
            return null;
        }
        Number number2 = number = string.isEmpty() ? (Number)0 : (Number)this.parseNumber(string);
        if (Types.equalsAny(valueType, new Type[]{Integer.TYPE, Integer.class})) {
            return (T)Integer.valueOf(number.intValue());
        }
        if (Types.equalsAny(valueType, new Type[]{Double.TYPE, Double.class})) {
            return (T)Double.valueOf(number.doubleValue());
        }
        if (Types.equalsAny(valueType, new Type[]{Byte.TYPE, Byte.class})) {
            return (T)Byte.valueOf(number.byteValue());
        }
        if (Types.equalsAny(valueType, new Type[]{Short.TYPE, Short.class})) {
            return (T)Short.valueOf(number.shortValue());
        }
        if (Types.equalsAny(valueType, new Type[]{Long.TYPE, Long.class})) {
            if (string.length() > 0 && string.indexOf(46) == -1) {
                if (string.length() > 1 && string.charAt(0) == '0' && string.charAt(1) == 'x') {
                    return (T)Long.valueOf(Long.parseLong(string.substring(2), 16));
                }
                return (T)Long.valueOf(Long.parseLong(string));
            }
            return (T)Long.valueOf(number.longValue());
        }
        if (Types.equalsAny(valueType, new Type[]{Float.TYPE, Float.class})) {
            return (T)Float.valueOf(number.floatValue());
        }
        if (Types.equalsAny(valueType, new Type[]{BigDecimal.class})) {
            return (T)new BigDecimal(number.doubleValue());
        }
        throw new BugError("Unsupported numeric value |%s|.", valueType);
    }

    private Number parseNumber(String string) {
        if (string.length() > 2 && string.charAt(0) == '0' && string.charAt(1) == 'x') {
            return Long.parseLong(string.substring(2), 16);
        }
        return Double.parseDouble(string);
    }

    @Override
    public String asString(Object object) {
        return object.toString();
    }
}

