/*
 * Decompiled with CFR 0.152.
 */
package js.format;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import js.format.Format;

public final class BitRate
implements Format {
    private NumberFormat numberFormat;

    public BitRate() {
        this(Locale.getDefault());
    }

    public BitRate(Locale locale) {
        this.numberFormat = NumberFormat.getNumberInstance(locale);
        this.numberFormat.setGroupingUsed(true);
        this.numberFormat.setMinimumFractionDigits(2);
        this.numberFormat.setMaximumFractionDigits(2);
    }

    @Override
    public String format(Object value) {
        if (value == null) {
            return "";
        }
        double bitRate = 0.0;
        if (value instanceof Integer) {
            bitRate = ((Integer)value).intValue();
        } else if (value instanceof Long) {
            bitRate = ((Long)value).longValue();
        } else {
            throw new IllegalArgumentException(String.format("Invalid argument type |%s|.", value.getClass()));
        }
        if (bitRate == 0.0) {
            return this.format(0.0, Units.BPS);
        }
        Units units = Units.BPS;
        for (Units u : Units.values()) {
            if (bitRate < (double)u.value) break;
            units = u;
        }
        return this.format(bitRate / (double)units.value, units);
    }

    @Override
    public Object parse(String value) throws ParseException {
        if (value == null || value.isEmpty()) {
            return null;
        }
        String[] parts = value.split("\\s+");
        if (parts.length != 2) {
            throw new ParseException("Invalid bit rate value. Missing units.", 0);
        }
        Units units = Units.forName(parts[1]);
        if (units == null) {
            throw new ParseException(String.format("Invalid bit rate value. Not recognized units |%s|.", parts[1]), 0);
        }
        Number bitRate = this.numberFormat.parse(parts[0]);
        return Math.round(bitRate.doubleValue() * (double)units.value);
    }

    private String format(double bitRate, Units units) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.numberFormat.format(bitRate));
        builder.append(' ');
        builder.append(units.display());
        return builder.toString();
    }

    private static enum Units {
        BPS(1L),
        KBPS(1000L),
        MBPS(1000000L),
        GBPS(1000000000L),
        TBPS(1000000000000L);

        long value;
        private static Map<Units, String> DISPLAY;
        private static Map<String, Units> UNITS;

        private Units(long value) {
            this.value = value;
        }

        public String display() {
            return DISPLAY.get((Object)this);
        }

        public static Units forName(String name) {
            return UNITS.get(name.toUpperCase());
        }

        static {
            DISPLAY = new HashMap<Units, String>();
            DISPLAY.put(BPS, "bit/s");
            DISPLAY.put(KBPS, "Kbit/s");
            DISPLAY.put(MBPS, "Mbit/s");
            DISPLAY.put(GBPS, "Gbit/s");
            DISPLAY.put(TBPS, "Tbit/s");
            UNITS = new HashMap<String, Units>();
            UNITS.put(DISPLAY.get((Object)BPS), BPS);
            UNITS.put(DISPLAY.get((Object)KBPS), KBPS);
            UNITS.put(DISPLAY.get((Object)MBPS), MBPS);
            UNITS.put(DISPLAY.get((Object)GBPS), GBPS);
            UNITS.put(DISPLAY.get((Object)TBPS), TBPS);
        }
    }
}

