/*
 * Decompiled with CFR 0.152.
 */
package js.format;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import js.format.Format;

public final class Currency
implements Format {
    private NumberFormat numberFormat;

    public Currency() {
        this(Locale.getDefault());
    }

    public Currency(Locale locale) {
        this.numberFormat = NumberFormat.getCurrencyInstance(locale);
        this.numberFormat.setGroupingUsed(true);
        this.numberFormat.setMinimumFractionDigits(2);
        this.numberFormat.setMaximumFractionDigits(2);
    }

    @Override
    public String format(Object value) {
        if (value == null) {
            return "";
        }
        return this.numberFormat.format(value);
    }

    @Override
    public Object parse(String value) throws ParseException {
        if (value == null || value.isEmpty()) {
            return null;
        }
        return this.numberFormat.parse(value);
    }
}

