/*
 * Decompiled with CFR 0.152.
 */
package js.format;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import js.format.Format;

public final class Duration
implements Format {
    private NumberFormat numberFormat;

    public Duration() {
        this(Locale.getDefault());
    }

    public Duration(Locale locale) {
        this.numberFormat = NumberFormat.getNumberInstance(locale);
        this.numberFormat.setGroupingUsed(true);
        this.numberFormat.setMinimumFractionDigits(2);
        this.numberFormat.setMaximumFractionDigits(2);
    }

    @Override
    public String format(Object value) {
        if (value == null) {
            return "";
        }
        double duration = 0.0;
        if (value instanceof Integer) {
            duration = ((Integer)value).intValue();
        } else if (value instanceof Long) {
            duration = ((Long)value).longValue();
        } else {
            throw new IllegalArgumentException(String.format("Invalid argument type |%s|.", value.getClass()));
        }
        if (duration == 0.0) {
            return this.format(0.0, Units.MILLISECONDS);
        }
        Units units = Units.MILLISECONDS;
        for (Units u : Units.values()) {
            if (duration < (double)u.value) break;
            units = u;
        }
        return this.format(duration / (double)units.value, units);
    }

    @Override
    public Object parse(String value) throws ParseException {
        if (value == null || value.isEmpty()) {
            return null;
        }
        String[] parts = value.split("\\s+");
        if (parts.length != 2) {
            throw new ParseException("Invalid bit rate value. Missing units.", 0);
        }
        Units units = Units.forName(parts[1]);
        if (units == null) {
            throw new ParseException(String.format("Invalid bit rate value. Not recognized units |%s|.", parts[1]), 0);
        }
        Number duration = this.numberFormat.parse(parts[0]);
        return Math.round(duration.doubleValue() * (double)units.value);
    }

    private String format(double duration, Units units) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.numberFormat.format(duration));
        builder.append(' ');
        builder.append(units.display());
        return builder.toString();
    }

    private static enum Units {
        MILLISECONDS(1L),
        SECONDS(1000L),
        MINUTES(60000L),
        HOURS(3600000L),
        DAYS(86400000L),
        MONTHS(2592000L),
        YEARS(946080000000L);

        long value;
        private static Map<Units, String> DISPLAY;
        private static Map<String, Units> UNITS;

        private Units(long value) {
            this.value = value;
        }

        public String display() {
            return DISPLAY.get((Object)this);
        }

        public static Units forName(String name) {
            return UNITS.get(name.toUpperCase());
        }

        static {
            DISPLAY = new HashMap<Units, String>();
            DISPLAY.put(MILLISECONDS, "msec.");
            DISPLAY.put(SECONDS, "sec.");
            DISPLAY.put(MINUTES, "min.");
            DISPLAY.put(HOURS, "hr.");
            DISPLAY.put(DAYS, "days");
            DISPLAY.put(MONTHS, "months");
            DISPLAY.put(YEARS, "years");
            UNITS = new HashMap<String, Units>();
            UNITS.put(DISPLAY.get((Object)MILLISECONDS), MILLISECONDS);
            UNITS.put(DISPLAY.get((Object)SECONDS), SECONDS);
            UNITS.put(DISPLAY.get((Object)MINUTES), MINUTES);
            UNITS.put(DISPLAY.get((Object)HOURS), HOURS);
            UNITS.put(DISPLAY.get((Object)DAYS), DAYS);
            UNITS.put(DISPLAY.get((Object)MONTHS), MONTHS);
            UNITS.put(DISPLAY.get((Object)YEARS), YEARS);
        }
    }
}

