/*
 * Decompiled with CFR 0.152.
 */
package js.format;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import js.format.Format;

public final class FileSize
implements Format {
    private NumberFormat numberFormat;

    public FileSize() {
        this(Locale.getDefault());
    }

    public FileSize(Locale locale) {
        this.numberFormat = NumberFormat.getNumberInstance(locale);
        this.numberFormat.setGroupingUsed(true);
        this.numberFormat.setMinimumFractionDigits(2);
        this.numberFormat.setMaximumFractionDigits(2);
    }

    @Override
    public String format(Object value) {
        if (value == null) {
            return "";
        }
        double fileSize = 0.0;
        if (value instanceof Integer) {
            fileSize = ((Integer)value).intValue();
        } else if (value instanceof Long) {
            fileSize = ((Long)value).longValue();
        } else {
            throw new IllegalArgumentException(String.format("Invalid argument type |%s|.", value.getClass()));
        }
        if (fileSize == 0.0) {
            return this.format(0.0, Units.B);
        }
        Units units = Units.B;
        for (Units u : Units.values()) {
            if (fileSize < (double)u.value) break;
            units = u;
        }
        return this.format(fileSize / (double)units.value, units);
    }

    @Override
    public Object parse(String value) throws ParseException {
        if (value == null || value.isEmpty()) {
            return null;
        }
        String[] parts = value.split("\\s+");
        if (parts.length != 2) {
            throw new ParseException("Invalid file size value. Missing units.", 0);
        }
        Units units = Units.forName(parts[1]);
        if (units == null) {
            throw new ParseException(String.format("Invalid file size value. Not recognized units |%s|.", parts[1]), 0);
        }
        Number fileSize = this.numberFormat.parse(parts[0]);
        return Math.round(fileSize.doubleValue() * (double)units.value);
    }

    private String format(double fileSize, Units units) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.numberFormat.format(fileSize));
        builder.append(' ');
        builder.append(units.name());
        return builder.toString();
    }

    private static enum Units {
        B(1L),
        KB(1024L),
        MB(0x100000L),
        GB(0x40000000L),
        TB(0x10000000000L);

        long value;
        private static Map<String, Units> UNITS;

        private Units(long value) {
            this.value = value;
        }

        public static Units forName(String name) {
            return UNITS.get(name.toUpperCase());
        }

        static {
            UNITS = new HashMap<String, Units>();
            UNITS.put("B", B);
            UNITS.put("KB", KB);
            UNITS.put("MB", MB);
            UNITS.put("GB", GB);
            UNITS.put("TB", TB);
        }
    }
}

