/*
 * Decompiled with CFR 0.152.
 */
package js.io;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import js.converter.ConverterRegistry;
import js.io.InvalidFilesArchiveException;
import js.util.Files;

public class FilesInputStream
extends InputStream
implements Iterable<File>,
Closeable {
    private static final String VERSION = "1.0";
    private static final boolean UNIX_PATH = File.separatorChar == '/';
    private static final int BUFFER_SIZE = 4096;
    private ZipInputStream filesArchive;
    private Manifest manifest;
    private FilesIterator filesIterator;

    public FilesInputStream(InputStream filesArchive) throws IOException {
        this(filesArchive instanceof ZipInputStream ? (ZipInputStream)filesArchive : new ZipInputStream(filesArchive));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilesInputStream(ZipInputStream filesArchive) throws IOException {
        this.filesArchive = filesArchive;
        ZipEntry entry = this.filesArchive.getNextEntry();
        if (entry == null) {
            throw new InvalidFilesArchiveException("Missing manifest.", new Object[0]);
        }
        try {
            this.manifest = new Manifest(this.filesArchive);
            Attributes attributes = this.manifest.getMainAttributes();
            String version = attributes.getValue(Attributes.Name.MANIFEST_VERSION);
            if (!VERSION.equals(version)) {
                throw new InvalidFilesArchiveException("Bad manifest version |%s|.", version);
            }
        }
        finally {
            this.filesArchive.closeEntry();
        }
        this.filesIterator = new FilesIterator();
    }

    @Override
    public int read() throws IOException {
        return this.filesArchive.read();
    }

    @Override
    public Iterator<File> iterator() {
        return this.filesIterator;
    }

    @Override
    public void close() throws IOException {
        this.filesArchive.close();
    }

    public String getMeta(String key) {
        String value = this.manifest.getMainAttributes().getValue(key);
        if (value == null) {
            throw new InvalidFilesArchiveException("Missing |%s| attribute from manifest.", key);
        }
        return value;
    }

    public String getMeta(String key, String defaultValue) {
        String value = this.manifest.getMainAttributes().getValue(key);
        return value == null ? defaultValue : value;
    }

    public <T> T getMeta(String key, Class<T> type) {
        return ConverterRegistry.getConverter().asObject(this.getMeta(key), type);
    }

    public <T> T getMeta(String key, Class<T> type, T defaultValue) {
        String value = this.manifest.getMainAttributes().getValue(key);
        return value == null ? defaultValue : ConverterRegistry.getConverter().asObject(value, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(File targetFile) throws IOException {
        Files.mkdirs(targetFile);
        BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(targetFile));
        try {
            int bytesRead;
            byte[] buffer = new byte[4096];
            while ((bytesRead = this.filesArchive.read(buffer)) > 0) {
                ((OutputStream)outputStream).write(buffer, 0, bytesRead);
            }
        }
        finally {
            Files.close(outputStream);
        }
    }

    private class FilesIterator
    implements Iterator<File> {
        private File file;

        private FilesIterator() {
        }

        @Override
        public boolean hasNext() {
            this.file = null;
            try {
                ZipEntry entry = FilesInputStream.this.filesArchive.getNextEntry();
                if (entry == null) {
                    return false;
                }
                String path = entry.getName();
                if (UNIX_PATH) {
                    path = Files.path2unix(path);
                }
                this.file = new File(path);
                if (this.file.isDirectory()) {
                    throw new InvalidFilesArchiveException("Target file |%s| is a directory.", this.file.getAbsolutePath());
                }
                return true;
            }
            catch (IOException e) {
                throw new InvalidFilesArchiveException("Cannot read next entry: " + e.getMessage(), new Object[0]);
            }
        }

        @Override
        public File next() {
            return this.file;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

