/*
 * Decompiled with CFR 0.152.
 */
package js.io;

import java.io.File;
import java.util.Iterator;
import java.util.Stack;
import js.lang.BugError;
import js.util.Strings;

public class FilesIterator<T>
implements Iterator<T>,
Iterable<T> {
    private Stack<Directory> stack;
    private Directory workingDirectory;
    private int processedFilesCount;
    private Stack<String> pathComponents;
    private Handler handler;
    private boolean relativePath;

    public static FilesIterator<File> getAbsoluteIterator(File baseDir) {
        return new FilesIterator<File>(baseDir, Strategy.FILES);
    }

    public static FilesIterator<File> getRelativeIterator(File baseDir) {
        return new FilesIterator<File>(baseDir, Strategy.RELATIVE_FILES);
    }

    public static FilesIterator<String> getAbsoluteNamesIterator(File baseDir) {
        return new FilesIterator<String>(baseDir, Strategy.NAMES);
    }

    public static FilesIterator<String> getRelativeNamesIterator(File baseDir) {
        return new FilesIterator<String>(baseDir, Strategy.RELATIVE_NAMES);
    }

    public static FilesIterator<File> getAbsoluteIterator(String baseDir) {
        return new FilesIterator<File>(new File(baseDir), Strategy.FILES);
    }

    public static FilesIterator<File> getRelativeIterator(String baseDir) {
        return new FilesIterator<File>(new File(baseDir), Strategy.RELATIVE_FILES);
    }

    public static FilesIterator<String> getAbsoluteNamesIterator(String baseDir) {
        return new FilesIterator<String>(new File(baseDir), Strategy.NAMES);
    }

    public static FilesIterator<String> getRelativeNamesIterator(String baseDir) {
        return new FilesIterator<String>(new File(baseDir), Strategy.RELATIVE_NAMES);
    }

    private FilesIterator(File baseDir, Strategy strategy) {
        if (!baseDir.exists()) {
            throw new IllegalArgumentException(String.format("File iterator base directory |%s| is missing.", baseDir));
        }
        if (!baseDir.isDirectory()) {
            throw new IllegalArgumentException(String.format("File iterator cannot iterate |%s| over an ordinary file.", baseDir));
        }
        switch (strategy) {
            case FILES: {
                this.handler = new FilesHandler();
                break;
            }
            case RELATIVE_FILES: {
                this.handler = new RelativeFilesHandler();
                this.relativePath = true;
                break;
            }
            case NAMES: {
                this.handler = new NamesHandler();
                break;
            }
            case RELATIVE_NAMES: {
                this.handler = new RelativeNamesHandler();
                this.relativePath = true;
                break;
            }
            default: {
                throw new BugError("Unsupported files iterator handler type |%s|.", new Object[]{strategy});
            }
        }
        this.stack = new Stack();
        this.workingDirectory = new Directory(baseDir);
        if (this.relativePath) {
            this.pathComponents = new Stack();
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        if (this.isLoopExitCondition()) {
            return false;
        }
        while (true) {
            if (this.workingDirectory.files.length == 0) {
                this.pop();
            }
            if (this.isLoopExitCondition()) {
                return false;
            }
            this.workingDirectory.currentFile = this.workingDirectory.files[this.workingDirectory.index++];
            if (!this.workingDirectory.currentFile.isDirectory()) break;
            this.push(this.workingDirectory.currentFile);
        }
        return true;
    }

    private boolean isLoopExitCondition() {
        while (this.workingDirectory.index == this.workingDirectory.files.length) {
            if (this.stack.isEmpty()) {
                return true;
            }
            this.pop();
        }
        return false;
    }

    @Override
    public T next() {
        ++this.processedFilesCount;
        return (T)this.handler.next();
    }

    public int getProcessedFilesCount() {
        return this.processedFilesCount;
    }

    private void push(File directory) {
        this.stack.push(this.workingDirectory);
        this.workingDirectory = new Directory(directory);
        if (this.relativePath) {
            this.pathComponents.push(directory.getName());
        }
    }

    private void pop() {
        this.workingDirectory = this.stack.pop();
        if (this.relativePath) {
            this.pathComponents.pop();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private class RelativeNamesHandler
    extends RelativeFilesHandler {
        private RelativeNamesHandler() {
        }

        @Override
        public Object next() {
            return ((File)super.next()).getPath();
        }
    }

    private class NamesHandler
    extends FilesHandler {
        private NamesHandler() {
        }

        @Override
        public Object next() {
            return ((File)super.next()).getPath();
        }
    }

    private class RelativeFilesHandler
    implements Handler {
        private RelativeFilesHandler() {
        }

        @Override
        public Object next() {
            FilesIterator.this.pathComponents.push(((FilesIterator)FilesIterator.this).workingDirectory.currentFile.getName());
            File file = new File(Strings.join(FilesIterator.this.pathComponents, File.separatorChar));
            FilesIterator.this.pathComponents.pop();
            return file;
        }
    }

    private class FilesHandler
    implements Handler {
        private FilesHandler() {
        }

        @Override
        public Object next() {
            return ((FilesIterator)FilesIterator.this).workingDirectory.currentFile;
        }
    }

    private static interface Handler {
        public Object next();
    }

    private static enum Strategy {
        NONE,
        FILES,
        RELATIVE_FILES,
        NAMES,
        RELATIVE_NAMES;

    }

    private class Directory {
        File[] files;
        int index;
        File currentFile;

        Directory(File directory) {
            this.files = directory.listFiles();
        }
    }
}

