/*
 * Decompiled with CFR 0.152.
 */
package js.io;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import js.converter.ConverterRegistry;
import js.io.FilesIterator;
import js.util.Files;

public class FilesOutputStream
extends OutputStream
implements Closeable {
    private static final String VERSION = "1.0";
    private static final int BUFFER_SIZE = 4096;
    private ZipOutputStream filesArchive;
    private Manifest manifest;

    public FilesOutputStream(OutputStream filesArchive) {
        this.filesArchive = new ZipOutputStream(filesArchive);
        this.manifest = new Manifest();
        Attributes attributes = this.manifest.getMainAttributes();
        attributes.putValue(Attributes.Name.MANIFEST_VERSION.toString(), VERSION);
    }

    @Override
    public void write(int b) throws IOException {
        this.filesArchive.write(b);
    }

    public void putMeta(String key, Object value) {
        this.manifest.getMainAttributes().putValue(key, ConverterRegistry.getConverter().asString(value));
    }

    public void addFiles(File baseDir) throws IOException {
        for (String file : FilesIterator.getRelativeNamesIterator(baseDir)) {
            this.addFileEntry(file, new FileInputStream(new File(baseDir, file)));
        }
    }

    public void addFiles(File baseDir, List<String> fileNames) throws FileNotFoundException, IOException {
        for (String fileName : fileNames) {
            this.addFileEntry(fileName, new FileInputStream(new File(baseDir, fileName)));
        }
    }

    public void addFile(File file) throws IOException {
        if (!file.exists()) {
            throw new IllegalArgumentException(String.format("File |%s| does not exist.", file));
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException(String.format("File |%s| is a directory.", file));
        }
        this.addFileEntry(file.getPath(), new FileInputStream(file));
    }

    @Override
    public void close() throws IOException {
        if (this.manifest != null) {
            this.addManifestEntry();
        }
        super.close();
    }

    private void addManifestEntry() throws IOException {
        ZipEntry entry = new ZipEntry("META-INF/MANIFEST.MF");
        this.filesArchive.putNextEntry(entry);
        try {
            this.manifest.write(this);
        }
        finally {
            this.filesArchive.closeEntry();
            this.manifest = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFileEntry(String entryName, InputStream inputStream) throws IOException {
        if (this.manifest != null) {
            this.addManifestEntry();
        }
        ZipEntry entry = new ZipEntry(entryName);
        this.filesArchive.putNextEntry(entry);
        inputStream = new BufferedInputStream(inputStream);
        try {
            int bytesRead;
            byte[] buffer = new byte[4096];
            while ((bytesRead = inputStream.read(buffer)) > 0) {
                this.write(buffer, 0, bytesRead);
            }
        }
        finally {
            Files.close(inputStream);
            this.filesArchive.closeEntry();
        }
    }
}

