/*
 * Decompiled with CFR 0.152.
 */
package js.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import js.util.Params;
import js.util.Strings;

public class ReaderInputStream
extends InputStream {
    private static final int CHARACTERS_BUFFER_SIZE = 1024;
    private static final int BYTES_BUFFER_SIZE = 128;
    private static final int EOF = -1;
    private final CharsetEncoder encoder;
    private final CharBuffer charactersBuffer;
    private final ByteBuffer bytesBuffer;
    private final Reader reader;
    private CoderResult lastEncoderResult;
    private boolean endOfInput;

    public ReaderInputStream(Reader reader) {
        this.reader = reader;
        this.encoder = Charset.forName("UTF-8").newEncoder();
        this.encoder.onMalformedInput(CodingErrorAction.REPLACE);
        this.encoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.charactersBuffer = CharBuffer.allocate(1024);
        this.charactersBuffer.flip();
        this.bytesBuffer = ByteBuffer.allocate(128);
        this.bytesBuffer.flip();
    }

    @Override
    public int read(byte[] bytes, int off, int len) throws IOException {
        Params.notNull(bytes, "Bytes", new Object[0]);
        if (len < 0 || off < 0 || off + len > bytes.length) {
            throw new IndexOutOfBoundsException(Strings.concat("Array Size=", bytes.length, ", offset=", off, ", length=", len));
        }
        if (len == 0) {
            return 0;
        }
        int bytesRead = 0;
        while (len > 0) {
            if (this.bytesBuffer.hasRemaining()) {
                int count = Math.min(this.bytesBuffer.remaining(), len);
                this.bytesBuffer.get(bytes, off, count);
                off += count;
                len -= count;
                bytesRead += count;
                continue;
            }
            this.fillBytesBuffer();
            if (!this.endOfInput || this.bytesBuffer.hasRemaining()) continue;
        }
        return bytesRead == 0 && this.endOfInput ? -1 : bytesRead;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read() throws IOException {
        do {
            if (this.bytesBuffer.hasRemaining()) {
                return this.bytesBuffer.get() & 0xFF;
            }
            this.fillBytesBuffer();
        } while (!this.endOfInput || this.bytesBuffer.hasRemaining());
        return -1;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    private void fillBytesBuffer() throws IOException {
        if (!this.endOfInput && (this.lastEncoderResult == null || this.lastEncoderResult.isUnderflow())) {
            this.charactersBuffer.compact();
            int position = this.charactersBuffer.position();
            int readCount = this.reader.read(this.charactersBuffer.array(), position, this.charactersBuffer.remaining());
            if (readCount == -1) {
                this.endOfInput = true;
            } else {
                this.charactersBuffer.position(position + readCount);
            }
            this.charactersBuffer.flip();
        }
        this.bytesBuffer.compact();
        this.lastEncoderResult = this.encoder.encode(this.charactersBuffer, this.bytesBuffer, this.endOfInput);
        this.bytesBuffer.flip();
    }
}

