/*
 * Decompiled with CFR 0.152.
 */
package js.io;

import java.io.IOException;
import java.io.OutputStream;
import js.util.Classes;

public abstract class StreamHandler<T extends OutputStream> {
    private Class<T> streamClass;

    protected abstract void handle(T var1) throws IOException;

    public StreamHandler(Class<T> streamClass) {
        this.streamClass = streamClass;
    }

    public Class<T> getStreamClass() {
        return this.streamClass;
    }

    public void invokeHandler(OutputStream outputStream) throws IOException {
        OutputStream t = OutputStream.class.equals(this.streamClass) ? outputStream : (OutputStream)Classes.newInstance(this.streamClass, outputStream);
        this.handle(t);
        t.flush();
        t.close();
    }
}

