/*
 * Decompiled with CFR 0.152.
 */
package js.io;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class VariablesWriter
extends Writer {
    private Writer targetWriter;
    private Map<String, String> variables;
    private StringBuilder variableBuilder;
    private State state;

    public VariablesWriter(Map<String, String> variables) {
        this(new StringWriter(), variables);
    }

    public VariablesWriter(Writer targetWriter, Map<String, String> variables) {
        this.targetWriter = targetWriter;
        this.variables = variables;
        this.variableBuilder = new StringBuilder();
        this.state = State.TEXT;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        for (int count = 0; count < len; ++count) {
            char c = cbuf[off];
            switch (this.state) {
                case TEXT: {
                    if (c == '$') {
                        this.state = State.VARIABLE_MARK;
                        break;
                    }
                    this.targetWriter.write(c);
                    break;
                }
                case VARIABLE_MARK: {
                    if (c == '{') {
                        this.state = State.VARIABLE;
                        this.variableBuilder.setLength(0);
                        break;
                    }
                    this.targetWriter.write(36);
                    this.targetWriter.write(c);
                    this.state = State.TEXT;
                    break;
                }
                case VARIABLE: {
                    if (c == '}') {
                        String variable = this.variables.get(this.variableBuilder.toString());
                        if (variable == null) {
                            this.targetWriter.write("${");
                            this.targetWriter.write(this.variableBuilder.toString());
                            this.targetWriter.write(125);
                        } else {
                            this.targetWriter.write(variable);
                        }
                        this.state = State.TEXT;
                        break;
                    }
                    this.variableBuilder.append(c);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            ++off;
        }
    }

    @Override
    public void flush() throws IOException {
        this.targetWriter.flush();
    }

    @Override
    public void close() throws IOException {
        this.targetWriter.close();
    }

    public String toString() {
        return this.targetWriter.toString();
    }

    private static enum State {
        NONE,
        TEXT,
        VARIABLE_MARK,
        VARIABLE;

    }
}

