/*
 * Decompiled with CFR 0.152.
 */
package js.io;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Stack;
import js.util.Params;

public class WildcardFilter
implements FileFilter,
FilenameFilter,
Serializable {
    private static final long serialVersionUID = -780074911185887594L;
    public static final String ACCEPT_ALL = "*";
    private final String pattern;

    public WildcardFilter(String pattern) {
        Params.notNullOrEmpty(pattern, "Pattern");
        this.pattern = pattern;
    }

    @Override
    public boolean accept(File dir, String name) {
        return WildcardFilter.match(name, this.pattern);
    }

    @Override
    public boolean accept(File file) {
        return file != null ? WildcardFilter.match(file.getName(), this.pattern) : false;
    }

    public boolean accept(String string) {
        return WildcardFilter.match(string, this.pattern);
    }

    public String toString() {
        return this.pattern;
    }

    private static boolean match(String string, String pattern) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        String[] wcs = WildcardFilter.tokenize(pattern);
        boolean anyChars = false;
        int textIdx = 0;
        int wcsIdx = 0;
        Stack<int[]> backtrack = new Stack<int[]>();
        do {
            if (backtrack.size() > 0) {
                int[] array = (int[])backtrack.pop();
                wcsIdx = array[0];
                textIdx = array[1];
                anyChars = true;
            }
            while (wcsIdx < wcs.length) {
                if (wcs[wcsIdx].equals("?")) {
                    ++textIdx;
                    anyChars = false;
                } else if (wcs[wcsIdx].equals(ACCEPT_ALL)) {
                    anyChars = true;
                    if (wcsIdx == wcs.length - 1) {
                        textIdx = string.length();
                    }
                } else {
                    if (anyChars) {
                        if ((textIdx = string.indexOf(wcs[wcsIdx], textIdx)) == -1) break;
                        int repeat = string.indexOf(wcs[wcsIdx], textIdx + 1);
                        if (repeat >= 0) {
                            backtrack.push(new int[]{wcsIdx, repeat});
                        }
                    } else if (!string.startsWith(wcs[wcsIdx], textIdx)) break;
                    textIdx += wcs[wcsIdx].length();
                    anyChars = false;
                }
                ++wcsIdx;
            }
            if (wcsIdx != wcs.length || textIdx != string.length()) continue;
            return true;
        } while (backtrack.size() > 0);
        return false;
    }

    private static String[] tokenize(String string) {
        if (string.indexOf("?") == -1 && string.indexOf(ACCEPT_ALL) == -1) {
            return new String[]{string};
        }
        char[] textArray = string.toCharArray();
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuilder tokenBuilder = new StringBuilder();
        for (int i = 0; i < textArray.length; ++i) {
            if (textArray[i] != '?' && textArray[i] != '*') {
                tokenBuilder.append(textArray[i]);
                continue;
            }
            if (tokenBuilder.length() != 0) {
                tokens.add(tokenBuilder.toString());
                tokenBuilder.setLength(0);
            }
            if (textArray[i] == '?') {
                tokens.add("?");
                continue;
            }
            if (tokens.size() != 0 && (i <= 0 || ((String)tokens.get(tokens.size() - 1)).equals(ACCEPT_ALL))) continue;
            tokens.add(ACCEPT_ALL);
        }
        if (tokenBuilder.length() != 0) {
            tokens.add(tokenBuilder.toString());
        }
        return tokens.toArray(new String[tokens.size()]);
    }
}

