/*
 * Decompiled with CFR 0.152.
 */
package js.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public class WriterOutputStream
extends OutputStream {
    private static final int BYTES_BUFFER_SIZE = 128;
    private static final int CHARACTERS_BUFFER_SIZE = 1024;
    private final CharsetDecoder decoder;
    private final ByteBuffer bytesBuffer;
    private final CharBuffer charactersBuffer;
    private final Writer writer;

    public WriterOutputStream(Writer writer) {
        this.writer = writer;
        this.decoder = Charset.forName("UTF-8").newDecoder();
        this.decoder.onMalformedInput(CodingErrorAction.REPLACE);
        this.decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.decoder.replaceWith("?");
        this.bytesBuffer = ByteBuffer.allocate(128);
        this.charactersBuffer = CharBuffer.allocate(1024);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            int c = Math.min(len, this.bytesBuffer.remaining());
            this.bytesBuffer.put(b, off, c);
            this.processBytesBuffer(false);
            len -= c;
            off += c;
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(int b) throws IOException {
        if (!this.bytesBuffer.hasRemaining()) {
            this.processBytesBuffer(false);
        }
        this.bytesBuffer.put((byte)b);
    }

    @Override
    public void flush() throws IOException {
        this.processBytesBuffer(false);
        this.flushCharactersBuffer();
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.processBytesBuffer(true);
        this.flushCharactersBuffer();
        this.writer.close();
    }

    private void processBytesBuffer(boolean endOfInput) throws IOException {
        CoderResult coderResult;
        this.bytesBuffer.flip();
        while ((coderResult = this.decoder.decode(this.bytesBuffer, this.charactersBuffer, endOfInput)).isOverflow()) {
            this.flushCharactersBuffer();
        }
        if (!coderResult.isUnderflow()) {
            throw new IOException("Unexpected coder result.");
        }
        this.bytesBuffer.compact();
    }

    private void flushCharactersBuffer() throws IOException {
        if (this.charactersBuffer.position() > 0) {
            this.writer.write(this.charactersBuffer.array(), 0, this.charactersBuffer.position());
            this.charactersBuffer.rewind();
        }
    }
}

