/*
 * Decompiled with CFR 0.152.
 */
package js.lang;

import js.lang.Callback;

public abstract class AsyncTask<Value> {
    protected Callback<Value> callback;

    protected abstract Value execute() throws Throwable;

    protected AsyncTask() {
    }

    protected AsyncTask(Callback<Value> callback) {
        this.callback = callback;
    }

    public void start() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    AsyncTask.this.onPreExecute();
                    Object value = AsyncTask.this.execute();
                    AsyncTask.this.onPostExecute(value);
                }
                catch (Throwable throwable) {
                    AsyncTask.this.onThrowable(throwable);
                }
            }
        });
        thread.start();
    }

    protected void onPreExecute() {
    }

    protected void onPostExecute(Value value) {
        if (this.callback != null) {
            this.callback.handle(value);
        }
    }

    protected void onThrowable(Throwable throwable) {
    }
}

