/*
 * Decompiled with CFR 0.152.
 */
package js.lang;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import js.converter.Converter;
import js.converter.ConverterRegistry;
import js.util.Params;

public class Config {
    private final String name;
    private String value;
    private Config parent;
    private final List<Config> children = new ArrayList<Config>();
    private final Map<String, String> attributes = new HashMap<String, String>();
    private Properties properties = new Properties();
    private Set<String> usedProperties = Collections.synchronizedSet(new HashSet());
    private final Converter converter = ConverterRegistry.getConverter();

    public Config(String name) {
        Params.notNullOrEmpty(name, "Root name");
        this.name = name;
    }

    public void addChild(Config child) {
        Params.notNull(child, "Child", new Object[0]);
        child.parent = this;
        this.children.add(child);
    }

    public void addChildren(List<Config> children) {
        Params.notNull(children, "Children", new Object[0]);
        for (Config child : children) {
            this.addChild(child);
        }
    }

    public void setAttribute(String name, String value) {
        Params.notNullOrEmpty(name, "Attribute name");
        Params.notEmpty(value, "Attribute value");
        if (value != null) {
            this.attributes.put(name, value);
        } else {
            this.attributes.remove(name);
        }
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setProperty(String name, String value) {
        Params.notNullOrEmpty(name, "Property name");
        Params.notEmpty(value, "Property value");
        if (value != null) {
            this.properties.setProperty(name, value);
        }
    }

    public void setProperty(String name, Object value) {
        Params.notNullOrEmpty(name, "Property name");
        if (value != null) {
            this.properties.setProperty(name, this.converter.asString(value));
        }
    }

    public void setValue(Object value) {
        if (value instanceof String) {
            Params.notEmpty((String)value, "Value");
            this.value = (String)value;
        } else {
            this.value = value != null ? this.converter.asString(value) : null;
        }
    }

    public Config getRoot() {
        Config root = this;
        while (root.parent != null) {
            root = root.parent;
        }
        return root;
    }

    public Config getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasAttribute(String name) {
        Params.notNullOrEmpty(name, "Attribute name");
        return this.attributes.containsKey(name);
    }

    public boolean hasAttribute(String name, String value) {
        Params.notNullOrEmpty(name, "Attribute name");
        Params.notNullOrEmpty(value, "Attribute value");
        return value.equals(this.attributes.get(name));
    }

    public String getAttribute(String name) {
        Params.notNullOrEmpty(name, "Attribute name");
        return this.attributes.get(name);
    }

    public String getAttribute(String name, String defaultValue) {
        Params.notNullOrEmpty(name, "Attribute name");
        return this.getAttribute(name, String.class, defaultValue);
    }

    public <T> T getAttribute(String name, Class<T> type) {
        Params.notNullOrEmpty(name, "Attribute name");
        Params.notNull(type, "Attribute type", new Object[0]);
        return this.getAttribute(name, type, null);
    }

    public <T> T getAttribute(String name, Class<T> type, T defaultValue) {
        Params.notNullOrEmpty(name, "Attribute name");
        Params.notNull(type, "Attribute type", new Object[0]);
        String value = this.attributes.get(name);
        return value != null ? this.converter.asObject(value, type) : defaultValue;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Properties getUnusedProperties() {
        Properties p = new Properties();
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            if (this.usedProperties.contains(entry.getKey())) continue;
            p.put(entry.getKey(), entry.getValue());
        }
        return p;
    }

    public boolean hasProperty(String name) {
        Params.notNullOrEmpty(name, "Property name");
        return this.properties.containsKey(name);
    }

    public String getProperty(String name) {
        Params.notNullOrEmpty(name, "Property name");
        this.usedProperties.add(name);
        return this.properties.getProperty(name);
    }

    public String getProperty(String name, String defaultValue) {
        String value = this.getProperty(name);
        return value != null ? value : defaultValue;
    }

    public <T> T getProperty(String name, Class<T> type) {
        return this.getProperty(name, type, null);
    }

    public <T> T getProperty(String name, Class<T> type, T defaultValue) {
        Params.notNullOrEmpty(name, "Property name");
        Params.notNull(type, "Property type", new Object[0]);
        String value = this.getProperty(name);
        if (value != null) {
            return this.converter.asObject(value, type);
        }
        return defaultValue;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public int getChildrenCount() {
        return this.children.size();
    }

    public List<Config> getChildren() {
        return this.children;
    }

    public boolean hasChild(String name) {
        Params.notNullOrEmpty(name, "Child name");
        for (Config child : this.children) {
            if (!child.name.equals(name)) continue;
            return true;
        }
        return false;
    }

    public Config getChild(String name) {
        Params.notNullOrEmpty(name, "Child name");
        for (Config child : this.children) {
            if (!child.name.equals(name)) continue;
            return child;
        }
        return null;
    }

    public Config getChild(int index) {
        Params.range(index, 0.0, this.children.size(), "Index");
        return this.children.get(index);
    }

    public List<Config> findChildren(String ... name) {
        Params.notNullOrEmpty(name, "Children names");
        List<String> names = Arrays.asList(name);
        ArrayList<Config> results = new ArrayList<Config>();
        for (Config child : this.children) {
            if (!names.contains(child.name)) continue;
            results.add(child);
        }
        return results;
    }

    public String getValue() {
        return this.value;
    }

    public <T> T getValue(Class<T> type) {
        Params.notNull(type, "Value type", new Object[0]);
        if (this.value == null) {
            return null;
        }
        return this.converter.asObject(this.value, type);
    }

    public String getChildValue(String name) {
        Config child = this.getChild(name);
        return child != null ? child.getValue() : null;
    }

    public void dump() {
        this.print(this, 0);
    }

    private void print(Config config, int indent) {
        for (int i = 0; i < indent; ++i) {
            System.out.print("\t");
        }
        System.out.print(config.name);
        System.out.print("\r\n");
        for (Config child : config.children) {
            this.print(child, indent + 1);
        }
    }

    public String toString() {
        return this.name;
    }
}

