/*
 * Decompiled with CFR 0.152.
 */
package js.lang;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Properties;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import js.lang.Config;
import js.lang.ConfigException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigBuilder {
    private InputSource inputSource;
    private Properties properties;

    public ConfigBuilder(String xml) {
        this(new StringReader(xml));
    }

    public ConfigBuilder(File xmlFile) throws FileNotFoundException {
        this(new FileReader(xmlFile));
    }

    public ConfigBuilder(Reader reader) {
        this.inputSource = new InputSource(reader);
    }

    public ConfigBuilder(InputStream stream) {
        this.inputSource = new InputSource(stream);
    }

    public ConfigBuilder(Properties properties) {
        this.properties = properties;
    }

    protected ConfigBuilder() {
    }

    public Config build() throws ConfigException {
        if (this.properties != null) {
            Config config = new Config("properties");
            config.setProperties(this.properties);
            return config;
        }
        try {
            Loader loader = new Loader();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            reader.setContentHandler(loader);
            reader.parse(this.inputSource);
            return loader.getConfig();
        }
        catch (Exception e) {
            throw new ConfigException(e);
        }
    }

    private static class Loader
    extends DefaultHandler {
        private Stack<Config> stack = new Stack();
        private StringBuilder textBuilder = new StringBuilder();

        private Loader() {
        }

        public Config getConfig() {
            return (Config)this.stack.get(0);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.textBuilder.setLength(0);
            if (qName.equals("property")) {
                Config config = this.stack.peek();
                config.setProperty(Loader.value(attributes, "name"), Loader.value(attributes, "value"));
            } else {
                Config config = new Config(qName);
                if (!this.stack.isEmpty()) {
                    Config parent = this.stack.peek();
                    parent.addChild(config);
                }
                this.stack.push(config);
                for (int i = 0; i < attributes.getLength(); ++i) {
                    config.setAttribute(attributes.getQName(i), attributes.getValue(i));
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            Config config = this.stack.peek();
            if (this.textBuilder.length() > 0) {
                config.setValue(this.textBuilder.toString());
            }
            if (!qName.equals("property") && this.stack.size() > 1) {
                this.stack.pop();
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.textBuilder.append(ch, start, length);
        }

        private static String value(Attributes attributes, String attributeName) throws SAXException {
            String value = attributes.getValue(attributeName);
            if (value == null) {
                throw new SAXException(new ConfigException("Missing attribute <%s>.", attributeName));
            }
            return value;
        }
    }
}

