/*
 * Decompiled with CFR 0.152.
 */
package js.lang;

import java.util.concurrent.atomic.AtomicBoolean;
import js.lang.AsyncExceptionListener;
import js.lang.Looper;
import js.log.Log;
import js.log.LogFactory;
import js.util.Params;

public class LooperThread
implements Runnable {
    private static final Log log = LogFactory.getLog(LooperThread.class);
    private static final int STARTUP_TIMEOUT = 10000;
    private static final int STOP_TIMEOUT = 6000;
    private static final int EXCEPTION_TIMEOUT = 4000;
    private static final int SAMPLING_PERIOD = 1000;
    private final Thread thread;
    private final Looper looper;
    private final int loopPeriod;
    private final AtomicBoolean running = new AtomicBoolean();
    private final AtomicBoolean breakOnException = new AtomicBoolean();
    private volatile AsyncExceptionListener exceptionListener;
    private long exceptionTimestamp;

    public LooperThread(Looper looper) {
        this(looper, 0);
    }

    public LooperThread(Looper looper, int period) {
        Params.notNull(looper, "Looper reference", new Object[0]);
        Params.positive(period, "Loop period");
        this.looper = looper;
        this.loopPeriod = period;
        this.thread = new Thread((Runnable)this, looper.getClass().getName());
        this.thread.setDaemon(true);
        if (looper instanceof AsyncExceptionListener) {
            this.exceptionListener = (AsyncExceptionListener)((Object)looper);
        }
    }

    public void setBreakOnException(boolean breakOnException) {
        this.breakOnException.set(breakOnException);
    }

    public synchronized void setExceptionListener(AsyncExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public synchronized void start() {
        this.running.set(true);
        this.thread.start();
        LooperThread.wait(this, 10000);
    }

    public synchronized void stop() {
        this.running.set(false);
        if (this.thread.isAlive()) {
            this.thread.interrupt();
            LooperThread.wait(this, 6000);
        }
    }

    public boolean isRunning() {
        return this.running.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LooperThread looperThread = this;
        synchronized (looperThread) {
            this.notify();
        }
        log.trace("Looper thread |%s| started.", this.thread);
        long start = System.currentTimeMillis();
        long nextIterationTimestamp = 0L;
        long sleepingPeriod = 0L;
        while (this.running.get()) {
            block19: {
                if (this.loopPeriod > 0) {
                    nextIterationTimestamp = System.currentTimeMillis() + (long)this.loopPeriod;
                }
                try {
                    this.looper.loop();
                }
                catch (Throwable throwable) {
                    if (this.exceptionListener != null) {
                        LooperThread looperThread2 = this;
                        synchronized (looperThread2) {
                            if (this.exceptionListener != null) {
                                this.exceptionListener.onAsyncException(throwable);
                            }
                        }
                    } else {
                        if (throwable instanceof InterruptedException) {
                            log.debug("Loop execution interrupted. Break looper thread.");
                            break;
                        }
                        log.dump("Error on loop execution. Stack trace follows: ", throwable);
                    }
                    if (this.breakOnException.get()) break;
                    if (this.loopPeriod != 0) break block19;
                    if (System.currentTimeMillis() - this.exceptionTimestamp < 4000L) {
                        LooperThread.sleep(4000L);
                    }
                    this.exceptionTimestamp = System.currentTimeMillis();
                }
            }
            if (this.loopPeriod <= 0) continue;
            while (this.running.get() && (sleepingPeriod = nextIterationTimestamp - System.currentTimeMillis()) > 0L) {
                LooperThread.sleep(Math.min(sleepingPeriod, 1000L));
            }
        }
        log.trace("Looper thread |%s| stopped. Processing time %d msec.", this.thread, System.currentTimeMillis() - start);
        LooperThread looperThread3 = this;
        synchronized (looperThread3) {
            this.notify();
        }
    }

    public void join(long millis) throws InterruptedException {
        log.trace("join(long)");
        this.thread.join(millis);
    }

    private static void wait(Object lock, int timeout) {
        try {
            lock.wait(timeout);
        }
        catch (InterruptedException unused) {
            Thread.currentThread().interrupt();
        }
    }

    private static void sleep(long period) {
        try {
            Thread.sleep(period);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

