/*
 * Decompiled with CFR 0.152.
 */
package js.lang;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import js.lang.Pair;
import js.lang.SyntaxException;

public class PairsList
implements Iterable<Pair> {
    private static final char DEFAULT_SEPARATOR = ':';
    private final List<Pair> pairs = new ArrayList<Pair>();

    public PairsList(String expression) throws SyntaxException {
        this(expression, ':');
    }

    public PairsList(String expression, char separator) throws SyntaxException {
        int colonIndex;
        int semicolonIndex = 0;
        while ((colonIndex = expression.indexOf(separator, semicolonIndex)) != -1) {
            String firstValue = expression.substring(semicolonIndex, colonIndex);
            if ((semicolonIndex = expression.indexOf(59, ++colonIndex)) == -1) {
                semicolonIndex = expression.length();
            }
            if (colonIndex == semicolonIndex) {
                throw new SyntaxException("Invalid pairs expression |%s|. First value is empty.", expression);
            }
            Pair pair = new Pair(firstValue, expression.substring(colonIndex, semicolonIndex));
            if (this.pairs.contains(pair)) {
                throw new SyntaxException("Duplicated pairs in expression |%s|.", expression);
            }
            this.pairs.add(pair);
            ++semicolonIndex;
        }
        if (this.pairs.isEmpty()) {
            throw new SyntaxException("Invalid pairs expression |%s|. Missing pair separator |%s|.", expression, Character.valueOf(separator));
        }
    }

    @Override
    public Iterator<Pair> iterator() {
        return this.pairs.iterator();
    }
}

