/*
 * Decompiled with CFR 0.152.
 */
package js.log;

import java.io.File;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import js.log.Log;
import js.log.LogLevel;

public abstract class AbstractLog
implements Log {
    private static final String ELLIPSIS = "...";

    protected abstract boolean isLoggable(LogLevel var1);

    protected abstract void log(LogLevel var1, String var2);

    @Override
    public void trace(Object message) {
        if (this.isLoggable(LogLevel.TRACE)) {
            this.log(LogLevel.TRACE, AbstractLog.message(message));
        }
    }

    @Override
    public void trace(String message, Object ... args) {
        if (this.isLoggable(LogLevel.TRACE)) {
            this.log(LogLevel.TRACE, AbstractLog.format(message, args));
        }
    }

    @Override
    public void debug(Object message) {
        if (this.isLoggable(LogLevel.DEBUG)) {
            this.log(LogLevel.DEBUG, AbstractLog.message(message));
        }
    }

    @Override
    public void debug(String message, Object ... args) {
        if (this.isLoggable(LogLevel.DEBUG)) {
            this.log(LogLevel.DEBUG, AbstractLog.format(message, args));
        }
    }

    @Override
    public void info(Object message) {
        if (this.isLoggable(LogLevel.INFO)) {
            this.log(LogLevel.INFO, AbstractLog.message(message));
        }
    }

    @Override
    public void info(String message, Object ... args) {
        if (this.isLoggable(LogLevel.INFO)) {
            this.log(LogLevel.INFO, AbstractLog.format(message, args));
        }
    }

    @Override
    public void warn(Object message) {
        if (this.isLoggable(LogLevel.WARN)) {
            this.log(LogLevel.WARN, AbstractLog.message(message));
        }
    }

    @Override
    public void warn(String message, Object ... args) {
        if (this.isLoggable(LogLevel.WARN)) {
            this.log(LogLevel.WARN, AbstractLog.format(message, args));
        }
    }

    @Override
    public void error(Object message) {
        if (this.isLoggable(LogLevel.ERROR)) {
            this.log(LogLevel.ERROR, AbstractLog.message(message));
        }
    }

    @Override
    public void error(String message, Object ... args) {
        if (this.isLoggable(LogLevel.ERROR)) {
            this.log(LogLevel.ERROR, AbstractLog.format(message, args));
        }
    }

    @Override
    public void fatal(Object message) {
        if (this.isLoggable(LogLevel.FATAL)) {
            this.log(LogLevel.FATAL, AbstractLog.message(message));
        }
    }

    @Override
    public void fatal(String message, Object ... args) {
        if (this.isLoggable(LogLevel.FATAL)) {
            this.log(LogLevel.FATAL, AbstractLog.format(message, args));
        }
    }

    @Override
    public void bug(String message, Object ... args) {
        if (this.isLoggable(LogLevel.BUG)) {
            this.log(LogLevel.BUG, AbstractLog.format(message, args));
        }
    }

    @Override
    public void bug(boolean expectedCondition, String message, Object ... args) {
        if (this.isLoggable(LogLevel.BUG) && !expectedCondition) {
            this.log(LogLevel.BUG, AbstractLog.format(message, args));
        }
    }

    protected static String message(Object message) {
        if (message == null) {
            return null;
        }
        if (!(message instanceof Throwable)) {
            return message.toString();
        }
        Throwable t = (Throwable)message;
        if (t.getCause() == null) {
            return t.toString();
        }
        int nestingLevel = 0;
        StringBuilder sb = new StringBuilder();
        while (true) {
            sb.append(t.getClass().getName());
            sb.append(":");
            sb.append(" ");
            if (++nestingLevel == 8) {
                sb.append(ELLIPSIS);
                break;
            }
            if (t.getCause() == null) {
                String s = t.getMessage();
                if (s == null) {
                    t.getClass().getCanonicalName();
                }
                sb.append(s);
                break;
            }
            t = t.getCause();
        }
        return sb.toString();
    }

    private static String format(String message, Object ... args) {
        if (message == null) {
            return null;
        }
        if (message.isEmpty()) {
            return "";
        }
        if (args.length == 0) {
            return message;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i] instanceof Class) {
                args[i] = ((Class)args[i]).getCanonicalName();
                continue;
            }
            if (args[i] instanceof Throwable) {
                String s = ((Throwable)args[i]).getMessage();
                if (s == null) {
                    s = args[i].getClass().getCanonicalName();
                }
                args[i] = s;
                continue;
            }
            if (args[i] instanceof Thread) {
                Thread thread = (Thread)args[i];
                StringBuilder sb = new StringBuilder();
                sb.append(thread.getName());
                sb.append(':');
                sb.append(thread.getId());
                args[i] = sb.toString();
                continue;
            }
            if (args[i] instanceof File) {
                args[i] = ((File)args[i]).getAbsolutePath();
                continue;
            }
            if (!AbstractLog.isArrayLike(args[i])) continue;
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            int index = 0;
            for (Object object : AbstractLog.iterable(args[i])) {
                String value;
                if (object == null || (value = object instanceof String ? (String)object : object.toString()).isEmpty()) continue;
                if (index++ > 0) {
                    sb.append(',');
                }
                if (index == 4) {
                    sb.append(ELLIPSIS);
                    break;
                }
                sb.append(object);
            }
            sb.append(']');
            args[i] = sb.toString();
        }
        try {
            return String.format(message, args);
        }
        catch (Throwable unused) {
            return message;
        }
    }

    protected static String ellipsis(String message, int maxLength) {
        if (message == null) {
            return "null";
        }
        return message.length() < maxLength ? message : message.substring(0, maxLength - ELLIPSIS.length()) + ELLIPSIS;
    }

    private static boolean isArrayLike(Object object) {
        return object != null && (object.getClass().isArray() || object instanceof Collection);
    }

    private static Iterable<?> iterable(final Object object) {
        if (object instanceof Iterable) {
            return (Iterable)object;
        }
        return new Iterable<Object>(){
            private Object array;
            private int index;
            {
                this.array = object;
            }

            @Override
            public Iterator<Object> iterator() {
                return new Iterator<Object>(){

                    @Override
                    public boolean hasNext() {
                        return index < Array.getLength(array);
                    }

                    @Override
                    public Object next() {
                        return Array.get(array, index++);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Array iterator has no remove operation.");
                    }
                };
            }
        };
    }
}

