/*
 * Decompiled with CFR 0.152.
 */
package js.log;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import js.log.AbstractLog;
import js.log.LogLevel;

final class DefaultLog
extends AbstractLog {
    private static final DateFormat DATE_FMT = new SimpleDateFormat("DDD HH:mm:ss.SSS");
    private String loggerName;

    public DefaultLog(String loggerName) {
        this.loggerName = loggerName;
    }

    @Override
    protected boolean isLoggable(LogLevel level) {
        return true;
    }

    @Override
    protected void log(LogLevel level, String message) {
        if (message != null) {
            System.out.printf("%s [%s] %s - %s\r\n", new Object[]{DATE_FMT.format(new Date()), level, this.loggerName, message});
        }
    }

    @Override
    public void dump(Object message, Throwable throwable) {
        if (this.isLoggable(LogLevel.FATAL)) {
            System.out.printf("%s [%s] %s - %s\r\n", new Object[]{DATE_FMT.format(new Date()), LogLevel.FATAL, this.loggerName, message});
            throwable.printStackTrace(System.out);
        }
    }

    @Override
    public void print(LogLevel level, String message) {
        if (this.isLoggable(level)) {
            System.out.printf("%s [%s] %s - %s\r\n", new Object[]{DATE_FMT.format(new Date()), level, this.loggerName, message});
        }
    }
}

