/*
 * Decompiled with CFR 0.152.
 */
package js.log;

import java.util.Iterator;
import java.util.ServiceLoader;
import js.lang.Config;
import js.log.DefaultLogProvider;
import js.log.Log;
import js.log.LogContext;
import js.log.LogProvider;

public final class LogFactory {
    private static LogProvider provider = LogFactory.provider();

    private static LogProvider provider() {
        ServiceLoader<LogProvider> providers = ServiceLoader.load(LogProvider.class);
        Iterator iterator = providers.iterator();
        if (iterator.hasNext()) {
            LogProvider provider = (LogProvider)iterator.next();
            return provider;
        }
        return new DefaultLogProvider();
    }

    private LogFactory() {
    }

    public static void config(Config config) {
        try {
            provider.config(config);
        }
        catch (Throwable t) {
            provider = new DefaultLogProvider();
            Log log = provider.getLogger(LogFactory.class.getName());
            log.error("Fail on logger provider configuration. Reset logging system to default provider.");
            log.dump("Logging configuration stack dump:", t);
        }
    }

    public static Log getLog(String loggerName) {
        return provider.getLogger(loggerName);
    }

    public static Log getLog(Class<?> targetClass) {
        return provider.getLogger(targetClass.getName());
    }

    public static LogContext getLogContext() {
        return provider.getLogContext();
    }
}

