/*
 * Decompiled with CFR 0.152.
 */
package js.util;

import java.io.UnsupportedEncodingException;
import js.lang.BugError;

public final class Base64 {
    private static final char[] NIBLES_2_CHARS;
    private static final byte[] CHARS_2_NIBLES;

    private Base64() {
    }

    public static String encode(String string) {
        try {
            return Base64.encode(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new BugError("JVM with missing support for UTF-8.", new Object[0]);
        }
    }

    public static String encode(byte[] bytes) {
        int bytesLength = bytes.length;
        int base64Length = (bytesLength * 4 + 2) / 3;
        StringBuilder base64Builder = new StringBuilder();
        int bytesIndex = 0;
        while (bytesIndex < bytesLength) {
            int i0 = bytes[bytesIndex++] & 0xFF;
            int i1 = bytesIndex < bytesLength ? bytes[bytesIndex++] & 0xFF : 0;
            int i2 = bytesIndex < bytesLength ? bytes[bytesIndex++] & 0xFF : 0;
            int o0 = i0 >>> 2;
            int o1 = (i0 & 3) << 4 | i1 >>> 4;
            int o2 = (i1 & 0xF) << 2 | i2 >>> 6;
            int o3 = i2 & 0x3F;
            base64Builder.append(NIBLES_2_CHARS[o0]);
            base64Builder.append(NIBLES_2_CHARS[o1]);
            base64Builder.append(base64Builder.length() < base64Length ? NIBLES_2_CHARS[o2] : (char)'=');
            base64Builder.append(base64Builder.length() < base64Length ? NIBLES_2_CHARS[o3] : (char)'=');
        }
        return base64Builder.toString();
    }

    public static byte[] decode(String base64) {
        int iLen = base64.length();
        if (iLen % 4 != 0) {
            throw new IllegalArgumentException("Length of Base64 encoded input string is not a multiple of 4.");
        }
        while (iLen > 0 && base64.charAt(iLen - 1) == '=') {
            --iLen;
        }
        int oLen = iLen * 3 / 4;
        byte[] out = new byte[oLen];
        int ip = 0;
        int op = 0;
        while (ip < iLen) {
            int i3;
            char i0 = base64.charAt(ip++);
            char i1 = base64.charAt(ip++);
            int i2 = ip < iLen ? (int)base64.charAt(ip++) : 65;
            int n = i3 = ip < iLen ? (int)base64.charAt(ip++) : 65;
            if (i0 > '\u007f' || i1 > '\u007f' || i2 > 127 || i3 > 127) {
                throw new IllegalArgumentException("Illegal character in Base64 encoded data.");
            }
            byte b0 = CHARS_2_NIBLES[i0];
            byte b1 = CHARS_2_NIBLES[i1];
            byte b2 = CHARS_2_NIBLES[i2];
            byte b3 = CHARS_2_NIBLES[i3];
            if (b0 < 0 || b1 < 0 || b2 < 0 || b3 < 0) {
                throw new IllegalArgumentException("Illegal character in Base64 encoded data.");
            }
            int o0 = b0 << 2 | b1 >>> 4;
            int o1 = (b1 & 0xF) << 4 | b2 >>> 2;
            int o2 = (b2 & 3) << 6 | b3;
            out[op++] = (byte)o0;
            if (op < oLen) {
                out[op++] = (byte)o1;
            }
            if (op >= oLen) continue;
            out[op++] = (byte)o2;
        }
        return out;
    }

    static {
        int c;
        NIBLES_2_CHARS = new char[64];
        CHARS_2_NIBLES = new byte[128];
        int i = 0;
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            Base64.NIBLES_2_CHARS[i++] = c;
        }
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            Base64.NIBLES_2_CHARS[i++] = c;
        }
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            Base64.NIBLES_2_CHARS[i++] = c;
        }
        Base64.NIBLES_2_CHARS[i++] = 43;
        Base64.NIBLES_2_CHARS[i++] = 47;
        for (i = 0; i < CHARS_2_NIBLES.length; ++i) {
            Base64.CHARS_2_NIBLES[i] = -1;
        }
        for (i = 0; i < 64; ++i) {
            Base64.CHARS_2_NIBLES[Base64.NIBLES_2_CHARS[i]] = (byte)i;
        }
    }
}

