/*
 * Decompiled with CFR 0.152.
 */
package js.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.SortedMap;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import js.converter.Converter;
import js.converter.ConverterRegistry;
import js.lang.BugError;
import js.lang.InstanceInvocationHandler;
import js.lang.InvocationException;
import js.lang.NoProviderException;
import js.lang.NoSuchBeingException;
import js.lang.VarArgs;
import js.log.Log;
import js.log.LogFactory;
import js.util.Files;
import js.util.FilteredStrings;
import js.util.Params;
import js.util.Strings;
import js.util.Types;

public class Classes {
    private static Log log = LogFactory.getLog(Classes.class);
    private static final String[] GETTERS_PREFIX = new String[]{"get", "is"};
    private static Map<Class<?>, Class<?>> COLLECTIONS = new HashMap();
    private static Map<Class<?>, Class<?>> LISTS;
    private static Map<Class<?>, Class<?>> MAPS;

    protected Classes() {
    }

    public static <T> Class<T> forName(String className) throws NoSuchBeingException, ClassCastException, NullPointerException {
        if (className == null) {
            throw new NullPointerException("Null class name.");
        }
        Class<T> clazz = Classes.forOptionalName(className);
        if (clazz == null) {
            throw new NoSuchBeingException("Class not found: " + className, new Object[0]);
        }
        return clazz;
    }

    public static <T> Class<T> forOptionalName(String className) {
        if (className == null) {
            return null;
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader != null) {
            try {
                return Class.forName(className, true, loader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (loader == null || !loader.equals(Classes.class.getClassLoader())) {
            try {
                return Class.forName(className, true, Classes.class.getClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public static <T> Class<T> forNameEx(String className) throws ClassNotFoundException, ClassCastException, NullPointerException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        ClassNotFoundException classNotFoundException = null;
        if (loader != null) {
            try {
                return Class.forName(className, true, loader);
            }
            catch (ClassNotFoundException expected) {
                classNotFoundException = expected;
            }
        }
        if (classNotFoundException != null && loader.equals(Classes.class.getClassLoader())) {
            throw classNotFoundException;
        }
        return Class.forName(className, true, Classes.class.getClassLoader());
    }

    public static <S> S loadService(Class<S> serviceInterface) {
        S service = Classes.loadOptionalService(serviceInterface);
        if (service == null) {
            throw new NoProviderException(serviceInterface);
        }
        return service;
    }

    public static <S> S loadService(Class<S> serviceInterface, ClassLoader classLoader) {
        Iterator<S> services = ServiceLoader.load(serviceInterface, classLoader).iterator();
        if (services.hasNext()) {
            return services.next();
        }
        try {
            String serviceDescriptor = Classes.getResourceAsString("/services/" + serviceInterface.getName());
            return (S)Classes.newInstance(serviceDescriptor, new Object[0]);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static <S> S loadOptionalService(Class<S> serviceInterface) {
        S service = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            service = Classes.loadService(serviceInterface, classLoader);
        }
        if (service == null) {
            service = Classes.loadService(serviceInterface, Classes.class.getClassLoader());
        }
        return service;
    }

    public static boolean isInstantiable(Class<?> clazz) {
        if (clazz.isInterface()) {
            return false;
        }
        int m = clazz.getModifiers();
        if (Modifier.isAbstract(m)) {
            return false;
        }
        try {
            clazz.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException unused) {
            return false;
        }
        return true;
    }

    public static Class<?>[] getParameterTypes(Object ... arguments) {
        Class[] types = new Class[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            Object argument = arguments[i];
            if (argument == null) {
                types[i] = Object.class;
                continue;
            }
            if (!(argument instanceof VarArgs)) {
                Class<Object> superclass;
                types[i] = argument.getClass();
                if (!types[i].isAnonymousClass()) continue;
                Class<?>[] interfaces = types[i].getInterfaces();
                Class<?> clazz = superclass = interfaces.length > 0 ? interfaces[0] : null;
                if (superclass == null) {
                    superclass = types[i].getSuperclass();
                }
                types[i] = superclass;
                continue;
            }
            if (i != arguments.length - 1) {
                throw new BugError("Variable arguments must be the last in arguments list.", new Object[0]);
            }
            VarArgs varArgs = (VarArgs)argument;
            int index = arguments.length - 1;
            types[index] = varArgs.getType();
            arguments[index] = varArgs.getArguments();
        }
        return types;
    }

    public static <T> T invoke(Object object, String methodName, Object ... arguments) throws Exception {
        Params.notNull(object, "Object", new Object[0]);
        Params.notNullOrEmpty(methodName, "Method name");
        if (object instanceof Class) {
            return Classes.invoke(null, (Class)object, methodName, arguments);
        }
        return Classes.invoke(object, object.getClass(), methodName, arguments);
    }

    public static <T> T invoke(Object object, Class<?> clazz, String methodName, Object ... arguments) throws Exception {
        Params.notNull(clazz, "Class", new Object[0]);
        Params.notNullOrEmpty(methodName, "Method name");
        Class<?>[] parameterTypes = Classes.getParameterTypes(arguments);
        try {
            Method method = clazz.getDeclaredMethod(methodName, parameterTypes);
            return (T)Classes.invoke(object, method, arguments);
        }
        catch (NoSuchMethodException e) {
            block2: for (Method method : clazz.getDeclaredMethods()) {
                Class<?>[] methodParameters = method.getParameterTypes();
                if (!method.getName().equals(methodName) || methodParameters.length != arguments.length) continue;
                for (int i = 0; i < arguments.length; ++i) {
                    if (arguments[i] != null && !Types.isInstanceOf(arguments[i], methodParameters[i])) continue block2;
                }
                return (T)Classes.invoke(object, method, arguments);
            }
            throw new NoSuchBeingException("Method %s(%s) not found.", methodName, parameterTypes);
        }
    }

    public static void invokeSetter(Object object, String name, String value) throws NoSuchMethodException, Exception {
        String setterName = Strings.getMethodAccessor("set", name);
        Class<?> clazz = object.getClass();
        Method method = Classes.findMethod(clazz, setterName);
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != 1) {
            throw new NoSuchMethodException(String.format("%s#%s", clazz.getName(), setterName));
        }
        Classes.invoke(object, method, ConverterRegistry.getConverter().asObject(value, parameterTypes[0]));
    }

    public static void invokeOptionalSetter(Object object, String name, String value) throws Exception {
        String setterName = Strings.getMethodAccessor("set", name);
        Class<?> clazz = object.getClass();
        Method method = null;
        try {
            method = Classes.findMethod(clazz, setterName);
        }
        catch (NoSuchMethodException e) {
            log.debug("Setter |%s| not found in class |%s| or its super hierarchy.", setterName, clazz);
            return;
        }
        Object[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != 1) {
            log.debug("Setter |%s#%s(%s)| with invalid parameters number.", method.getDeclaringClass(), method.getName(), Strings.join(parameterTypes, ','));
            return;
        }
        Classes.invoke(object, method, ConverterRegistry.getConverter().asObject(value, parameterTypes[0]));
    }

    public static Object invoke(Object object, Method method, Object ... arguments) throws Exception {
        Throwable cause = null;
        try {
            method.setAccessible(true);
            return method.invoke(object instanceof Class ? null : object, arguments);
        }
        catch (IllegalAccessException e) {
            throw new BugError(e);
        }
        catch (InvocationTargetException e) {
            cause = e.getCause();
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            if (cause instanceof AssertionError) {
                throw (AssertionError)((Object)cause);
            }
            throw new BugError("Method |%s| invocation fails: %s", method, cause);
        }
    }

    public static boolean hasMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        try {
            clazz.getDeclaredMethod(methodName, parameterTypes);
            return true;
        }
        catch (SecurityException e) {
            throw new BugError(e);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        try {
            Method method = clazz.getDeclaredMethod(methodName, parameterTypes);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchBeingException(e);
        }
        catch (SecurityException e) {
            throw new BugError(e);
        }
    }

    public static Method getGetter(Class<?> clazz, String fieldName) throws NoSuchMethodException {
        for (String prefix : GETTERS_PREFIX) {
            try {
                Method method = clazz.getDeclaredMethod(Strings.getMethodAccessor(prefix, fieldName), new Class[0]);
                method.setAccessible(true);
                return method;
            }
            catch (NoSuchMethodException method) {
            }
            catch (SecurityException e) {
                throw new BugError(e);
            }
        }
        throw new NoSuchMethodException(String.format("No getter for |%s#%s|.", clazz.getCanonicalName(), fieldName));
    }

    public static Method findMethod(Class<?> clazz, String methodName) throws NoSuchMethodException {
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.getName().equals(methodName)) continue;
            method.setAccessible(true);
            return method;
        }
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null && superclass.getPackage().equals(clazz.getPackage())) {
            return Classes.findMethod(superclass, methodName);
        }
        throw new NoSuchMethodException(String.format("%s#%s", clazz.getName(), methodName));
    }

    public static String getCallerMethod() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        if (stackTrace.length == 0) {
            return "unknown";
        }
        StackTraceElement e = stackTrace[0];
        return Strings.concat(e.getClassName(), Character.valueOf('#'), e.getMethodName(), Character.valueOf(':'), e.getLineNumber());
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            throw new NoSuchBeingException(e);
        }
        catch (SecurityException e) {
            throw new BugError(e);
        }
    }

    public static Field getOptionalField(Class<?> clazz, String fieldName) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException field) {
        }
        catch (SecurityException e) {
            throw new BugError(e);
        }
        return null;
    }

    public static Field getOptionalFieldEx(Class<?> clazz, String fieldName) {
        if (fieldName == null) {
            return null;
        }
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            Class<?> superclass = clazz.getSuperclass();
            if (superclass != null && clazz.getPackage().equals(superclass.getPackage())) {
                return Classes.getOptionalFieldEx(superclass, fieldName);
            }
            return null;
        }
        catch (SecurityException e) {
            throw new BugError(e);
        }
    }

    public static Field getFieldEx(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            Class<?> superclass = clazz.getSuperclass();
            if (superclass != null && clazz.getPackage().equals(superclass.getPackage())) {
                return Classes.getFieldEx(superclass, fieldName);
            }
            throw e;
        }
        catch (SecurityException e) {
            throw new BugError(e);
        }
    }

    public static <T> T getFieldValue(Object object, Field field) {
        assert (field.isAccessible());
        try {
            return (T)field.get(object);
        }
        catch (IllegalAccessException e) {
            throw new BugError(e);
        }
    }

    public static <T> T getFieldValue(Object object, String fieldName) {
        if (object instanceof Class) {
            return Classes.getFieldValue(null, (Class)object, fieldName, null, false);
        }
        Class<?> clazz = object.getClass();
        try {
            Field f = clazz.getDeclaredField(fieldName);
            f.setAccessible(true);
            return (T)f.get(Modifier.isStatic(f.getModifiers()) ? null : object);
        }
        catch (NoSuchFieldException e) {
            throw new NoSuchBeingException("Missing field |%s| from |%s|.", fieldName, clazz);
        }
        catch (IllegalAccessException e) {
            throw new BugError(e);
        }
    }

    @SafeVarargs
    public static <T> T getOptionalFieldValue(Object object, String fieldName, Class<T> ... fieldType) {
        Class<?> clazz = null;
        if (object instanceof Class) {
            clazz = (Class<?>)object;
            object = null;
        } else {
            clazz = object.getClass();
        }
        return Classes.getFieldValue(object, clazz, fieldName, fieldType.length == 1 ? fieldType[0] : null, true);
    }

    public static <T> T getFieldValue(Object object, Class<?> clazz, String fieldName) {
        return Classes.getFieldValue(object, clazz, fieldName, null, false);
    }

    private static <T> T getFieldValue(Object object, Class<?> clazz, String fieldName, Class<T> fieldType, boolean optional) {
        try {
            Field f = clazz.getDeclaredField(fieldName);
            if (fieldType != null && fieldType != f.getType()) {
                return null;
            }
            f.setAccessible(true);
            if (object == null ^ Modifier.isStatic(f.getModifiers())) {
                throw new BugError("Cannot access static field from instance or instance field from null object.", new Object[0]);
            }
            return (T)f.get(object);
        }
        catch (NoSuchFieldException e) {
            if (optional) {
                return null;
            }
            throw new NoSuchBeingException("Missing field |%s| from |%s|.", fieldName, clazz);
        }
        catch (IllegalAccessException e) {
            throw new BugError(e);
        }
    }

    public static void setFieldValue(Object object, Field field, Object value) throws IllegalArgumentException, BugError {
        Params.notNull(field, "Field", new Object[0]);
        Class<?> type = field.getType();
        if (!type.equals(String.class) && value instanceof String) {
            value = ConverterRegistry.getConverter().asObject((String)value, type);
        }
        if (value != null && !Types.isInstanceOf(value, type)) {
            throw new BugError("Value |%s| is not assignable to field |%s|.", value.getClass(), field);
        }
        try {
            field.setAccessible(true);
            field.set(object, value);
        }
        catch (IllegalAccessException e) {
            throw new BugError(e);
        }
    }

    public static void setFieldValue(Object object, String fieldName, Object value) {
        Params.notNull(object, "Object instance or class", new Object[0]);
        Params.notNull(fieldName, "Field name", new Object[0]);
        if (object instanceof Class) {
            Classes.setFieldValue(null, (Class)object, fieldName, value);
        } else {
            Classes.setFieldValue(object, object.getClass(), fieldName, value);
        }
    }

    public static void setFieldValue(Object object, Class<?> clazz, String fieldName, Object value) {
        Field field;
        if (object == null ^ Modifier.isStatic((field = Classes.getField(clazz, fieldName)).getModifiers())) {
            throw new BugError("Cannot access static field |%s| from instance |%s|.", fieldName, clazz);
        }
        Classes.setFieldValue(object, field, value);
    }

    public static void setFieldValues(Object object, String fieldName, String valuesString) {
        Converter converter = ConverterRegistry.getConverter();
        List<String> values = Strings.split(valuesString, ',');
        Field field = Classes.getField(object.getClass(), fieldName);
        Class<?> type = field.getType();
        Object instance = null;
        if (Types.isArray(type)) {
            Class<?> componentType = field.getClass().getComponentType();
            instance = Array.newInstance(componentType, values.size());
            for (int i = 0; i < values.size(); ++i) {
                Array.set(instance, i, converter.asObject(values.get(i), componentType));
            }
        } else if (Types.isCollection(type)) {
            Class componentType = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
            instance = Classes.newCollection(type);
            for (int i = 0; i < values.size(); ++i) {
                ((Collection)instance).add(converter.asObject(values.get(i), componentType));
            }
        } else {
            throw new BugError("Cannot set values list to field type |%s|.", field.getType());
        }
        Classes.setFieldValue(object, field, instance);
    }

    public static String getPackageResource(Class<?> type, String resourceName) {
        StringBuilder builder = new StringBuilder();
        builder.append(type.getPackage().getName().replace('.', '/'));
        if (resourceName.charAt(0) != '/') {
            builder.append('/');
        }
        builder.append(resourceName);
        return builder.toString();
    }

    public static URL getResource(String name) {
        Params.notNull(name, "Resource name", new Object[0]);
        if (!name.isEmpty() && name.charAt(0) == '/') {
            name = name.substring(1);
        }
        return Classes.getResource(name, new ClassLoader[]{Thread.currentThread().getContextClassLoader(), Classes.class.getClassLoader(), ClassLoader.getSystemClassLoader()});
    }

    private static URL getResource(String name, ClassLoader[] classLoaders) {
        for (ClassLoader classLoader : classLoaders) {
            URL url = classLoader.getResource(name);
            if (url == null) {
                url = classLoader.getResource('/' + name);
            }
            if (url == null) continue;
            return url;
        }
        return null;
    }

    public static InputStream getResourceAsStream(String name) {
        InputStream stream;
        Params.notNullOrEmpty(name, "Resource name");
        if (name.charAt(0) == '/') {
            name = name.substring(1);
        }
        if ((stream = Classes.getResourceAsStream(name, new ClassLoader[]{Thread.currentThread().getContextClassLoader(), Classes.class.getClassLoader(), ClassLoader.getSystemClassLoader()})) == null) {
            throw new NoSuchBeingException("Resource |%s| not found.", name);
        }
        return stream;
    }

    private static InputStream getResourceAsStream(String name, ClassLoader[] classLoaders) {
        for (ClassLoader classLoader : classLoaders) {
            InputStream stream = classLoader.getResourceAsStream(name);
            if (stream == null) {
                stream = classLoader.getResourceAsStream('/' + name);
            }
            if (stream == null) continue;
            return stream;
        }
        return null;
    }

    public static File getResourceAsFile(String name) {
        URL resourceURL = Classes.getResource(name);
        if (resourceURL == null) {
            throw new NoSuchBeingException("Resource |%s| not found.", name);
        }
        String protocol = resourceURL.getProtocol();
        if ("file".equals(protocol)) {
            try {
                return new File(resourceURL.toURI());
            }
            catch (URISyntaxException e) {
                throw new BugError("Invalid syntax on URL returned by getResource.", new Object[0]);
            }
        }
        throw new UnsupportedOperationException("Can't get a file for a resource using protocol" + protocol);
    }

    public static Reader getResourceAsReader(String name) throws UnsupportedEncodingException {
        return new InputStreamReader(Classes.getResourceAsStream(name), "UTF-8");
    }

    public static String getResourceAsString(String name) throws IOException {
        StringWriter writer = new StringWriter();
        Files.copy(Classes.getResourceAsReader(name), writer);
        return writer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getResourceAsBytes(String name) throws IOException {
        InputStream is = Classes.getResourceAsStream(name);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            byte[] buffer = new byte[4096];
            int length = 0;
            while ((length = is.read(buffer)) != -1) {
                os.write(buffer, 0, length);
            }
        }
        finally {
            Files.close(is);
            Files.close(os);
        }
        return os.toByteArray();
    }

    public static Collection<String> listPackageResources(String packageName, String fileNamesPattern) {
        String packagePath = Files.dot2urlpath(packageName);
        HashSet<URL> packageURLs = new HashSet<URL>();
        for (ClassLoader classLoader : new ClassLoader[]{Thread.currentThread().getContextClassLoader(), Classes.class.getClassLoader(), ClassLoader.getSystemClassLoader()}) {
            try {
                packageURLs.addAll(Collections.list(classLoader.getResources(packagePath)));
            }
            catch (IOException e) {
                log.error(e);
            }
        }
        if (packageURLs.isEmpty()) {
            throw new NoSuchBeingException("Package |%s| not found.", packageName);
        }
        HashSet<String> resources = new HashSet<String>();
        for (URL packageURL : packageURLs) {
            resources.addAll(Classes.listPackageResources(packageURL, packagePath, fileNamesPattern));
        }
        return resources;
    }

    private static Collection<String> listPackageResources(URL packageURL, String packagePath, String fileNamesPattern) {
        if ("file".equals(packageURL.getProtocol())) {
            FilteredStrings resources = new FilteredStrings(fileNamesPattern);
            try {
                if (!packagePath.isEmpty()) {
                    packagePath = packagePath + "/";
                }
                resources.addAll(packagePath, new File(packageURL.toURI()).list());
            }
            catch (URISyntaxException e) {
                throw new BugError("Invalid syntax on URL |%s| returned by getResource.", packageURL);
            }
            return resources;
        }
        if (packageURL.toExternalForm().startsWith("jar:file")) {
            String path = packageURL.getPath();
            String jarPath = path.substring(5, path.indexOf("!"));
            JarFile jar = null;
            try {
                jar = new JarFile(jarPath);
                FilteredStrings resources = new FilteredStrings(fileNamesPattern);
                assert (jar != null);
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    resources.add(entries.nextElement().getName());
                }
                FilteredStrings filteredStrings = resources;
                return filteredStrings;
            }
            catch (IOException e) {
                throw new BugError("Java archive |%s| is not well formed or file reading fails.", packageURL.getPath());
            }
            finally {
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (IOException e) {
                        log.error(e);
                    }
                }
            }
        }
        throw new UnsupportedOperationException(String.format("Bad protocol |%s|.", packageURL));
    }

    public static <T> T newInstance(Type type, Object ... arguments) {
        if (type instanceof ParameterizedType) {
            ParameterizedType t = (ParameterizedType)type;
            if (!(t.getRawType() instanceof Class)) {
                throw new BugError("Raw type for parameterized type should be a class but is |%s|.", t.getRawType());
            }
            Class rawClass = (Class)t.getRawType();
            if (rawClass.isInterface()) {
                if (Types.isCollection(rawClass)) {
                    return Classes.newCollection(rawClass);
                }
                if (Types.isMap(rawClass)) {
                    return Classes.newMap(rawClass);
                }
            }
            return Classes.newInstance(t.getRawType(), arguments);
        }
        if (type instanceof Class) {
            return Classes.newInstance((Class)type, arguments);
        }
        throw new BugError("Cannot create new instance for type |%s|.", type);
    }

    public static <T> T newInstance(String className, Object ... arguments) {
        return Classes.newInstance(Classes.forName(className), arguments);
    }

    public static <T> T newInstance(Class<T> clazz, Object ... arguments) throws BugError, NoSuchBeingException, BugError {
        if (clazz.isInterface()) {
            throw new BugError("Attempt to create new instance for interface |%s|.", clazz);
        }
        if (clazz.isArray()) {
            throw new BugError("Attempt to create new array instance of |%s|.", clazz);
        }
        if (Modifier.isAbstract(clazz.getModifiers())) {
            throw new BugError("Attempt to create new instance for abstract class |%s|.", clazz);
        }
        if (Types.isVoid(clazz)) {
            throw new BugError("Attempt to instantiate void class.", new Object[0]);
        }
        try {
            Constructor<Object> constructor = null;
            if (arguments.length > 0) {
                block4: for (Constructor<?> ctor : clazz.getDeclaredConstructors()) {
                    Class<?>[] parameters = ctor.getParameterTypes();
                    if (parameters.length != arguments.length) continue;
                    for (int i = 0; i < arguments.length; ++i) {
                        if (arguments[i] != null && !Types.isInstanceOf(arguments[i], parameters[i])) continue block4;
                    }
                    constructor = ctor;
                    break;
                }
                if (constructor == null) {
                    throw Classes.missingConstructorException(clazz, arguments);
                }
            } else {
                constructor = clazz.getDeclaredConstructor(new Class[0]);
            }
            constructor.setAccessible(true);
            return constructor.newInstance(arguments);
        }
        catch (NoSuchMethodException e) {
            throw Classes.missingConstructorException(clazz, arguments);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException e) {
            throw new BugError(e);
        }
        catch (InvocationTargetException e) {
            throw new InvocationException(e);
        }
    }

    private static NoSuchBeingException missingConstructorException(Class<?> clazz, Object ... arguments) {
        Object[] types = new Type[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            types[i] = arguments[i].getClass();
        }
        return new NoSuchBeingException("Missing constructor(%s) for |%s|.", Arrays.toString(types), clazz);
    }

    public static <T extends Collection<?>> T newCollection(Type type) {
        return (T)((Collection)Classes.newRegisteredInstance(COLLECTIONS, type));
    }

    public static <T extends List<?>> Class<T> getListDefaultImplementation(Type listType) {
        return Classes.getImplementation(LISTS, listType);
    }

    public static <T extends List<?>> T newList(Type type) {
        return (T)((List)Classes.newRegisteredInstance(LISTS, type));
    }

    public static Class<?> getImplementation(Map<Class<?>, Class<?>> implementationsRegistry, Type interfaceType) {
        Class<?> implementation = implementationsRegistry.get(interfaceType);
        if (implementation == null) {
            throw new BugError("No registered implementation for type |%s|.", interfaceType);
        }
        return implementation;
    }

    private static <T> T newRegisteredInstance(Map<Class<?>, Class<?>> implementationsRegistry, Type interfaceType) throws BugError {
        Class<?> implementation = Classes.getImplementation(implementationsRegistry, interfaceType);
        try {
            return (T)implementation.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new BugError(e);
        }
        catch (InstantiationException e) {
            throw new BugError(e);
        }
    }

    public static <T extends Map<?, ?>> T newMap(Type type) {
        Class<?> implementation = MAPS.get(type);
        if (implementation == null) {
            throw new BugError("No registered implementation for map |%s|.", type);
        }
        return (T)((Map)Classes.newInstance(implementation, new Object[0]));
    }

    public static Class<?> forType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return Classes.forType(((ParameterizedType)type).getRawType());
        }
        if (!(type instanceof GenericArrayType)) {
            return null;
        }
        Type componentType = ((GenericArrayType)type).getGenericComponentType();
        Class<?> componentClass = Classes.forType(componentType);
        return componentClass != null ? Array.newInstance(componentClass, 0).getClass() : null;
    }

    public static <T> T unproxy(T instance) {
        if (instance == null) {
            return null;
        }
        if (!(instance instanceof Proxy)) {
            return instance;
        }
        if (!(Proxy.getInvocationHandler(instance) instanceof InstanceInvocationHandler)) {
            throw new BugError("Cannot unproxy instance |%s|. Proxy handler does not implement |%s|", instance.getClass(), InstanceInvocationHandler.class);
        }
        InstanceInvocationHandler handler = (InstanceInvocationHandler)Proxy.getInvocationHandler(instance);
        return handler.getWrappedInstance();
    }

    static {
        HashMap<Class<Properties>, Class<Properties>> m = new HashMap<Class<Properties>, Class<Properties>>();
        m.put(Collection.class, Vector.class);
        m.put(List.class, ArrayList.class);
        m.put(ArrayList.class, ArrayList.class);
        m.put(Vector.class, Vector.class);
        m.put(Set.class, HashSet.class);
        m.put(HashSet.class, HashSet.class);
        m.put(TreeSet.class, TreeSet.class);
        COLLECTIONS = Collections.unmodifiableMap(m);
        LISTS = new HashMap();
        m = new HashMap();
        m.put(List.class, ArrayList.class);
        m.put(AbstractList.class, ArrayList.class);
        m.put(ArrayList.class, ArrayList.class);
        m.put(LinkedList.class, LinkedList.class);
        m.put(Vector.class, Vector.class);
        m.put(Stack.class, Stack.class);
        LISTS = Collections.unmodifiableMap(m);
        MAPS = new HashMap();
        m = new HashMap();
        m.put(Map.class, HashMap.class);
        m.put(HashMap.class, HashMap.class);
        m.put(SortedMap.class, TreeMap.class);
        m.put(TreeMap.class, TreeMap.class);
        m.put(Hashtable.class, Hashtable.class);
        m.put(Properties.class, Properties.class);
        MAPS = Collections.unmodifiableMap(m);
    }
}

