/*
 * Decompiled with CFR 0.152.
 */
package js.util;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import js.io.WildcardFilter;

public class FilteredStrings
extends AbstractList<String> {
    private List<String> list = new ArrayList<String>();
    private WildcardFilter filter;

    public FilteredStrings(String pattern) {
        this.filter = new WildcardFilter(pattern);
    }

    @Override
    public boolean add(String string) {
        if (this.filter.accept(string)) {
            this.list.add(string);
            return true;
        }
        return false;
    }

    public void addAll(String prefix, String[] strings) {
        if (strings == null) {
            return;
        }
        for (String string : strings) {
            if (!this.filter.accept(string)) continue;
            this.list.add(prefix + string);
        }
    }

    public void addAll(String[] strings) {
        if (strings == null) {
            return;
        }
        for (String string : strings) {
            this.add(string);
        }
    }

    @Override
    public Iterator<String> iterator() {
        return this.list.iterator();
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public String get(int index) throws IndexOutOfBoundsException {
        return this.list.get(index);
    }
}

