/*
 * Decompiled with CFR 0.152.
 */
package js.util;

import java.io.File;
import java.util.Locale;
import js.util.Params;

public class I18nFile {
    private final File file;
    private final Locale locale;

    I18nFile(File file) throws IllegalArgumentException {
        this.file = file;
        this.locale = null;
    }

    I18nFile(File file, Locale locale) throws IllegalArgumentException {
        this.file = file;
        Params.notNull(locale, "Locale", new Object[0]);
        Params.empty(locale.getVariant(), "Locale variant");
        Params.empty(locale.getScript(), "Locale script");
        Params.empty(locale.getExtensionKeys(), "Locale extension");
        this.locale = locale;
    }

    public File getFile() {
        return this.file;
    }

    public String getName() {
        return this.file.getName();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getLanguageTag() {
        return this.locale != null ? this.locale.toLanguageTag() : null;
    }
}

