/*
 * Decompiled with CFR 0.152.
 */
package js.util;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import js.lang.BugError;
import js.util.I18nPool;
import js.util.Params;

final class I18nPoolFactory {
    I18nPoolFactory() {
    }

    public static <T> I18nPool<T> getInstance(boolean multiLocale) {
        if (multiLocale) {
            return new LocalePool();
        }
        return new SimplePool();
    }

    private static class LocalePool<T>
    implements I18nPool<T> {
        private final Map<String, Map<String, T>> localeMaps = new HashMap<String, Map<String, T>>();

        private LocalePool() {
        }

        @Override
        public boolean put(String name, T t, Locale ... locale) {
            Params.notNullOrEmpty(name, "Name");
            Params.notNullOrEmpty(locale, "Locale");
            Params.empty(locale[0].getVariant(), "Locale variant");
            Params.empty(locale[0].getScript(), "Locale script");
            Params.empty(locale[0].getExtensionKeys(), "Locale extension");
            Map<String, T> maps = this.localeMaps.get(locale[0].toLanguageTag());
            if (maps == null) {
                maps = new HashMap<String, T>();
                this.localeMaps.put(locale[0].toLanguageTag(), maps);
            }
            return maps.put(name, t) != null;
        }

        @Override
        public T get(String name, Locale ... locale) {
            Params.notNullOrEmpty(name, "Name");
            Params.notNullOrEmpty(locale, "Locale");
            return this.maps(locale[0]).get(name);
        }

        @Override
        public boolean has(String name, Locale ... locale) {
            Params.notNullOrEmpty(name, "Name");
            Params.notNullOrEmpty(locale, "Locale");
            return this.maps(locale[0]).containsKey(name);
        }

        private Map<String, T> maps(Locale locale) {
            Params.empty(locale.getVariant(), "Locale variant");
            Params.empty(locale.getScript(), "Locale script");
            Params.empty(locale.getExtensionKeys(), "Locale extension");
            Map<String, T> maps = this.localeMaps.get(locale.toLanguageTag());
            if (maps == null) {
                throw new BugError("Missing repository for locale |%s|.", locale);
            }
            return maps;
        }
    }

    private static class SimplePool<T>
    implements I18nPool<T> {
        private final Map<String, T> map = new HashMap<String, T>();

        private SimplePool() {
        }

        @Override
        public boolean put(String name, T t, Locale ... locale) {
            Params.notNullOrEmpty(name, "Name");
            return this.map.put(name, t) != null;
        }

        @Override
        public T get(String name, Locale ... locale) {
            Params.notNullOrEmpty(name, "Name");
            return this.map.get(name);
        }

        @Override
        public boolean has(String name, Locale ... locale) {
            Params.notNullOrEmpty(name, "Name");
            return this.map.containsKey(name);
        }
    }
}

