/*
 * Decompiled with CFR 0.152.
 */
package js.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import js.io.WildcardFilter;
import js.lang.BugError;
import js.lang.Config;
import js.lang.ConfigException;
import js.util.Files;
import js.util.I18nFile;
import js.util.I18nPool;
import js.util.I18nPoolFactory;
import js.util.Params;

public class I18nRepository
implements Iterable<I18nFile> {
    private final Iterable<I18nFile> iterable;
    private final boolean multiLocale;

    public I18nRepository(Config config) throws IOException {
        this.multiLocale = config.getProperty("multi-locale", Boolean.class, true);
        File baseDir = config.getProperty("base-dir", File.class);
        Params.isDirectory(baseDir, "Base directory");
        WildcardFilter fileFilter = new WildcardFilter(config.getProperty("files-pattern", "*"));
        this.iterable = this.multiLocale ? new MultipleLocale(baseDir, config.getProperty("sub-path"), fileFilter) : new SingleLocale(baseDir, fileFilter);
    }

    public <T> I18nPool<T> getPoolInstance() {
        return I18nPoolFactory.getInstance(this.multiLocale);
    }

    @Override
    public Iterator<I18nFile> iterator() {
        return this.iterable.iterator();
    }

    private static class MultipleLocale
    implements Iterable<I18nFile> {
        private static final Pattern LOCALE_PATTERN = Pattern.compile("^[a-z]{2}(?:\\-[A-Z]{2})?$");
        private List<I18nFile> files;

        public MultipleLocale(File baseDir, String subpath, FileFilter fileFilter) throws IOException {
            File[] localeDirs = baseDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File path) {
                    return path.isDirectory() && LOCALE_PATTERN.matcher(path.getName()).matches();
                }
            });
            if (localeDirs == null) {
                throw new IOException(String.format("Listing locale on base directory |%s| fails.", baseDir));
            }
            if (localeDirs.length == 0) {
                throw new BugError("No locale directories found in |%s|.", baseDir);
            }
            this.files = new ArrayList<I18nFile>();
            for (File localeDir : localeDirs) {
                String languageTag = localeDir.getName();
                if (subpath != null && !(localeDir = new File(localeDir, subpath)).isDirectory()) {
                    throw new BugError("Invalid sub-path |%s| argument. Sub-directory |%s| not found.", subpath, localeDir);
                }
                File[] localeFiles = localeDir.listFiles(fileFilter);
                if (localeFiles == null) {
                    throw new IOException(String.format("Listing files on locale directory |%s| fails.", localeDir));
                }
                if (localeFiles.length == 0) {
                    throw new BugError("No files |%s| found in repository locale directory |%s|.", fileFilter, localeDir);
                }
                for (File localeFile : localeFiles) {
                    this.files.add(new I18nFile(localeFile, Locale.forLanguageTag(languageTag)));
                }
            }
        }

        @Override
        public Iterator<I18nFile> iterator() {
            return this.files.iterator();
        }
    }

    private static class SingleLocale
    implements Iterable<I18nFile> {
        private File[] files;

        public SingleLocale(File repositoryDir, FileFilter fileFilter) throws IOException {
            this.files = repositoryDir.listFiles(fileFilter);
            if (this.files == null) {
                throw new IOException(String.format("Listing files from repository directory |%s| fails.", repositoryDir));
            }
            if (this.files == null || this.files.length == 0) {
                throw new BugError("No files |%s| found in repository directory |%s|.", fileFilter, repositoryDir);
            }
        }

        @Override
        public Iterator<I18nFile> iterator() {
            return new FileIterator();
        }

        private class FileIterator
        implements Iterator<I18nFile> {
            private int index = -1;

            @Override
            public boolean hasNext() {
                return ++this.index < SingleLocale.this.files.length;
            }

            @Override
            public I18nFile next() {
                return new I18nFile(SingleLocale.this.files[this.index]);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    public static class ConfigBuilder
    extends js.lang.ConfigBuilder {
        private static final String LOCALE_VARIABLE = "${locale}";
        private final boolean multiLocale;
        private final String baseDir;
        private final String subpath;
        private final String filesPattern;

        public ConfigBuilder(String repositoryPath, String filesPattern) {
            Params.notNullOrEmpty(repositoryPath, "Repository path");
            Params.notEmpty(filesPattern, "Files pattern");
            repositoryPath = Files.normalizePath(repositoryPath);
            int localeVarialeIndex = repositoryPath.indexOf(LOCALE_VARIABLE);
            if (localeVarialeIndex != -1) {
                this.multiLocale = true;
                this.baseDir = repositoryPath.substring(0, localeVarialeIndex);
                File baseDir = new File(this.baseDir);
                if (!baseDir.isDirectory()) {
                    throw new IllegalArgumentException(String.format("Base directory |%s| not found.", baseDir));
                }
                String subpath = "";
                int subpathIndex = repositoryPath.indexOf(File.separatorChar, localeVarialeIndex);
                if (subpathIndex != -1) {
                    subpath = repositoryPath.substring(subpathIndex + 1);
                }
                this.subpath = subpath.isEmpty() ? null : subpath;
            } else {
                this.multiLocale = false;
                this.baseDir = repositoryPath;
                this.subpath = null;
            }
            this.filesPattern = filesPattern;
        }

        @Override
        public Config build() throws ConfigException {
            Config config = new Config("i18n-repository");
            config.setProperty("multi-locale", this.multiLocale);
            config.setProperty("base-dir", this.baseDir);
            config.setProperty("sub-path", this.subpath);
            config.setProperty("files-pattern", this.filesPattern);
            return config;
        }
    }
}

