/*
 * Decompiled with CFR 0.152.
 */
package js.util;

import java.io.File;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import js.util.Strings;
import js.util.Types;

public class Params {
    protected Params() {
    }

    public static void notNull(Object parameter, String name, Object ... args) throws IllegalArgumentException {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format(name, args) + " parameter is null.");
        }
    }

    public static void notNull(Character parameter, String name, Object ... args) throws IllegalArgumentException {
        if (parameter == null || parameter.charValue() == '\u0000') {
            throw new IllegalArgumentException(String.format(name, args) + " parameter is null.");
        }
    }

    public static void empty(String parameter, String name) {
        if (parameter == null) {
            throw new IllegalArgumentException(name + " is null.");
        }
        if (!parameter.isEmpty()) {
            throw new IllegalArgumentException(name + " is not empty.");
        }
    }

    public static void empty(Collection<?> parameter, String name) {
        if (parameter == null) {
            throw new IllegalArgumentException(name + " is null empty.");
        }
        if (!parameter.isEmpty()) {
            throw new IllegalArgumentException(name + " is not empty.");
        }
    }

    public static void notEmpty(String parameter, String name) throws IllegalArgumentException {
        if (parameter != null && parameter.isEmpty()) {
            throw new IllegalArgumentException(name + " is empty.");
        }
    }

    public static void notNullOrEmpty(String parameter, String name) throws IllegalArgumentException {
        if (parameter == null) {
            throw new IllegalArgumentException(name + " is null.");
        }
        if (parameter.isEmpty()) {
            throw new IllegalArgumentException(name + " is empty.");
        }
    }

    public static void notNullOrEmpty(File parameter, String name) throws IllegalArgumentException {
        if (parameter == null) {
            throw new IllegalArgumentException(name + " path is null.");
        }
        if (parameter.getPath().isEmpty()) {
            throw new IllegalArgumentException(name + " path is empty.");
        }
    }

    public static void notNullOrEmpty(Object[] parameter, String name) throws IllegalArgumentException {
        if (parameter == null) {
            throw new IllegalArgumentException(name + " parameter is null.");
        }
        if (parameter.length == 0) {
            throw new IllegalArgumentException(name + " parameter is empty.");
        }
    }

    public static void size(Collection<?> parameter, int size, String name) throws IllegalArgumentException {
        if (parameter.size() != size) {
            throw new IllegalArgumentException(String.format("%s size is not %d.", name, size));
        }
    }

    public static void size(Map<?, ?> parameter, int size, String name) throws IllegalArgumentException {
        if (parameter.size() != size) {
            throw new IllegalArgumentException(String.format("%s size is not %d.", name, size));
        }
    }

    public static void isNumeric(String parameter, String name) {
        if (!Strings.isNumeric(parameter)) {
            throw new IllegalArgumentException(String.format("%s |%s| is not numeric.", name, parameter));
        }
    }

    public static void isFile(File parameter, String name) throws IllegalArgumentException {
        if (parameter == null) {
            throw new IllegalArgumentException(name + " is null.");
        }
        if (!parameter.exists() || parameter.isDirectory()) {
            throw new IllegalArgumentException(String.format("%s |%s| is missing or is a directory.", name, parameter.getAbsolutePath()));
        }
    }

    public static void isDirectory(File parameter, String name) throws IllegalArgumentException {
        if (parameter == null) {
            throw new IllegalArgumentException(name + " is null.");
        }
        if (!parameter.isDirectory()) {
            throw new IllegalArgumentException(String.format("%s |%s| is missing or is not a directory.", name, parameter.getAbsolutePath()));
        }
    }

    public static void belongsTo(File directory, File parameter, String name) throws IllegalArgumentException {
        if (directory == null) {
            throw new IllegalArgumentException(name + " directory is null.");
        }
        if (parameter == null) {
            throw new IllegalArgumentException(name + " file is null.");
        }
        String dirPath = directory.getAbsolutePath();
        String filePath = parameter.getAbsolutePath();
        if (!filePath.startsWith(dirPath)) {
            throw new IllegalArgumentException(String.format("%s |%s| is outside directory |%s|.", name, filePath, dirPath));
        }
    }

    public static void range(double parameter, double lowEndpoint, double highEndpoint, String name) throws IllegalArgumentException {
        if (lowEndpoint > parameter || parameter > highEndpoint) {
            throw new IllegalArgumentException(String.format("%s parameter is not in range [%d, %d].", name, lowEndpoint, highEndpoint));
        }
    }

    public static void zero(double parameter, String name) throws IllegalArgumentException {
        if (parameter != 0.0) {
            throw new IllegalArgumentException(name + " parameter is not zero.");
        }
    }

    public static void notZero(double parameter, String name) throws IllegalArgumentException {
        if (parameter == 0.0) {
            throw new IllegalArgumentException(name + " parameter is zero.");
        }
    }

    public static void positive(double parameter, String name) throws IllegalArgumentException {
        if (parameter < 0.0) {
            throw new IllegalArgumentException(name + " parameter is not positive.");
        }
    }

    public static void strictPositive(double parameter, String name) throws IllegalArgumentException {
        if (parameter <= 0.0) {
            throw new IllegalArgumentException(name + " parameter is not strict positive.");
        }
    }

    public static void EQ(long parameter, long expected, String name) throws IllegalArgumentException {
        if (parameter != expected) {
            throw new IllegalArgumentException(String.format("%s is not %d.", name, expected));
        }
    }

    public static void EQ(double parameter, double expected, String name) throws IllegalArgumentException {
        if (parameter != expected) {
            throw new IllegalArgumentException(String.format("%s is not %f.", name, expected));
        }
    }

    public static void EQ(String parameter, String expected, String name) throws IllegalArgumentException {
        if (!parameter.equals(expected)) {
            throw new IllegalArgumentException(String.format("%s is not |%s|.", name, expected));
        }
    }

    public static void EQ(char parameter, char expected, String name) throws IllegalArgumentException {
        if (parameter != expected) {
            throw new IllegalArgumentException(String.format("%s is not %c.", name, Character.valueOf(expected)));
        }
    }

    public static void GT(long parameter, long value, String name) throws IllegalArgumentException {
        if (parameter <= value) {
            throw new IllegalArgumentException(String.format("%s is not greater than %d.", name, value));
        }
    }

    public static void GT(double parameter, double value, String name) throws IllegalArgumentException {
        if (parameter <= value) {
            throw new IllegalArgumentException(String.format("%s is not greater than %f.", name, value));
        }
    }

    public static void GT(char parameter, char expected, String name) throws IllegalArgumentException {
        if (parameter <= expected) {
            throw new IllegalArgumentException(String.format("%s is not greater than %c.", name, Character.valueOf(expected)));
        }
    }

    public static void GTE(long parameter, long value, String name) throws IllegalArgumentException {
        if (parameter < value) {
            throw new IllegalArgumentException(String.format("%s is not greater than or equal %d.", name, value));
        }
    }

    public static void GTE(double parameter, double value, String name) throws IllegalArgumentException {
        if (parameter < value) {
            throw new IllegalArgumentException(String.format("%s is not greater than or equal %f.", name, value));
        }
    }

    public static void GTE(char parameter, char value, String name) throws IllegalArgumentException {
        if (parameter < value) {
            throw new IllegalArgumentException(String.format("%s is not greater than or equal %c.", name, Character.valueOf(value)));
        }
    }

    public static void LT(long parameter, long value, String name) throws IllegalArgumentException {
        if (parameter >= value) {
            throw new IllegalArgumentException(String.format("%s is not less than %d.", name, value));
        }
    }

    public static void LT(double parameter, double value, String name) throws IllegalArgumentException {
        if (parameter >= value) {
            throw new IllegalArgumentException(String.format("%s is not less than %f.", name, value));
        }
    }

    public static void LT(char parameter, char value, String name) throws IllegalArgumentException {
        if (parameter >= value) {
            throw new IllegalArgumentException(String.format("%s is not less than %c.", name, Character.valueOf(value)));
        }
    }

    public static void LTE(long parameter, long value, String name) throws IllegalArgumentException {
        if (parameter > value) {
            throw new IllegalArgumentException(String.format("%s is not less than or equal %d.", name, value));
        }
    }

    public static void LTE(double parameter, double value, String name) throws IllegalArgumentException {
        if (parameter > value) {
            throw new IllegalArgumentException(String.format("%s is not less than or equal %f.", name, value));
        }
    }

    public static void LTE(char parameter, char value, String name) throws IllegalArgumentException {
        if (parameter > value) {
            throw new IllegalArgumentException(String.format("%s is not less than or equal %c.", name, Character.valueOf(value)));
        }
    }

    public static void isTrue(boolean condition, String message, Object ... args) throws IllegalArgumentException {
        if (!condition) {
            throw new IllegalArgumentException(String.format(message, args));
        }
    }

    public static void isFalse(boolean condition, String message, Object ... args) throws IllegalArgumentException {
        if (condition) {
            throw new IllegalArgumentException(String.format(message, args));
        }
    }

    public static void isKindOf(Type parameter, Type typeToMatch, String name) {
        if (!Types.isKindOf(parameter, new Type[]{typeToMatch})) {
            throw new IllegalArgumentException(String.format("%s is not %s.", name, typeToMatch));
        }
    }
}

