/*
 * Decompiled with CFR 0.152.
 */
package js.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import js.converter.Converter;
import js.converter.ConverterRegistry;
import js.io.VariablesWriter;
import js.lang.BugError;
import js.lang.Handler;
import js.lang.Pair;
import js.log.Log;
import js.log.LogFactory;
import js.util.Files;
import js.util.Params;

public class Strings {
    private static final Log log = LogFactory.getLog(Strings.class);
    private static DateFormat ISO_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private static final Pattern QUALIFIED_CLASS_NAME;
    private static final Pattern MEMBER_NAME_PATTERN;
    private static final char[] DEFAULT_SEPARATORS;
    private static final char DECIMAL_SEPARATOR;
    private static final char GROUPING_SEPARATOR;
    private static final String REGEXP_PATTERN = "([\\/|\\.|\\*|\\?|\\||\\(|\\)|\\[|\\]|\\{|\\}|\\\\|\\^|\\$])";
    private static final String REPLACE_ARG_REX = "\\\\$1";
    private static final String DOT_REX = "\\.";
    private static final String ANY_REX = ".+";
    private static final String WHITE_SPACES = " \t\r\n.,:;";
    private static final String SEPARATORS = " \t\r\n,:;({[<";
    private static final Pattern VARIABLE_PATTERN;
    private static String[] PASSWORD_DICTIONARY;
    private static final char[] HEXA;

    protected Strings() {
    }

    public static String toCamelCase(String word) {
        if (word == null) {
            return null;
        }
        if (word.isEmpty()) {
            return "";
        }
        return Character.toUpperCase(word.charAt(0)) + word.substring(1).toLowerCase();
    }

    public static String toTitleCase(String string) {
        if (string == null) {
            return null;
        }
        if (string.isEmpty()) {
            return "";
        }
        List<String> words = Strings.split(string, '-', '_', ' ', '/', '\\');
        StringBuilder title = new StringBuilder(Strings.toCamelCase(words.get(0)));
        for (int i = 1; i < words.size(); ++i) {
            title.append(' ');
            title.append(Strings.toCamelCase(words.get(i)));
        }
        return title.toString();
    }

    public static String dashedToMemberName(String dashedName) {
        if (dashedName == null) {
            return null;
        }
        if (dashedName.isEmpty()) {
            return "";
        }
        String[] words = dashedName.split("-");
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String word : words) {
            if (word.isEmpty()) continue;
            if (first) {
                first = false;
                sb.append(word);
                continue;
            }
            sb.append(Character.toUpperCase(word.charAt(0)));
            sb.append(word.substring(1));
        }
        return sb.toString();
    }

    @Deprecated
    public static String toMemberName(String dashedName) {
        return Strings.dashedToMemberName(dashedName);
    }

    public static String enumToMemberName(String enumName) {
        if (enumName == null) {
            return null;
        }
        String[] words = enumName.split("_");
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String word : words) {
            if (word.isEmpty()) continue;
            if (first) {
                first = false;
                sb.append(word.toLowerCase());
                continue;
            }
            sb.append(Character.toUpperCase(word.charAt(0)));
            sb.append(word.substring(1).toLowerCase());
        }
        return sb.toString();
    }

    public static String enumToMemberName(Enum<?> enumName) {
        if (enumName == null) {
            return null;
        }
        return Strings.enumToMemberName(enumName.name());
    }

    public static String memberToDashCase(String memberName) {
        if (memberName == null) {
            return null;
        }
        int length = memberName.length();
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = memberName.charAt(i);
            if (Character.isLowerCase(c)) {
                builder.append(c);
                continue;
            }
            c = Character.toLowerCase(c);
            if (i > 0) {
                builder.append('-');
            }
            builder.append(c);
        }
        return builder.toString();
    }

    @Deprecated
    public static String toDashCase(String memberName) {
        return Strings.memberToDashCase(memberName);
    }

    public static String toISO(Date date) {
        return ISO_DATE_FORMAT.format(date);
    }

    public static String toString(Object ... objects) {
        if (objects.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(Strings.toString(objects[0]));
        for (int i = 1; i < objects.length; ++i) {
            sb.append(":");
            sb.append(Strings.toString(objects[i]));
        }
        return sb.toString();
    }

    private static String toString(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Class) {
            return ((Class)object).getName();
        }
        if (!(object instanceof Throwable)) {
            return object.toString();
        }
        Throwable t = (Throwable)object;
        if (t.getCause() == null) {
            return t.toString();
        }
        int level = 0;
        StringBuilder sb = new StringBuilder();
        while (true) {
            sb.append(t.getClass().getName());
            sb.append(":");
            sb.append(" ");
            if (++level == 8) {
                sb.append("...");
                break;
            }
            if (t.getCause() == null) {
                String s = t.getMessage();
                if (s == null) {
                    t.getClass().getName();
                }
                sb.append(s);
                break;
            }
            t = t.getCause();
        }
        return sb.toString();
    }

    @Deprecated
    public static String toPlainText(String text) {
        return Strings.toPlainText(text, 0, Integer.MAX_VALUE);
    }

    @Deprecated
    public static String toPlainText(String text, int offset, int capacity) {
        PlainTextState state = PlainTextState.TEXT;
        StringBuilder plainText = new StringBuilder();
        block5: for (int i = offset; i < text.length() && plainText.length() <= capacity; ++i) {
            char c = text.charAt(i);
            switch (state) {
                case TEXT: {
                    if (c == '<') {
                        state = PlainTextState.START_TAG;
                        continue block5;
                    }
                    plainText.append(c);
                    continue block5;
                }
                case START_TAG: {
                    if (c == '/') {
                        state = PlainTextState.END_TAG;
                        continue block5;
                    }
                    if (c != '>') continue block5;
                    state = PlainTextState.TEXT;
                    continue block5;
                }
                case END_TAG: {
                    if (c == 'p') {
                        plainText.append("\r\n");
                    }
                    if (c != '>') continue block5;
                    state = PlainTextState.TEXT;
                }
            }
        }
        return plainText.toString();
    }

    public static String getMethodAccessor(String prefix, String memberName) throws IllegalArgumentException {
        Params.notNullOrEmpty(prefix, "Prefix");
        Params.notNullOrEmpty(memberName, "Member name");
        StringBuilder builder = new StringBuilder();
        builder.append(prefix);
        String[] parts = memberName.split("-+");
        for (int i = 0; i < parts.length; ++i) {
            if (parts.length <= 0) continue;
            builder.append(Character.toUpperCase(parts[i].charAt(0)));
            builder.append(parts[i].substring(1));
        }
        return builder.toString();
    }

    public static boolean isQualifiedClassName(String name) {
        return QUALIFIED_CLASS_NAME.matcher(name).matches();
    }

    public static boolean isMemberName(String name) {
        if (name == null) {
            return false;
        }
        Matcher matcher = MEMBER_NAME_PATTERN.matcher(name);
        return matcher.find();
    }

    public static String concat(Object ... objects) {
        StringBuilder sb = new StringBuilder();
        for (Object object : objects) {
            if (object == null) continue;
            sb.append(object);
        }
        return sb.toString();
    }

    public static String join(Object[] objects) {
        return Strings.join(objects, " ");
    }

    public static String join(Object[] objects, char separator) {
        return Strings.join(objects, Character.toString(separator));
    }

    public static String join(Object[] objects, String separator) {
        return objects != null ? Strings.join(Arrays.asList(objects), separator) : null;
    }

    public static String join(Iterable<?> objects) {
        return Strings.join(objects, " ");
    }

    public static String join(Iterable<?> objects, char separator) {
        return Strings.join(objects, Character.toString(separator));
    }

    public static String join(Iterable<?> objects, String separator) {
        if (objects == null) {
            return null;
        }
        if (separator == null) {
            separator = " ";
        }
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (Object object : objects) {
            String value;
            if (object == null || (value = object instanceof String ? (String)object : object.toString()).isEmpty()) continue;
            if (first) {
                first = false;
            } else {
                builder.append(separator);
            }
            builder.append(value);
        }
        return builder.toString();
    }

    public static List<String> split(String string, char ... separators) {
        if (string == null) {
            return null;
        }
        class ItemsList {
            List<String> list = new ArrayList<String>();

            ItemsList() {
            }

            void add(StringBuilder wordBuilder) {
                String value = wordBuilder.toString().trim();
                if (!value.isEmpty()) {
                    this.list.add(value);
                }
            }
        }
        ItemsList itemsList = new ItemsList();
        StringBuilder itemBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!Strings.isSeparator(c, separators)) {
                itemBuilder.append(c);
            }
            if (itemBuilder.length() <= 0 || !Strings.isSeparator(c, separators)) continue;
            itemsList.add(itemBuilder);
            itemBuilder.setLength(0);
        }
        itemsList.add(itemBuilder);
        return itemsList.list;
    }

    private static boolean isSeparator(char character, char ... separators) {
        if (separators.length == 0) {
            separators = DEFAULT_SEPARATORS;
        }
        for (int i = 0; i < separators.length; ++i) {
            if (character != separators[i]) continue;
            return true;
        }
        return false;
    }

    public static List<String> split(String string, String separator) {
        int endIndex;
        if (string == null || separator == null) {
            return null;
        }
        int separatorLength = separator.length();
        ArrayList<String> list = new ArrayList<String>();
        if (separator.isEmpty()) {
            return list;
        }
        int fromIndex = 0;
        while ((endIndex = string.indexOf(separator, fromIndex)) != -1) {
            if (fromIndex < endIndex) {
                list.add(string.substring(fromIndex, endIndex).trim());
            }
            fromIndex = endIndex + separatorLength;
        }
        if (fromIndex < string.length()) {
            list.add(string.substring(fromIndex).trim());
        }
        return list;
    }

    public static <T> List<T> split(String string, String separator, Class<T> type) {
        int endIndex;
        if (string == null || separator == null) {
            return null;
        }
        Converter converter = ConverterRegistry.getConverter();
        int separatorLength = separator.length();
        ArrayList<T> list = new ArrayList<T>();
        if (separator.isEmpty()) {
            return list;
        }
        int fromIndex = 0;
        while ((endIndex = string.indexOf(separator, fromIndex)) != -1) {
            if (fromIndex < endIndex) {
                list.add(converter.asObject(string.substring(fromIndex, endIndex).trim(), type));
            }
            fromIndex = endIndex + separatorLength;
        }
        if (fromIndex < string.length()) {
            list.add(converter.asObject(string.substring(fromIndex).trim(), type));
        }
        return list;
    }

    public static List<Pair> splitPairs(String string, char pairsSeparator, char componentsSeparator) {
        if (string == null) {
            return null;
        }
        string = string.trim();
        int length = string.length();
        ArrayList<Pair> list = new ArrayList<Pair>();
        int beginIndex = 0;
        for (int endIndex = 0; endIndex < length; ++endIndex) {
            if (string.charAt(endIndex) != pairsSeparator) continue;
            if (endIndex > beginIndex) {
                list.add(Strings.pair(string.substring(beginIndex, endIndex), componentsSeparator));
            }
            beginIndex = ++endIndex;
        }
        if (beginIndex < length) {
            list.add(Strings.pair(string.substring(beginIndex), componentsSeparator));
        }
        return list;
    }

    private static Pair pair(String string, char separator) {
        int separatorIndex = string.indexOf(separator);
        if (separatorIndex == -1) {
            throw new BugError("Missing pair separator. Cannot initialize pair instance.", new Object[0]);
        }
        String first = string.substring(0, separatorIndex).trim();
        String second = string.substring(separatorIndex + 1).trim();
        return new Pair(first, second);
    }

    private static boolean isNumericSuffix(char c) {
        if (c == 'L') {
            return true;
        }
        if (c == 'F') {
            return true;
        }
        if (c == 'D') {
            return true;
        }
        if (c == 'l') {
            return true;
        }
        if (c == 'f') {
            return true;
        }
        return c == 'd';
    }

    public static boolean isNumeric(String string) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        State state = State.SIGN;
        block8: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (state) {
                case SIGN: {
                    if (c == '-' || c == '+') {
                        state = State.INTEGER;
                        continue block8;
                    }
                    if (c == DECIMAL_SEPARATOR) {
                        state = State.FRACTIONAL;
                        continue block8;
                    }
                    if (Character.isDigit(c)) {
                        state = State.INTEGER;
                        continue block8;
                    }
                    return false;
                }
                case INTEGER: {
                    if (Character.isDigit(c) || c == GROUPING_SEPARATOR) continue block8;
                    if (c == DECIMAL_SEPARATOR) {
                        state = State.FRACTIONAL;
                        continue block8;
                    }
                    if (c == 'e' || c == 'E') {
                        state = State.EXPONENT_SIGN;
                        continue block8;
                    }
                    if (Strings.isNumericSuffix(c)) {
                        state = State.END;
                        continue block8;
                    }
                    return false;
                }
                case FRACTIONAL: {
                    if (c == 'e' || c == 'E') {
                        state = State.EXPONENT_SIGN;
                        continue block8;
                    }
                    if (Strings.isNumericSuffix(c)) {
                        state = State.END;
                        continue block8;
                    }
                    if (Character.isDigit(c)) continue block8;
                    return false;
                }
                case EXPONENT_SIGN: {
                    if (c == '-' || c == '+') {
                        state = State.EXPONENT;
                        continue block8;
                    }
                    if (Character.isDigit(c)) continue block8;
                    return false;
                }
                case EXPONENT: {
                    if (Strings.isNumericSuffix(c)) {
                        state = State.END;
                        continue block8;
                    }
                    if (Character.isDigit(c)) continue block8;
                    return false;
                }
                case END: {
                    return false;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return true;
    }

    public static boolean isInteger(String string) {
        int startIndex;
        if (string == null || string.isEmpty()) {
            return false;
        }
        int l = string.length();
        for (int i = startIndex = string.charAt(0) == '-' ? 1 : (string.charAt(0) == '+' ? 1 : 0); i < l; ++i) {
            if (string.charAt(i) == GROUPING_SEPARATOR || Character.isDigit(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String escapeXML(String text) {
        StringWriter writer = new StringWriter();
        try {
            Strings.escapeXML(text, writer);
        }
        catch (IOException e) {
            throw new BugError("IO failure while attempting to write to string.", new Object[0]);
        }
        return writer.toString();
    }

    public static void escapeXML(String text, Writer writer) throws IOException {
        if (text == null) {
            return;
        }
        int l = text.length();
        block7: for (int i = 0; i < l; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '\"': {
                    writer.write("&quot;");
                    continue block7;
                }
                case '\'': {
                    writer.write("&apos;");
                    continue block7;
                }
                case '&': {
                    writer.write("&amp;");
                    continue block7;
                }
                case '<': {
                    writer.write("&lt;");
                    continue block7;
                }
                case '>': {
                    writer.write("&gt;");
                    continue block7;
                }
                default: {
                    writer.write(c);
                }
            }
        }
    }

    public static String escapeRegExp(String string) {
        if (string == null) {
            return null;
        }
        return string.replaceAll(REGEXP_PATTERN, REPLACE_ARG_REX);
    }

    public static String escapeFilesPattern(String filesPattern) {
        if (filesPattern == null) {
            return null;
        }
        return filesPattern.replace(".", DOT_REX).replace("*", ANY_REX);
    }

    public static String last(String string, char separator) {
        if (string == null) {
            return null;
        }
        if (string.isEmpty()) {
            return "";
        }
        return string.substring(string.lastIndexOf(separator) + 1);
    }

    public static String firstSentence(String text) {
        if (text == null) {
            return null;
        }
        int length = text.length();
        boolean sentenceSeparator = false;
        block4: for (int i = 0; i < length; ++i) {
            switch (text.charAt(i)) {
                case '!': 
                case '.': 
                case ';': 
                case '?': {
                    sentenceSeparator = true;
                    continue block4;
                }
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    if (!sentenceSeparator) continue block4;
                    return text.substring(0, i);
                }
                default: {
                    sentenceSeparator = false;
                }
            }
        }
        return text;
    }

    public static String firstWord(String sentence) {
        boolean includeSeparator;
        String separators;
        if (sentence == null) {
            return null;
        }
        if (sentence.isEmpty()) {
            return sentence;
        }
        int length = sentence.length();
        int separatorIndex = 0;
        char c = sentence.charAt(0);
        switch (c) {
            case '(': {
                separators = ")";
                separatorIndex = 1;
                includeSeparator = true;
                break;
            }
            case '{': {
                separators = "}";
                separatorIndex = 1;
                includeSeparator = true;
                break;
            }
            case '[': {
                separators = "]";
                separatorIndex = 1;
                includeSeparator = true;
                break;
            }
            case '<': {
                separators = ">";
                separatorIndex = 1;
                includeSeparator = true;
                break;
            }
            default: {
                separators = SEPARATORS;
                includeSeparator = false;
            }
        }
        block6: while (separatorIndex < length) {
            c = sentence.charAt(separatorIndex);
            if (c == '.') {
                int nextIndex = separatorIndex + 1;
                if (nextIndex == length) break;
                boolean ellipsis = false;
                while (sentence.charAt(nextIndex) == '.') {
                    if (++nextIndex == length) break block6;
                    ellipsis = true;
                    ++separatorIndex;
                }
                if (separators.indexOf(sentence.charAt(nextIndex)) != -1) {
                    if (!ellipsis) break;
                    ++separatorIndex;
                    break;
                }
            } else if (separators.indexOf(c) != -1) break;
            ++separatorIndex;
        }
        if (includeSeparator) {
            ++separatorIndex;
        }
        return sentence.substring(0, separatorIndex);
    }

    public static String removeFirstWord(String sentence) {
        int i;
        if (sentence == null) {
            return null;
        }
        if (sentence.isEmpty()) {
            return sentence;
        }
        String firstWord = Strings.firstWord(sentence);
        if (firstWord.length() == sentence.length()) {
            return sentence;
        }
        for (i = firstWord.length(); i < sentence.length() && WHITE_SPACES.indexOf(sentence.charAt(i)) != -1; ++i) {
        }
        return sentence.substring(i);
    }

    public static String replaceAll(String source, Pattern pattern, Handler<String, String> handler) {
        Matcher matcher = pattern.matcher(source);
        StringBuilder builder = new StringBuilder();
        int start = 0;
        while (matcher.find(start)) {
            builder.append(source.substring(start, matcher.start()));
            if (matcher.groupCount() == 0) {
                builder.append(handler.handle(source.substring(matcher.start(), matcher.end())));
            } else {
                for (int i = 0; i < matcher.groupCount(); ++i) {
                    builder.append(handler.handle(matcher.group(i + 1)));
                }
            }
            start = matcher.end();
        }
        builder.append(source.substring(start));
        return builder.toString();
    }

    public static String injectProperties(final String string) throws BugError {
        return Strings.replaceAll(string, VARIABLE_PATTERN, new Handler<String, String>(){

            @Override
            public String handle(String variableName) {
                String property = System.getProperty(variableName);
                if (property == null) {
                    throw new BugError("Missing system property |%s|. String |%s| variable injection aborted.", variableName, string);
                }
                return property;
            }
        });
    }

    public static String injectVariables(String template, Map<String, String> variables) {
        VariablesWriter writer = new VariablesWriter(variables);
        try {
            Files.copy(new StringReader(template), writer);
        }
        catch (IOException e) {
            log.error(e);
        }
        return writer.toString();
    }

    public static String trim(String string, char garbage) {
        int endIndex;
        int beginIndex;
        char suffix;
        if (string == null) {
            return null;
        }
        int length = string.length();
        char prefix = garbage;
        switch (prefix) {
            case '(': {
                suffix = ')';
                break;
            }
            case '[': {
                suffix = ']';
                break;
            }
            case '{': {
                suffix = '}';
                break;
            }
            case '<': {
                suffix = '>';
                break;
            }
            default: {
                suffix = prefix;
            }
        }
        for (beginIndex = 0; beginIndex < length && string.charAt(beginIndex) == prefix; ++beginIndex) {
        }
        if (beginIndex == length) {
            return "";
        }
        for (endIndex = length - 1; endIndex >= 0 && string.charAt(endIndex) == suffix; --endIndex) {
        }
        return string.substring(beginIndex, endIndex + 1);
    }

    public static String trim(String string) {
        int endIndex;
        int beginIndex;
        if (string == null) {
            return null;
        }
        int length = string.length();
        for (beginIndex = 0; beginIndex < length && Character.isWhitespace(string.charAt(beginIndex)); ++beginIndex) {
        }
        for (endIndex = length - 1; endIndex >= 0 && Character.isWhitespace(string.charAt(endIndex)); --endIndex) {
        }
        if (++endIndex <= beginIndex) {
            return "";
        }
        return string.substring(beginIndex, endIndex);
    }

    public static String removeTrailing(String string, char c) {
        if (string == null) {
            return null;
        }
        int lastCharIndex = string.length() - 1;
        return string.charAt(lastCharIndex) == c ? string.substring(0, lastCharIndex) : string;
    }

    public static String format(String format, Object ... args) {
        if (format == null) {
            return null;
        }
        if (format.isEmpty()) {
            return "";
        }
        if (args.length == 0) {
            return format;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i] instanceof Class) {
                args[i] = ((Class)args[i]).getCanonicalName();
                continue;
            }
            if (args[i] instanceof Throwable) {
                String s = ((Throwable)args[i]).getMessage();
                if (s == null) {
                    s = args[i].getClass().getCanonicalName();
                }
                args[i] = s;
                continue;
            }
            if (args[i] instanceof Thread) {
                Thread thread = (Thread)args[i];
                StringBuilder sb = new StringBuilder();
                sb.append(thread.getName());
                sb.append(':');
                sb.append(thread.getId());
                args[i] = sb.toString();
                continue;
            }
            if (!(args[i] instanceof File)) continue;
            args[i] = ((File)args[i]).getAbsolutePath();
        }
        try {
            return String.format(format, args);
        }
        catch (IllegalFormatException e) {
            log.error("Format operation aborted due to error on string format. Returns original, not formated string. Root cause is: ", e);
            return format;
        }
    }

    public static int indexOneOf(CharSequence string, char ... chars) {
        for (int i = 0; i < string.length(); ++i) {
            for (int j = 0; j < chars.length; ++j) {
                if (string.charAt(i) != chars[j]) continue;
                return i;
            }
        }
        return -1;
    }

    public static String load(InputStream inputStream, Integer ... maxCount) throws IOException {
        return Strings.load(new InputStreamReader(inputStream, "UTF-8"), maxCount);
    }

    public static String load(File file, Integer ... maxCount) throws IOException {
        return Strings.load(new FileReader(file), maxCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String load(Reader reader, Integer ... maxCount) throws IOException {
        long maxCountValue = maxCount.length > 0 ? (long)maxCount[0].intValue() : Long.MAX_VALUE;
        StringWriter writer = new StringWriter();
        try {
            int readChars;
            char[] buffer = new char[1024];
            while ((readChars = reader.read(buffer, 0, (int)Math.min((long)buffer.length, maxCountValue))) > 0) {
                writer.write(buffer, 0, readChars);
                maxCountValue -= (long)readChars;
            }
        }
        finally {
            Files.close(reader);
            Files.close(writer);
        }
        return writer.toString();
    }

    public static void save(CharSequence chars, File file) throws IOException {
        Strings.save(chars, new FileWriter(Files.mkdirs(file)));
    }

    public static void save(CharSequence chars, Writer writer) throws IOException {
        if (chars != null) {
            StringReader reader = new StringReader(chars.toString());
            Files.copy(reader, writer);
        }
    }

    public static void save(CharSequence chars, OutputStream outputStream) throws IOException {
        if (chars != null) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(chars.toString().getBytes());
            Files.copy((InputStream)inputStream, outputStream);
        }
    }

    public static String UUID() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static String setPrefix(String text, String prefix) {
        if (text == null) {
            return null;
        }
        if (!text.startsWith(prefix)) {
            text = prefix + text;
        }
        return text;
    }

    public static String generatePassword(int length) {
        Params.strictPositive(length, "Password length");
        StringBuilder password = new StringBuilder(length);
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            String charCategory = PASSWORD_DICTIONARY[random.nextInt(PASSWORD_DICTIONARY.length)];
            int position = random.nextInt(charCategory.length());
            password.append(charCategory.charAt(position));
        }
        return new String(password);
    }

    public static String md5(String text) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new BugError("Java runtime without MD5 support.", new Object[0]);
        }
        md.update(text.getBytes());
        byte[] md5 = md.digest();
        char[] buffer = new char[32];
        for (int i = 0; i < 16; ++i) {
            buffer[i * 2] = HEXA[(md5[i] & 0xF0) >> 4];
            buffer[i * 2 + 1] = HEXA[md5[i] & 0xF];
        }
        return new String(buffer);
    }

    public static String getProtocol(String url) {
        if (url == null) {
            return null;
        }
        int protocolSeparatorIndex = url.indexOf("://");
        if (protocolSeparatorIndex == -1) {
            return null;
        }
        return url.substring(0, protocolSeparatorIndex).toLowerCase();
    }

    static {
        ISO_DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
        QUALIFIED_CLASS_NAME = Pattern.compile("^([a-z][a-z0-9]*(?:\\.[a-z][a-z0-9]*)*(?:\\.[A-Z][a-zA-Z0-9]*)+)$");
        MEMBER_NAME_PATTERN = Pattern.compile("^[a-z][a-z0-9_]*(?:[A-Z][a-z0-9_]*)*$");
        DEFAULT_SEPARATORS = new char[]{' '};
        DECIMAL_SEPARATOR = DecimalFormatSymbols.getInstance().getDecimalSeparator();
        GROUPING_SEPARATOR = DecimalFormatSymbols.getInstance().getGroupingSeparator();
        VARIABLE_PATTERN = Pattern.compile("\\$\\{([^\\}]+)\\}");
        PASSWORD_DICTIONARY = new String[]{"abcdefghijklmnopqrstuvwxyz", "ABCDEFGHIJKLMNOPQRSTUVWXYZ", "0123456789", "!@#$%&*()_+-=[]|,./?><"};
        HEXA = "0123456789abcdef".toCharArray();
    }

    private static enum State {
        NONE,
        SIGN,
        INTEGER,
        FRACTIONAL,
        EXPONENT_SIGN,
        EXPONENT,
        END;

    }

    @Deprecated
    private static enum PlainTextState {
        TEXT,
        START_TAG,
        END_TAG;

    }
}

