/*
 * Decompiled with CFR 0.152.
 */
package js.util;

import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import js.converter.ConverterRegistry;
import js.io.VariablesWriter;
import js.log.Log;
import js.log.LogFactory;
import js.util.Files;
import js.util.Params;

public class TextTemplate {
    private static final Log log = LogFactory.getLog(TextTemplate.class);
    private String template;
    private Map<String, String> variables = new HashMap<String, String>();

    public TextTemplate(String template) {
        this.template = template;
    }

    public void put(String name, Object value) {
        Params.notNullOrEmpty(name, "Variable name");
        Params.notNull(value, "Variable %s value", name);
        this.variables.put(name, ConverterRegistry.getConverter().asString(value));
    }

    public String toString() {
        VariablesWriter writer = new VariablesWriter(this.variables);
        try {
            Files.copy(new StringReader(this.template), writer);
        }
        catch (IOException e) {
            log.error(e);
        }
        return writer.toString();
    }
}

